/*
 * Decompiled with CFR 0.152.
 */
package it.polito.NGS;

import it.polito.NGS.GTFInterface;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import net.sf.samtools.SAMRecord;
import org.biojava3.genome.parsers.gff.FeatureI;
import org.biojava3.genome.parsers.gff.FeatureList;
import org.biojava3.genome.parsers.gff.GFF3Reader;
import org.biojava3.genome.parsers.gff.Location;

public class BiojavaGFF
implements GTFInterface {
    String file_path;
    FeatureList gtffeatures;

    public BiojavaGFF(String gtfpath) throws IOException {
        if (gtfpath == null) {
            throw new IOException("ERROR: The gtf path is invalid");
        }
        if (!new File(gtfpath).exists()) {
            throw new IOException("ERROR: The gtf file " + gtfpath + " does not exist");
        }
        ArrayList<String> indexes = new ArrayList<String>();
        indexes.add("transcript_id");
        indexes.add("gene_id");
        this.gtffeatures = GFF3Reader.read(gtfpath, indexes);
        this.file_path = gtfpath;
    }

    public BiojavaGFF(String gtfpath, List<String> indexes) throws IOException {
        this.gtffeatures = GFF3Reader.read(gtfpath, indexes);
    }

    @Override
    public Collection<String> getTranscriptsByGeneId(String xloc) {
        TreeSet<String> transcripts = new TreeSet<String>();
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", xloc);
        for (FeatureI f : fl) {
            transcripts.add(f.getAttribute("transcript_id"));
        }
        return transcripts;
    }

    @Override
    public String getRefByTranscriptID(String transcriptID) {
        FeatureList fl = this.gtffeatures.selectByAttribute("transcript_id", transcriptID);
        Iterator fl_i = fl.iterator();
        if (fl_i.hasNext()) {
            return ((FeatureI)fl_i.next()).seqname();
        }
        return null;
    }

    public Vector<Location> getLocationListByTranscriptId(String transcriptid) {
        FeatureList fl = this.gtffeatures.selectByAttribute("transcript_id", transcriptid);
        Vector<Location> LocationList = new Vector<Location>();
        fl.sortByStart();
        Iterator fl_i = fl.iterator();
        while (fl_i.hasNext()) {
            Location temp_l = ((FeatureI)fl_i.next()).location();
            LocationList.add(temp_l);
        }
        if (((Location)LocationList.get(0)).isNegative()) {
            Vector<Location> LocationList_reversed = new Vector<Location>();
            int i = LocationList.size() - 1;
            while (i >= 0) {
                LocationList_reversed.add(LocationList.get(i));
                --i;
            }
            return LocationList_reversed;
        }
        return LocationList;
    }

    @Override
    public char getTranscriptStrand(String transcript_id) {
        FeatureList fl = this.gtffeatures.selectByAttribute("transcript_id", transcript_id);
        if (fl.size() == 0) {
            System.err.println("Wrong transcript_id: no feature returned");
        }
        boolean positive = false;
        boolean negative = false;
        for (FeatureI feature : fl) {
            Location loc = feature.location();
            String cl = feature.getAttribute("class_code");
            if (cl != null && (cl.equalsIgnoreCase("x") || cl.equalsIgnoreCase("s") || cl.equalsIgnoreCase("i"))) {
                if (loc.isNegative()) {
                    positive = true;
                    continue;
                }
                negative = true;
                continue;
            }
            if (loc.isNegative()) {
                negative = true;
                continue;
            }
            positive = true;
        }
        if (positive && !negative) {
            return '+';
        }
        if (!positive && negative) {
            return '-';
        }
        return '.';
    }

    @Override
    public List<Location> getTranscriptLocations(String transcript_id) {
        return this.getLocationListByTranscriptId(transcript_id);
    }

    @Override
    public List<String> getGeneNameByGeneId(String geneid) {
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", geneid);
        Collection<String> names = fl.attributeValues("gene_name");
        ArrayList<String> result = new ArrayList<String>(names.size());
        result.addAll(names);
        return result;
    }

    @Override
    public String getReferenceNameByGeneId(String geneid) {
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", geneid);
        if (fl.size() == 0) {
            return "";
        }
        String ref = ((FeatureI)fl.get(0)).seqname();
        return ref;
    }

    @Override
    public Location getLocationByGeneId(String geneid) {
        Location temp_l;
        int start = 0;
        int end = 0;
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", geneid);
        Iterator fl_i = fl.iterator();
        if (fl_i.hasNext()) {
            temp_l = ((FeatureI)fl_i.next()).location();
            if (temp_l.isNegative()) {
                temp_l = temp_l.opposite();
            }
            start = temp_l.start();
            end = temp_l.end();
        }
        while (fl_i.hasNext()) {
            temp_l = ((FeatureI)fl_i.next()).location();
            if (temp_l.isNegative()) {
                temp_l = temp_l.opposite();
            }
            if (start > temp_l.start()) {
                start = temp_l.start();
            }
            if (end >= temp_l.end()) continue;
            end = temp_l.end();
        }
        return new Location(start, end);
    }

    @Override
    public boolean samRecordisinTranscript(SAMRecord record, String transcript_id) {
        List<Location> locs = this.getTranscriptLocations(transcript_id);
        int start = record.getAlignmentStart();
        int end = record.getAlignmentEnd();
        for (Location loc : locs) {
            if (start > loc.end() || end < loc.start()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Location> getLocationsByGeneId(String geneid) {
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", geneid);
        Iterator fl_i = fl.iterator();
        ArrayList<Location> locs = new ArrayList<Location>();
        while (fl_i.hasNext()) {
            Location temp_l = ((FeatureI)fl_i.next()).location();
            if (temp_l.isNegative()) {
                locs.add(temp_l.opposite());
                continue;
            }
            locs.add(temp_l);
        }
        return locs;
    }

    @Override
    public FeatureList getFeaturesByGeneId(String xloc) {
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", xloc);
        return fl;
    }

    @Override
    public String getStrandbyGeneId(String gene_id) {
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", gene_id);
        int negative = 0;
        int positive = 0;
        for (FeatureI feature : fl) {
            Location loc = feature.location();
            String cl = feature.getAttribute("class_code");
            if (loc.length() == 0) continue;
            if (cl != null && (cl.equalsIgnoreCase("x") || cl.equalsIgnoreCase("s") || cl.equalsIgnoreCase("i"))) {
                if (loc.isNegative()) {
                    positive += loc.length();
                    continue;
                }
                negative += loc.length();
                continue;
            }
            if (loc.isNegative()) {
                negative += loc.length();
                continue;
            }
            positive += loc.length();
        }
        if (positive > negative) {
            return "+";
        }
        if (negative > positive) {
            return "-";
        }
        return ".";
    }

    @Override
    public Collection<String> getGenesID() {
        return this.gtffeatures.attributeValues("gene_id");
    }

    @Override
    public String getFilePath() {
        return this.file_path;
    }

    @Override
    public String getGeneIDbyTranscript(String transcript) {
        FeatureList result = this.gtffeatures.selectByAttribute("transcript_id", transcript);
        if (result.size() == 0) {
            return "";
        }
        return ((FeatureI)result.get(0)).getAttribute("gene_id");
    }

    @Override
    public String getGeneNamebyTranscript(String transcript) {
        FeatureList result = this.gtffeatures.selectByAttribute("transcript_id", transcript);
        if (result.size() == 0) {
            return "";
        }
        String name = ((FeatureI)result.get(0)).getAttribute("gene_name");
        if (name == null) {
            return "";
        }
        return name;
    }
}

