/*
 * Decompiled with CFR 0.152.
 */
package it.polito.bellerophontes.util;

import it.polito.bellerophontes.data.Candidate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CandidatesParser {
    public static List<Candidate> getCandidatesFromFilterHSResult(String filterHSresult) throws IOException {
        FileReader fr = new FileReader(new File(filterHSresult));
        BufferedReader br = new BufferedReader(fr);
        ArrayList<Candidate> result = new ArrayList<Candidate>();
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] splitted = line.split("\t");
            String xloc1 = splitted[1];
            String xloc2 = splitted[7];
            result.add(new Candidate(xloc1, xloc2));
        }
        return result;
    }

    public static List<Candidate> getCandidatesFromCandstatout(String candstatout_path) throws IOException {
        FileReader fr_encompassingregions = new FileReader(new File(candstatout_path));
        BufferedReader br_encompassingregions = new BufferedReader(fr_encompassingregions);
        String line = null;
        ArrayList<Candidate> result = new ArrayList<Candidate>();
        while ((line = br_encompassingregions.readLine()) != null) {
            if (line.matches("^\t.*")) continue;
            String[] splitted = line.split("\t");
            try {
                String xloc1 = splitted[0];
                String xloc2 = splitted[3];
                result.add(new Candidate(xloc1, xloc2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static List<Candidate> getCandidatesFromEncompassing(String encompassing_path) throws IOException {
        FileReader fr_encompassingregions = new FileReader(new File(encompassing_path));
        BufferedReader br_encompassingregions = new BufferedReader(fr_encompassingregions);
        String line = null;
        ArrayList<Candidate> result = new ArrayList<Candidate>();
        while ((line = br_encompassingregions.readLine()) != null) {
            if (line.matches("^\t.*")) continue;
            String[] splitted = line.split("\t");
            String gene_name1 = splitted[0].replaceAll(",$", "");
            String gene_name2 = splitted[1].replaceAll(",$", "");
            result.add(new Candidate(gene_name1, gene_name2));
        }
        return result;
    }
}

