/*
 * Decompiled with CFR 0.152.
 */
package it.polito.bellerophontes.util;

import it.polito.bellerophontes.util.GenericBinaryFileBuffer;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class GenericExternalSort<T> {
    static int DEFAULTMAXTEMPFILES = 1024;

    public static long estimateBestSizeOfBlocks(File filetobesorted, int maxtmpfiles) {
        long freemem;
        long sizeoffile = filetobesorted.length() * 2L;
        long blocksize = sizeoffile / (long)maxtmpfiles + (long)(sizeoffile % (long)maxtmpfiles == 0L ? 0 : 1);
        if (blocksize < (freemem = Runtime.getRuntime().freeMemory()) / 2L) {
            blocksize = freemem / 2L;
        }
        return blocksize;
    }

    public static <T> List<File> sortInBatch(File file, Comparator<T> cmp, int maxtmpfiles) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        long blocksize = GenericExternalSort.estimateBestSizeOfBlocks(file, maxtmpfiles);
        try {
            ArrayList<Object> tmplist = new ArrayList<Object>();
            Object line = new Object();
            try {
                while (line != null) {
                    long currentblocksize = 0L;
                    while ((line = ois.readObject()) != null && currentblocksize < blocksize) {
                        tmplist.add(line);
                        ++currentblocksize;
                    }
                    files.add(GenericExternalSort.sortAndSave(tmplist, cmp));
                    tmplist.clear();
                }
            }
            catch (EOFException oef) {
                if (tmplist.size() > 0) {
                    files.add(GenericExternalSort.sortAndSave(tmplist, cmp));
                    tmplist.clear();
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        finally {
            ois.close();
        }
        return files;
    }

    public static <T> File sortAndSave(List<T> tmplist, Comparator<T> cmp) throws IOException {
        Collections.sort(tmplist, cmp);
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile", new File(System.getProperty("user.dir")));
        newtmpfile.deleteOnExit();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(newtmpfile));
        try {
            for (T r : tmplist) {
                oos.writeObject(r);
            }
        }
        finally {
            oos.close();
        }
        return newtmpfile;
    }

    /*
     * Unable to fully structure code
     */
    public static <T> int mergeSortedFiles(List<File> files, File outputfile, final Comparator<T> cmp) throws IOException {
        pq = new PriorityQueue<GenericBinaryFileBuffer>(11, new Comparator<GenericBinaryFileBuffer<T>>(){

            @Override
            public int compare(GenericBinaryFileBuffer<T> i, GenericBinaryFileBuffer<T> j) {
                return cmp.compare(i.peek(), j.peek());
            }
        });
        for (File f : files) {
            bfb = new GenericBinaryFileBuffer(f);
            pq.add(bfb);
        }
        oos = new ObjectOutputStream(new FileOutputStream(outputfile));
        rowcounter = 0;
        try {
            while (pq.size() > 0) {
                bfb = (GenericBinaryFileBuffer)pq.poll();
                r = bfb.pop();
                oos.writeObject(r);
                ++rowcounter;
                if (bfb.empty()) {
                    bfb.ois.close();
                    bfb.originalfile.delete();
                    continue;
                }
                pq.add(bfb);
            }
        }
        finally {
            oos.close();
            ** for (bfb : pq)
        }
lbl-1000:
        // 1 sources

        {
            bfb.close();
            continue;
        }
lbl29:
        // 1 sources

        return rowcounter;
    }

    public static boolean genericIntegerTest() throws FileNotFoundException, IOException, ClassNotFoundException {
        File suca1 = new File("suca1");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(suca1));
        oos.writeObject(new Integer(1));
        oos.writeObject(new Integer(43));
        oos.writeObject(new Integer(11));
        oos.writeObject(new Integer(132));
        oos.flush();
        oos.close();
        suca1 = new File("suca1");
        ObjectInputStream oisbase = new ObjectInputStream(new FileInputStream(suca1));
        GenericExternalSort sort = new GenericExternalSort();
        List<File> sorted = GenericExternalSort.sortInBatch(suca1, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        }, DEFAULTMAXTEMPFILES);
        for (File f : sorted) {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            try {
                Object o;
                while ((o = ois.readObject()) != null) {
                    System.out.println((Integer)o);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean genericStringTest() throws FileNotFoundException, IOException, ClassNotFoundException {
        File suca1 = new File("suca1");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(suca1));
        oos.writeObject("Uffd");
        oos.writeObject("suca");
        oos.writeObject("Uffa");
        oos.writeObject("Uffb");
        oos.writeObject("ancora");
        oos.writeObject("non so se funziona");
        oos.flush();
        oos.close();
        suca1 = new File("suca1");
        ObjectInputStream oisbase = new ObjectInputStream(new FileInputStream(suca1));
        GenericExternalSort sort = new GenericExternalSort();
        List<File> sorted = GenericExternalSort.sortInBatch(suca1, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        }, DEFAULTMAXTEMPFILES);
        for (File f : sorted) {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            try {
                Object o;
                while ((o = ois.readObject()) != null) {
                    System.out.println((String)o);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        try {
            GenericExternalSort.genericIntegerTest();
            GenericExternalSort.genericStringTest();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        boolean verbose = false;
        int maxtmpfiles = DEFAULTMAXTEMPFILES;
        Charset cs = Charset.defaultCharset();
        String inputfile = null;
        String outputfile = null;
        int param = 0;
        while (param < args.length) {
            if (args[param].equals("-v") || args[param].equals("--verbose")) {
                verbose = true;
            } else if ((args[param].equals("-t") || args[param].equals("--maxtmpfiles")) && args.length > param + 1) {
                maxtmpfiles = Integer.parseInt(args[++param]);
            } else if ((args[param].equals("-c") || args[param].equals("--charset")) && args.length > param + 1) {
                cs = Charset.forName(args[++param]);
            } else if (inputfile == null) {
                inputfile = args[param];
            } else if (outputfile == null) {
                outputfile = args[param];
            } else {
                System.out.println("Unparsed: " + args[param]);
            }
            ++param;
        }
        if (outputfile == null) {
            System.out.println("please provide input and output file names");
            return;
        }
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String r1, String r2) {
                return r1.compareTo(r2);
            }
        };
        GenericExternalSort ext = new GenericExternalSort();
        List<File> l = GenericExternalSort.sortInBatch(new File(inputfile), comparator, maxtmpfiles);
        if (verbose) {
            System.out.println("created " + l.size() + " tmp files");
        }
        GenericExternalSort.mergeSortedFiles(l, new File(outputfile), comparator);
    }

    public class STRINGCOMPARATOR
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

