/*
 * Decompiled with CFR 0.152.
 */
package it.polito.bellerophontes.util;

import it.polito.NGS.GTFInterface;
import it.polito.NGS.GenomeProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import org.biojava3.genome.parsers.gff.FeatureI;
import org.biojava3.genome.parsers.gff.FeatureList;
import org.biojava3.genome.parsers.gff.Location;

public class ReferenceBuilder {
    private GTFInterface gtfi;
    private GenomeProvider genome;

    public void setGtfi(GTFInterface gtfi) {
        this.gtfi = gtfi;
    }

    public void setGenome(GenomeProvider genome) {
        this.genome = genome;
    }

    public void writeFullTranscriptoma(String zip_file, String output_reference, boolean append) throws FileNotFoundException, IOException {
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(zip_file));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        BufferedWriter bw = new BufferedWriter(new FileWriter(output_reference, append));
        String line = null;
        while ((line = br.readLine()) != null) {
            bw.write(line);
            bw.newLine();
        }
        bw.flush();
        bw.close();
        br.close();
    }

    public void writeCuffFastafromXloc(Collection<String> genes_id, String output_file) throws IOException {
        BufferedWriter output_writer = new BufferedWriter(new FileWriter(new File(output_file)));
        for (String xloc : genes_id) {
            FeatureList features = this.gtfi.getFeaturesByGeneId(xloc);
            for (FeatureI f : features) {
                boolean isPositive;
                Location l = f.location();
                String strand = null;
                if (l.isNegative()) {
                    isPositive = false;
                    strand = "neg";
                    l = l.opposite();
                } else {
                    strand = "pos";
                    isPositive = true;
                }
                try {
                    output_writer.write(">" + f.getAttribute("transcript_id") + "@" + f.getAttribute("gene_name") + "@" + strand + "@" + l.start() + "@" + l.end() + "@" + xloc + "\n");
                    output_writer.write(String.valueOf(this.genome.getBases(f.seqname(), l.start() + 1, l.end(), isPositive)) + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        output_writer.flush();
        output_writer.close();
    }

    public void writeFullTrascriptoma(String output_file) throws IOException {
        Collection<String> genes_id = this.gtfi.getGenesID();
        this.writePositiveCuffFastafromXloc(genes_id, output_file);
    }

    public void writePositiveCuffFastafromXloc(Collection<String> genes_id, String output_file) throws IOException {
        BufferedWriter output_writer = new BufferedWriter(new FileWriter(new File(output_file)));
        for (String xloc : genes_id) {
            FeatureList features = this.gtfi.getFeaturesByGeneId(xloc);
            for (FeatureI f : features) {
                boolean isPositive;
                Location l = f.location();
                String strand = null;
                if (l.isNegative()) {
                    isPositive = false;
                    strand = "neg";
                    l = l.opposite();
                } else {
                    strand = "pos";
                    isPositive = true;
                }
                if (l.end() - l.start() < 2) continue;
                try {
                    output_writer.write(">" + f.getAttribute("transcript_id") + "@" + f.getAttribute("gene_name") + "@" + strand + "@" + l.start() + "@" + l.end() + "@" + xloc + "\n");
                    output_writer.write(String.valueOf(this.genome.getBases(f.seqname(), l.start() + 1, l.end(), true)) + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        output_writer.flush();
        output_writer.close();
    }
}

