/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.ClusterIntensityFileReader;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.FourChannelIntensityData;
import net.sf.picard.illumina.parser.IlluminaData;
import net.sf.picard.illumina.parser.IntensityChannel;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.PerTilePerCycleParser;

abstract class IlluminaIntensityParser<T extends IlluminaData>
extends PerTilePerCycleParser<T> {
    public IlluminaIntensityParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, OutputMapping outputMapping) {
        super(directory, lane, tilesToCycleFiles, outputMapping);
    }

    protected abstract void addIntensityToIlluminaData(T var1, OutputMapping.TwoDIndex var2, IntensityChannel var3, short var4);

    protected abstract T intensityToIlluminaData(FourChannelIntensityData[] var1);

    @Override
    protected T makeData(int[] outputLengths) {
        FourChannelIntensityData[] fcids = new FourChannelIntensityData[outputLengths.length];
        int i = 0;
        while (i < outputLengths.length) {
            fcids[i] = new FourChannelIntensityData(outputLengths[i]);
            ++i;
        }
        return this.intensityToIlluminaData(fcids);
    }

    @Override
    protected PerTilePerCycleParser.CycleFileParser<T> makeCycleFileParser(File file, int cycle) {
        return new IntensityFileParser(file, cycle);
    }

    @Override
    public void verifyData(List<Integer> tiles, int[] cycles) {
        super.verifyData(tiles, cycles);
        Integer elementSize = null;
        for (Map.Entry tileToFiles : this.tilesToCycleFiles.entrySet()) {
            Long fileSize = null;
            Integer numClusters = null;
            for (File intensityFile : (CycleFilesIterator)tileToFiles.getValue()) {
                ClusterIntensityFileReader.ClusterIntensityFileHeader header = ClusterIntensityFileReader.readHeaders(intensityFile);
                if (fileSize == null) {
                    fileSize = intensityFile.length();
                    numClusters = header.numClusters;
                    elementSize = header.elementSize;
                    continue;
                }
                if (fileSize.longValue() != intensityFile.length()) {
                    throw new PicardException("Intensity cycle files for tile(" + tileToFiles.getValue() + ") were not of the same size, offending file(" + intensityFile.getAbsolutePath() + ")");
                }
                if (numClusters != header.numClusters) {
                    throw new PicardException("Intensity cycle files for tile(" + tileToFiles.getValue() + ") did not have the same number of clusters(" + intensityFile.getAbsolutePath() + ")");
                }
                if (elementSize != header.elementSize) {
                    throw new PicardException("Intensity cycle files for tile(" + tileToFiles.getValue() + ") did not have the same element sizes(" + intensityFile.getAbsolutePath() + ")");
                }
                if (header.numCycles == 1) continue;
                throw new PicardException("Intensity cycle file for tile(" + tileToFiles.getValue() + ") had more than one cycle per file num cycles found(" + header.numCycles + ")");
            }
        }
    }

    protected class IntensityFileParser
    implements PerTilePerCycleParser.CycleFileParser<T> {
        private final ClusterIntensityFileReader reader;
        private final int cycle;
        private int cluster;
        private final OutputMapping.TwoDIndex index;

        public IntensityFileParser(File file, int cycle) {
            this.reader = new ClusterIntensityFileReader(file);
            this.cluster = 0;
            this.index = IlluminaIntensityParser.this.outputMapping.getOutputIndexForCycle(cycle);
            this.cycle = cycle;
        }

        @Override
        public void close() {
        }

        @Override
        public void next(T ild) {
            IntensityChannel[] intensityChannelArray = IntensityChannel.values();
            int n = intensityChannelArray.length;
            int n2 = 0;
            while (n2 < n) {
                IntensityChannel channel = intensityChannelArray[n2];
                IlluminaIntensityParser.this.addIntensityToIlluminaData(ild, this.index, channel, this.reader.getValue(this.cluster, channel, this.cycle));
                ++n2;
            }
            ++this.cluster;
        }

        @Override
        public boolean hasNext() {
            return this.cluster < this.reader.getNumClusters();
        }
    }
}

