/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.filter.AlignedFilter;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.ReadNameFilter;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class FilterSamReads
extends CommandLineProgram {
    private static final Log log = Log.getInstance(FilterSamReads.class);
    @Usage
    public String USAGE = "Produces a new SAM or BAM file by including or excluding aligned reads or a list of reads names supplied in the READ_LIST_FILE from the INPUT SAM or BAM file.\n";
    @Option(doc="The SAM or BAM file that will be filtered.", optional=false, shortName="I")
    public File INPUT;
    @Option(doc="Filter.", optional=false)
    public Filter FILTER = null;
    @Option(doc="Read List File containing reads that will be included or excluded from the OUTPUT SAM or BAM file.", optional=true, shortName="RLF")
    public File READ_LIST_FILE;
    @Option(doc="SortOrder of the OUTPUT SAM or BAM file, otherwise use the SortOrder of the INPUT file.", optional=true, shortName="SO")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Option(doc="Create .reads files (for debugging purposes)", optional=true)
    public boolean WRITE_READS_FILES = true;
    @Option(doc="SAM or BAM file to write read excluded results to", optional=false, shortName="O")
    public File OUTPUT;

    private void filterReads(FilteringIterator filteringIterator) {
        SAMFileReader inputReader = new SAMFileReader(this.INPUT);
        SAMFileHeader.SortOrder inputSortOrder = inputReader.getFileHeader().getSortOrder();
        SAMFileHeader outputHeader = inputReader.getFileHeader();
        if (this.SORT_ORDER != null) {
            outputHeader.setSortOrder(this.SORT_ORDER);
        }
        boolean presorted = inputSortOrder.equals((Object)outputHeader.getSortOrder());
        log.info("Filtering [presorted=" + presorted + "] " + this.INPUT.getName() + " -> OUTPUT=" + this.OUTPUT.getName() + " [sortorder=" + outputHeader.getSortOrder().name() + "]");
        SAMFileWriter outputWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(outputHeader, presorted, this.OUTPUT);
        int count = 0;
        while (filteringIterator.hasNext()) {
            outputWriter.addAlignment(filteringIterator.next());
            if (++count == 0 || count % 1000000 != 0) continue;
            log.info(String.valueOf(new DecimalFormat("#,###").format(count)) + " SAMRecords written to " + this.OUTPUT.getName());
        }
        filteringIterator.close();
        outputWriter.close();
        inputReader.close();
        log.info(String.valueOf(new DecimalFormat("#,###").format(count)) + " SAMRecords written to " + this.OUTPUT.getName());
    }

    private void writeReadsFile(File samOrBamFile) throws IOException {
        SAMFileReader reader = new SAMFileReader(samOrBamFile);
        File readsFile = new File(this.OUTPUT.getParentFile(), String.valueOf(IoUtil.basename(samOrBamFile)) + ".reads");
        IoUtil.assertFileIsWritable(readsFile);
        BufferedWriter bw = IoUtil.openFileForBufferedWriting(readsFile, false);
        for (SAMRecord rec : reader) {
            bw.write(String.valueOf(rec.toString()) + "\n");
        }
        bw.close();
        reader.close();
        IoUtil.assertFileIsReadable(readsFile);
    }

    @Override
    protected int doWork() {
        try {
            IoUtil.assertFileIsReadable(this.INPUT);
            IoUtil.assertFileIsWritable(this.OUTPUT);
            if (this.WRITE_READS_FILES) {
                this.writeReadsFile(this.INPUT);
            }
            switch (this.FILTER) {
                case includeAligned: {
                    this.filterReads(new FilteringIterator(new SAMFileReader(this.INPUT).iterator(), new AlignedFilter(true), true));
                    break;
                }
                case excludeAligned: {
                    this.filterReads(new FilteringIterator(new SAMFileReader(this.INPUT).iterator(), new AlignedFilter(false), true));
                    break;
                }
                case includeReadList: {
                    this.filterReads(new FilteringIterator(new SAMFileReader(this.INPUT).iterator(), new ReadNameFilter(this.READ_LIST_FILE, true)));
                    break;
                }
                case excludeReadList: {
                    this.filterReads(new FilteringIterator(new SAMFileReader(this.INPUT).iterator(), new ReadNameFilter(this.READ_LIST_FILE, false)));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.valueOf(this.FILTER.name()) + " has not been implemented!");
                }
            }
            IoUtil.assertFileIsReadable(this.OUTPUT);
            if (this.WRITE_READS_FILES) {
                this.writeReadsFile(this.OUTPUT);
            }
            return 0;
        }
        catch (Exception e) {
            if (this.OUTPUT.exists() && !this.OUTPUT.delete()) {
                log.warn("Failed to delete " + this.OUTPUT.getAbsolutePath());
            }
            log.error(e, "Failed to filter " + this.INPUT.getName());
            return 1;
        }
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.INPUT.equals(this.OUTPUT)) {
            return new String[]{"INPUT file and OUTPUT file must differ!"};
        }
        if ((this.FILTER.equals((Object)Filter.includeReadList) || this.FILTER.equals((Object)Filter.excludeReadList)) && this.READ_LIST_FILE == null) {
            return new String[]{"A READ_LIST_FILE must be specified when using the " + this.FILTER.name() + " option"};
        }
        return super.customCommandLineValidation();
    }

    public static void main(String[] args) {
        System.exit(new FilterSamReads().instanceMain(args));
    }

    private static enum Filter {
        includeAligned("OUTPUT SAM/BAM will contain aligned reads only. INPUT SAM/BAM must be in queryname SortOrder. (Note that *both* first and second of paired reads must be aligned to be included in the OUTPUT SAM or BAM)"),
        excludeAligned("OUTPUT SAM/BAM will contain un-mapped reads only. INPUT SAM/BAM must be in queryname SortOrder. (Note that *both* first and second of pair must be aligned to be excluded from the OUTPUT SAM or BAM)"),
        includeReadList("OUTPUT SAM/BAM will contain reads that are supplied in the READ_LIST_FILE file"),
        excludeReadList("OUTPUT bam will contain reads that are *not* supplied in the READ_LIST_FILE file");

        private final String description;

        private Filter(String description) {
            this.description = description;
        }

        public String toString() {
            return String.valueOf(this.name()) + " [" + this.description + "]";
        }
    }
}

