/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.SortingCollection;

public class FixMateInformation
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Ensure that all mate-pair information is in sync between each read  and it's mate pair.  If no OUTPUT file is supplied then the output is written to a temporary file  and then copied over the INPUT file.";
    @Option(shortName="I", doc="The input file to fix.")
    public List<File> INPUT;
    @Option(shortName="O", optional=true, doc="The output file to write to. If no output file is supplied, the input file is overwritten.")
    public File OUTPUT;
    @Option(shortName="SO", optional=true, doc="Optional sort order if the OUTPUT file should be sorted differently than the INPUT file.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    private static final Log log = Log.getInstance(FixMateInformation.class);
    protected SAMFileWriter out;

    public static void main(String[] args) {
        new FixMateInformation().instanceMainWithExit(args);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected int doWork() {
        block24: {
            allQueryNameSorted = true;
            readers = new ArrayList<SAMFileReader>();
            for (File f : this.INPUT) {
                IoUtil.assertFileIsReadable(f);
                reader = new SAMFileReader(f);
                readers.add(new SAMFileReader(f));
                if (reader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.queryname) continue;
                allQueryNameSorted = false;
            }
            if (this.OUTPUT != null) {
                this.OUTPUT = this.OUTPUT.getAbsoluteFile();
            }
            v0 = differentOutputSpecified = this.OUTPUT != null;
            if (differentOutputSpecified) {
                IoUtil.assertFileIsWritable(this.OUTPUT);
            } else {
                if (this.INPUT.size() != 1) {
                    throw new PicardException("Must specify either an explicit OUTPUT file or a single INPUT file to be overridden.");
                }
                soleInput = this.INPUT.get(0).getAbsoluteFile();
                dir = soleInput.getParentFile().getAbsoluteFile();
                try {
                    IoUtil.assertFileIsWritable(soleInput);
                    IoUtil.assertDirectoryIsWritable(dir);
                    this.OUTPUT = File.createTempFile(String.valueOf(soleInput.getName()) + ".being_fixed.", ".bam", dir);
                }
                catch (IOException ioe) {
                    throw new RuntimeIOException("Could not create tmp file in " + dir.getAbsolutePath());
                }
            }
            if (this.INPUT.size() > 1) {
                headers = new ArrayList<SAMFileHeader>(readers.size());
                for (SAMFileReader reader : readers) {
                    headers.add(reader.getFileHeader());
                }
                sortOrder = allQueryNameSorted != false ? SAMFileHeader.SortOrder.queryname : SAMFileHeader.SortOrder.unsorted;
                merger = new SamFileHeaderMerger(sortOrder, headers, false);
                tmp = new MergingSamRecordIterator(merger, readers, false);
                header = merger.getMergedHeader();
            } else {
                tmp = ((SAMFileReader)readers.get(0)).iterator();
                header = ((SAMFileReader)readers.get(0)).getFileHeader();
            }
            if (allQueryNameSorted) {
                iterator = new PeekableIterator(tmp);
            } else {
                FixMateInformation.log.info(new Object[]{"Sorting input into queryname order."});
                sorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(header), new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM, this.TMP_DIR);
                while (tmp.hasNext()) {
                    sorter.add((SAMRecord)tmp.next());
                }
                iterator = new PeekableIterator<SAMRecord>(sorter.iterator()){

                    @Override
                    public void close() {
                        super.close();
                        sorter.cleanup();
                    }
                };
                FixMateInformation.log.info(new Object[]{"Sorting by queryname complete."});
            }
            outputSortOrder = this.SORT_ORDER == null ? ((SAMFileReader)readers.get(0)).getFileHeader().getSortOrder() : this.SORT_ORDER;
            FixMateInformation.log.info(new Object[]{"Output will be sorted by " + (Object)outputSortOrder});
            header.setSortOrder(outputSortOrder);
            if (this.CREATE_INDEX.booleanValue() && header.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
            }
            this.createSamFileWriter(header);
            FixMateInformation.log.info(new Object[]{"Traversing query name sorted records and fixing up mate pair information."});
            count = 0L;
            while (iterator.hasNext()) {
                rec1 = (SAMRecord)iterator.next();
                v1 = rec2 = iterator.hasNext() != false ? (SAMRecord)iterator.peek() : null;
                if (rec2 != null && rec1.getReadName().equals(rec2.getReadName())) {
                    iterator.next();
                    SamPairUtil.setMateInfo(rec1, rec2, header);
                    this.writeAlignment(rec1);
                    this.writeAlignment(rec2);
                    count += 2L;
                } else {
                    this.writeAlignment(rec1);
                    ++count;
                }
                if (count % 1000000L != 0L) continue;
                FixMateInformation.log.info(new Object[]{"Processed " + count + " records."});
            }
            iterator.close();
            if (header.getSortOrder() == SAMFileHeader.SortOrder.queryname) {
                FixMateInformation.log.info(new Object[]{"Closing output file."});
            } else {
                FixMateInformation.log.info(new Object[]{"Finished processing reads; re-sorting output file."});
            }
            this.closeWriter();
            if (differentOutputSpecified) break block24;
            FixMateInformation.log.info(new Object[]{"Replacing input file with fixed file."});
            soleInput = this.INPUT.get(0).getAbsoluteFile();
            old = new File(soleInput.getParentFile(), String.valueOf(soleInput.getName()) + ".old");
            if (old.exists() || !soleInput.renameTo(old)) ** GOTO lbl97
            if (this.OUTPUT.renameTo(soleInput)) {
                if (!old.delete()) {
                    FixMateInformation.log.warn(new Object[]{"Could not delete old file: " + old.getAbsolutePath()});
                    return 1;
                }
                if (this.CREATE_INDEX.booleanValue() && !(newIndex = new File(this.OUTPUT.getParent(), String.valueOf(this.OUTPUT.getName().substring(0, this.OUTPUT.getName().length() - 4)) + ".bai")).renameTo(oldIndex = new File(soleInput.getParent(), String.valueOf(soleInput.getName().substring(0, soleInput.getName().length() - 4)) + ".bai"))) {
                    FixMateInformation.log.warn(new Object[]{"Could not overwrite index file: " + oldIndex.getAbsolutePath()});
                }
            } else {
                FixMateInformation.log.error(new Object[]{"Could not move new file to " + soleInput.getAbsolutePath()});
                FixMateInformation.log.error(new Object[]{"Input file preserved as: " + old.getAbsolutePath()});
                FixMateInformation.log.error(new Object[]{"New file preserved as: " + this.OUTPUT.getAbsolutePath()});
                return 1;
lbl97:
                // 1 sources

                FixMateInformation.log.error(new Object[]{"Could not move input file out of the way: " + soleInput.getAbsolutePath()});
                if (!this.OUTPUT.delete()) {
                    FixMateInformation.log.error(new Object[]{"Could not delete temporary file: " + this.OUTPUT.getAbsolutePath()});
                }
                return 1;
            }
        }
        return 0;
    }

    protected void createSamFileWriter(SAMFileHeader header) {
        this.out = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, header.getSortOrder() == SAMFileHeader.SortOrder.queryname, this.OUTPUT);
    }

    protected void writeAlignment(SAMRecord sam) {
        this.out.addAlignment(sam);
    }

    protected void closeWriter() {
        this.out.close();
    }
}

