/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class ViewSam
extends CommandLineProgram {
    @Usage
    public final String USAGE = String.valueOf(this.getStandardUsagePreamble()) + "Prints a SAM or BAM file to the screen.";
    @Option(shortName="I", doc="The SAM or BAM file to view.")
    public File INPUT;
    @Option(doc="Print out all reads, just the aligned reads or just the unaligned reads.")
    public AlignmentStatus ALIGNMENT_STATUS = AlignmentStatus.All;
    @Option(doc="Print out all reads, just the PF reads or just the non-PF reads.")
    public PfStatus PF_STATUS = PfStatus.All;

    public static void main(String[] args) {
        new ViewSam().instanceMain(args);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        SAMFileReader in = new SAMFileReader(this.INPUT);
        SAMFileHeader header = in.getFileHeader();
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMWriter(header, true, System.out);
        for (SAMRecord rec : in) {
            if (System.out.checkError()) {
                return 0;
            }
            if (this.ALIGNMENT_STATUS == AlignmentStatus.Aligned && rec.getReadUnmappedFlag() || this.ALIGNMENT_STATUS == AlignmentStatus.Unaligned && !rec.getReadUnmappedFlag() || this.PF_STATUS == PfStatus.PF && rec.getReadFailsVendorQualityCheckFlag() || this.PF_STATUS == PfStatus.NonPF && !rec.getReadFailsVendorQualityCheckFlag()) continue;
            out.addAlignment(rec);
        }
        out.close();
        return 0;
    }

    public static enum AlignmentStatus {
        Aligned,
        Unaligned,
        All;

    }

    public static enum PfStatus {
        PF,
        NonPF,
        All;

    }
}

