/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.BAMFileConstants;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.RuntimeIOException;

public abstract class AbstractBAMFileIndex
implements BAMIndex {
    protected static final int BIN_GENOMIC_SPAN = 0x20000000;
    private static final int[] LEVEL_STARTS;
    public static final int MAX_BINS = 37450;
    public static final int MAX_LINEAR_INDEX_SIZE;
    private final File mFile;
    private final IndexFileBuffer mIndexBuffer;
    private SAMSequenceDictionary mBamDictionary = null;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 9;
        nArray[3] = 73;
        nArray[4] = 585;
        nArray[5] = 4681;
        LEVEL_STARTS = nArray;
        MAX_LINEAR_INDEX_SIZE = 37451 - LEVEL_STARTS[LEVEL_STARTS.length - 1];
    }

    protected AbstractBAMFileIndex(File file, SAMSequenceDictionary dictionary) {
        this(file, dictionary, true);
    }

    protected AbstractBAMFileIndex(File file, SAMSequenceDictionary dictionary, boolean useMemoryMapping) {
        this.mFile = file;
        this.mBamDictionary = dictionary;
        this.mIndexBuffer = useMemoryMapping ? new MemoryMappedFileBuffer(file) : new RandomAccessFileBuffer(file);
        this.seek(0);
        byte[] buffer = new byte[4];
        this.readBytes(buffer);
        if (!Arrays.equals(buffer, BAMFileConstants.BAM_INDEX_MAGIC)) {
            throw new RuntimeException("Invalid file header in BAM index " + this.mFile + ": " + new String(buffer));
        }
    }

    @Override
    public void close() {
        this.mIndexBuffer.close();
    }

    public static int getNumIndexLevels() {
        return LEVEL_STARTS.length;
    }

    public static int getFirstBinInLevel(int levelNumber) {
        return LEVEL_STARTS[levelNumber];
    }

    public int getLevelSize(int levelNumber) {
        if (levelNumber == AbstractBAMFileIndex.getNumIndexLevels()) {
            return 37451 - LEVEL_STARTS[levelNumber];
        }
        return LEVEL_STARTS[levelNumber + 1] - LEVEL_STARTS[levelNumber];
    }

    public int getLevelForBin(Bin bin) {
        if (bin.getBinNumber() >= 37450) {
            throw new SAMException("Tried to get level for invalid bin.");
        }
        int i = AbstractBAMFileIndex.getNumIndexLevels() - 1;
        while (i >= 0) {
            if (bin.getBinNumber() >= LEVEL_STARTS[i]) {
                return i;
            }
            --i;
        }
        throw new SAMException("Unable to find correct bin for bin " + bin);
    }

    public int getFirstLocusInBin(Bin bin) {
        int level = this.getLevelForBin(bin);
        int levelStart = LEVEL_STARTS[level];
        int levelSize = (level == AbstractBAMFileIndex.getNumIndexLevels() - 1 ? 37449 : LEVEL_STARTS[level + 1]) - levelStart;
        return (bin.getBinNumber() - levelStart) * (0x20000000 / levelSize) + 1;
    }

    public int getLastLocusInBin(Bin bin) {
        int level = this.getLevelForBin(bin);
        int levelStart = LEVEL_STARTS[level];
        int levelSize = (level == AbstractBAMFileIndex.getNumIndexLevels() - 1 ? 37449 : LEVEL_STARTS[level + 1]) - levelStart;
        return (bin.getBinNumber() - levelStart + 1) * (0x20000000 / levelSize);
    }

    public int getNumberOfReferences() {
        this.seek(4);
        return this.readInteger();
    }

    @Override
    public long getStartOfLastLinearBin() {
        this.seek(4);
        int sequenceCount = this.readInteger();
        long lastLinearIndexPointer = -1L;
        int i = 0;
        while (i < sequenceCount) {
            int nBins = this.readInteger();
            int j1 = 0;
            while (j1 < nBins) {
                this.skipBytes(4);
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
                ++j1;
            }
            int nLinearBins = this.readInteger();
            if (nLinearBins > 0) {
                this.skipBytes(8 * (nLinearBins - 1));
                lastLinearIndexPointer = this.readLong();
            }
            ++i;
        }
        return lastLinearIndexPointer;
    }

    @Override
    public BAMIndexMetaData getMetaData(int reference) {
        this.seek(4);
        ArrayList<Chunk> metaDataChunks = new ArrayList<Chunk>();
        int sequenceCount = this.readInteger();
        if (reference >= sequenceCount) {
            return null;
        }
        this.skipToSequence(reference);
        int binCount = this.readInteger();
        int binNumber = 0;
        while (binNumber < binCount) {
            int indexBin = this.readInteger();
            int nChunks = this.readInteger();
            Chunk lastChunk = null;
            if (indexBin == 37450) {
                int ci = 0;
                while (ci < nChunks) {
                    long chunkBegin = this.readLong();
                    long chunkEnd = this.readLong();
                    lastChunk = new Chunk(chunkBegin, chunkEnd);
                    metaDataChunks.add(lastChunk);
                    ++ci;
                }
            } else {
                this.skipBytes(16 * nChunks);
            }
            ++binNumber;
        }
        return new BAMIndexMetaData(metaDataChunks);
    }

    public Long getNoCoordinateCount() {
        this.seek(4);
        int sequenceCount = this.readInteger();
        this.skipToSequence(sequenceCount);
        try {
            return this.readLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected BAMIndexContent query(int referenceSequence, int startPos, int endPos) {
        this.seek(4);
        metaDataChunks = new ArrayList<Chunk>();
        sequenceCount = this.readInteger();
        if (referenceSequence >= sequenceCount) {
            return null;
        }
        regionBins = this.regionToBins(startPos, endPos);
        if (regionBins == null) {
            return null;
        }
        this.skipToSequence(referenceSequence);
        binCount = this.readInteger();
        metaDataSeen = false;
        bins = new Bin[this.getMaxBinNumberForReference(referenceSequence) + 1];
        binNumber = 0;
        while (binNumber < binCount) {
            block9: {
                indexBin = this.readInteger();
                nChunks = this.readInteger();
                chunks = new ArrayList<Chunk>(nChunks);
                lastChunk = null;
                if (!regionBins.get(indexBin)) break block9;
                ci = 0;
                while (ci < nChunks) {
                    chunkBegin = this.readLong();
                    chunkEnd = this.readLong();
                    lastChunk = new Chunk(chunkBegin, chunkEnd);
                    chunks.add(lastChunk);
                    ++ci;
                }
                ** GOTO lbl44
            }
            if (indexBin == 37450) {
                ci = 0;
                while (ci < nChunks) {
                    chunkBegin = this.readLong();
                    chunkEnd = this.readLong();
                    lastChunk = new Chunk(chunkBegin, chunkEnd);
                    metaDataChunks.add(lastChunk);
                    ++ci;
                }
                metaDataSeen = true;
            } else {
                this.skipBytes(16 * nChunks);
lbl44:
                // 2 sources

                bin = new Bin(referenceSequence, indexBin);
                bin.setChunkList(chunks);
                bin.setLastChunk(lastChunk);
                bins[indexBin] = bin;
            }
            ++binNumber;
        }
        nLinearBins = this.readInteger();
        regionLinearBinStart = LinearIndex.convertToLinearIndexOffset(startPos);
        regionLinearBinStop = endPos > 0 ? LinearIndex.convertToLinearIndexOffset(endPos) : nLinearBins - 1;
        actualStop = Math.min(regionLinearBinStop, nLinearBins - 1);
        linearIndexEntries = new long[]{};
        if (regionLinearBinStart < nLinearBins) {
            linearIndexEntries = new long[actualStop - regionLinearBinStart + 1];
            this.skipBytes(8 * regionLinearBinStart);
            linearBin = regionLinearBinStart;
            while (linearBin <= actualStop) {
                linearIndexEntries[linearBin - regionLinearBinStart] = this.readLong();
                ++linearBin;
            }
        }
        linearIndex = new LinearIndex(referenceSequence, regionLinearBinStart, linearIndexEntries);
        return new BAMIndexContent(referenceSequence, bins, binCount - (metaDataSeen != false ? 1 : 0), new BAMIndexMetaData(metaDataChunks), linearIndex);
    }

    private int getMaxBinNumberForReference(int reference) {
        try {
            int sequenceLength = this.mBamDictionary.getSequence(reference).getSequenceLength();
            return AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(sequenceLength);
        }
        catch (Exception e) {
            return 37450;
        }
    }

    static int getMaxBinNumberForSequenceLength(int sequenceLength) {
        return AbstractBAMFileIndex.getFirstBinInLevel(AbstractBAMFileIndex.getNumIndexLevels() - 1) + (sequenceLength >> 14);
    }

    protected abstract BAMIndexContent getQueryResults(int var1);

    protected int getMaxAddressibleGenomicLocation() {
        return 0x20000000;
    }

    protected BitSet regionToBins(int startPos, int endPos) {
        int end;
        int maxPos = 0x1FFFFFFF;
        int start = startPos <= 0 ? 0 : startPos - 1 & 0x1FFFFFFF;
        int n = end = endPos <= 0 ? 0x1FFFFFFF : endPos - 1 & 0x1FFFFFFF;
        if (start > end) {
            return null;
        }
        BitSet bitSet = new BitSet(37450);
        bitSet.set(0);
        int k = 1 + (start >> 26);
        while (k <= 1 + (end >> 26)) {
            bitSet.set(k);
            ++k;
        }
        k = 9 + (start >> 23);
        while (k <= 9 + (end >> 23)) {
            bitSet.set(k);
            ++k;
        }
        k = 73 + (start >> 20);
        while (k <= 73 + (end >> 20)) {
            bitSet.set(k);
            ++k;
        }
        k = 585 + (start >> 17);
        while (k <= 585 + (end >> 17)) {
            bitSet.set(k);
            ++k;
        }
        k = 4681 + (start >> 14);
        while (k <= 4681 + (end >> 14)) {
            bitSet.set(k);
            ++k;
        }
        return bitSet;
    }

    protected List<Chunk> optimizeChunkList(List<Chunk> chunks, long minimumOffset) {
        Chunk lastChunk = null;
        Collections.sort(chunks);
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        for (Chunk chunk : chunks) {
            if (chunk.getChunkEnd() <= minimumOffset) continue;
            if (result.isEmpty()) {
                result.add(chunk);
                lastChunk = chunk;
                continue;
            }
            if (!lastChunk.overlaps(chunk) && !lastChunk.isAdjacentTo(chunk)) {
                result.add(chunk);
                lastChunk = chunk;
                continue;
            }
            if (chunk.getChunkEnd() <= lastChunk.getChunkEnd()) continue;
            lastChunk.setChunkEnd(chunk.getChunkEnd());
        }
        return result;
    }

    private void skipToSequence(int sequenceIndex) {
        int i = 0;
        while (i < sequenceIndex) {
            int nBins = this.readInteger();
            int j = 0;
            while (j < nBins) {
                int bin = this.readInteger();
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
                ++j;
            }
            int nLinearBins = this.readInteger();
            this.skipBytes(8 * nLinearBins);
            ++i;
        }
    }

    private void readBytes(byte[] bytes) {
        this.mIndexBuffer.readBytes(bytes);
    }

    private int readInteger() {
        return this.mIndexBuffer.readInteger();
    }

    private long readLong() {
        return this.mIndexBuffer.readLong();
    }

    private void skipBytes(int count) {
        this.mIndexBuffer.skipBytes(count);
    }

    private void seek(int position) {
        this.mIndexBuffer.seek(position);
    }

    private static abstract class IndexFileBuffer {
        private IndexFileBuffer() {
        }

        abstract void readBytes(byte[] var1);

        abstract int readInteger();

        abstract long readLong();

        abstract void skipBytes(int var1);

        abstract void seek(int var1);

        abstract void close();
    }

    private static class MemoryMappedFileBuffer
    extends IndexFileBuffer {
        private MappedByteBuffer mFileBuffer;

        MemoryMappedFileBuffer(File file) {
            try {
                FileInputStream fileStream = new FileInputStream(file);
                FileChannel fileChannel = fileStream.getChannel();
                this.mFileBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                this.mFileBuffer.order(ByteOrder.LITTLE_ENDIAN);
                fileChannel.close();
                fileStream.close();
            }
            catch (IOException exc) {
                throw new RuntimeIOException(exc.getMessage(), exc);
            }
        }

        @Override
        void readBytes(byte[] bytes) {
            this.mFileBuffer.get(bytes);
        }

        @Override
        int readInteger() {
            return this.mFileBuffer.getInt();
        }

        @Override
        long readLong() {
            return this.mFileBuffer.getLong();
        }

        @Override
        void skipBytes(int count) {
            this.mFileBuffer.position(this.mFileBuffer.position() + count);
        }

        @Override
        void seek(int position) {
            this.mFileBuffer.position(position);
        }

        @Override
        void close() {
            this.mFileBuffer = null;
        }
    }

    private static class RandomAccessFileBuffer
    extends IndexFileBuffer {
        private static final int PAGE_SIZE = 4096;
        private static final int PAGE_OFFSET_MASK = 4095;
        private static final int PAGE_MASK = -4096;
        private static final int INVALID_PAGE = 1;
        private File mFile;
        private RandomAccessFile mRandomAccessFile;
        private int mFileLength;
        private int mFilePointer = 0;
        private int mCurrentPage = 1;
        private final byte[] mBuffer = new byte[4096];

        RandomAccessFileBuffer(File file) {
            this.mFile = file;
            try {
                this.mRandomAccessFile = new RandomAccessFile(file, "r");
                long fileLength = this.mRandomAccessFile.length();
                if (fileLength > Integer.MAX_VALUE) {
                    throw new RuntimeException("BAM index file " + this.mFile + " is too large: " + fileLength);
                }
                this.mFileLength = (int)fileLength;
            }
            catch (IOException exc) {
                throw new RuntimeIOException(exc.getMessage(), exc);
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        void readBytes(byte[] bytes) {
            resultOffset = 0;
            resultLength = bytes.length;
            if (this.mFilePointer + resultLength <= this.mFileLength) ** GOTO lbl12
            throw new RuntimeException("Attempt to read past end of BAM index file (file is truncated?): " + this.mFile);
lbl-1000:
            // 1 sources

            {
                this.loadPage(this.mFilePointer);
                pageOffset = this.mFilePointer & 4095;
                copyLength = Math.min(resultLength, 4096 - pageOffset);
                System.arraycopy(this.mBuffer, pageOffset, bytes, resultOffset, copyLength);
                this.mFilePointer += copyLength;
                resultOffset += copyLength;
                resultLength -= copyLength;
lbl12:
                // 2 sources

                ** while (resultLength > 0)
            }
lbl13:
            // 1 sources

        }

        @Override
        int readInteger() {
            this.loadPage(this.mFilePointer);
            int pageOffset = this.mFilePointer & 0xFFF;
            this.mFilePointer += 4;
            return this.mBuffer[pageOffset + 0] & 0xFF | (this.mBuffer[pageOffset + 1] & 0xFF) << 8 | (this.mBuffer[pageOffset + 2] & 0xFF) << 16 | (this.mBuffer[pageOffset + 3] & 0xFF) << 24;
        }

        @Override
        long readLong() {
            long lower = this.readInteger();
            long upper = this.readInteger();
            return upper << 32 | lower & 0xFFFFFFFFL;
        }

        @Override
        void skipBytes(int count) {
            this.mFilePointer += count;
        }

        @Override
        void seek(int position) {
            this.mFilePointer = position;
        }

        @Override
        void close() {
            this.mFilePointer = 0;
            this.mCurrentPage = 1;
            if (this.mRandomAccessFile != null) {
                try {
                    this.mRandomAccessFile.close();
                }
                catch (IOException exc) {
                    throw new RuntimeIOException(exc.getMessage(), exc);
                }
                this.mRandomAccessFile = null;
            }
        }

        private void loadPage(int filePosition) {
            int page = filePosition & 0xFFFFF000;
            if (page == this.mCurrentPage) {
                return;
            }
            try {
                this.mRandomAccessFile.seek(page);
                int readLength = Math.min(this.mFileLength - page, 4096);
                this.mRandomAccessFile.readFully(this.mBuffer, 0, readLength);
                this.mCurrentPage = page;
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Exception reading BAM index file " + this.mFile + ": " + exc.getMessage(), exc);
            }
        }
    }
}

