/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.samtools.util.BinaryCodec;

public class StringUtil {
    private static final byte UPPER_CASE_OFFSET = -32;

    public static <T> String join(String separator, Collection<T> objs) {
        if (objs.size() == 0) {
            return "";
        }
        boolean notFirst = false;
        StringBuilder ret = new StringBuilder();
        for (T obj : objs) {
            if (notFirst) {
                ret.append(separator);
            }
            ret.append(obj.toString());
            notFirst = true;
        }
        return ret.toString();
    }

    public static <T> String join(String separator, T ... objs) {
        List<T> values = Arrays.asList(objs);
        return StringUtil.join(separator, values);
    }

    /*
     * Unable to fully structure code
     */
    public static int split(String aString, String[] tokens, char delim) {
        maxTokens = tokens.length;
        nTokens = 0;
        start = 0;
        end = aString.indexOf(delim);
        if (end >= 0) ** GOTO lbl11
        tokens[nTokens++] = aString;
        return nTokens;
lbl-1000:
        // 1 sources

        {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
lbl11:
            // 2 sources

            ** while (end > 0 && nTokens < maxTokens)
        }
lbl12:
        // 1 sources

        if (nTokens < maxTokens && (trailingString = aString.substring(start)).length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    /*
     * Unable to fully structure code
     */
    public static int splitConcatenateExcessTokens(String aString, String[] tokens, char delim) {
        maxTokens = tokens.length;
        nTokens = 0;
        start = 0;
        end = aString.indexOf(delim);
        if (end >= 0) ** GOTO lbl11
        tokens[nTokens++] = aString;
        return nTokens;
lbl-1000:
        // 1 sources

        {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
lbl11:
            // 2 sources

            ** while (end > 0 && nTokens < maxTokens - 1)
        }
lbl12:
        // 1 sources

        trailingString = aString.substring(start);
        if (trailingString.length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static byte toLowerCase(byte b) {
        if (b < 65 || b > 90) {
            return b;
        }
        return (byte)(b - -32);
    }

    public static byte toUpperCase(byte b) {
        if (b < 97 || b > 122) {
            return b;
        }
        return (byte)(b + -32);
    }

    public static void toUpperCase(byte[] bytes) {
        int length = bytes.length;
        int i = 0;
        while (i < length) {
            if (bytes[i] >= 97 && bytes[i] <= 122) {
                bytes[i] = (byte)(bytes[i] + -32);
            }
            ++i;
        }
    }

    public static String assertCharactersNotInString(String illegalChars, char ... chars) {
        char[] cArray = illegalChars.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char illegalChar = cArray[n2];
            char[] cArray2 = chars;
            int n3 = chars.length;
            int n4 = 0;
            while (n4 < n3) {
                char ch = cArray2[n4];
                if (illegalChar == ch) {
                    throw new IllegalArgumentException("Supplied String contains illegal character '" + illegalChar + "'.");
                }
                ++n4;
            }
            ++n2;
        }
        return illegalChars;
    }

    public static String wordWrap(String s, int maxLineLength) {
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(StringUtil.wordWrapSingleLine(line, maxLineLength));
            ++n2;
        }
        if (s.endsWith("\n")) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String wordWrapSingleLine(String s, int maxLineLength) {
        if (s.length() <= maxLineLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int startCopyFrom = 0;
        while (startCopyFrom < s.length()) {
            int lastSpaceIndex = startCopyFrom;
            int i = startCopyFrom;
            while (i < s.length() && i - startCopyFrom < maxLineLength) {
                if (Character.isWhitespace(s.charAt(i))) {
                    lastSpaceIndex = i;
                }
                ++i;
            }
            if (i - startCopyFrom < maxLineLength) {
                lastSpaceIndex = i;
            }
            while (lastSpaceIndex < s.length() && Character.isWhitespace(s.charAt(lastSpaceIndex))) {
                ++lastSpaceIndex;
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (lastSpaceIndex == startCopyFrom) {
                lastSpaceIndex = i;
            }
            sb.append(s.substring(startCopyFrom, lastSpaceIndex));
            startCopyFrom = lastSpaceIndex;
        }
        return sb.toString();
    }

    public static String intValuesToString(int[] intVals) {
        StringBuilder sb = new StringBuilder(intVals.length);
        if (intVals.length > 0) {
            sb.append(String.valueOf(intVals[0]));
            int i = 1;
            while (i < intVals.length) {
                sb.append(", ");
                sb.append(String.valueOf(intVals[i]));
                ++i;
            }
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] data) {
        if (data == null) {
            return null;
        }
        return StringUtil.bytesToString(data, 0, data.length);
    }

    public static String bytesToString(byte[] buffer, int offset, int length) {
        return new String(buffer, 0, offset, length);
    }

    public static byte[] stringToBytes(String s) {
        byte[] byteBuffer = new byte[s.length()];
        s.getBytes(0, byteBuffer.length, byteBuffer, 0);
        return byteBuffer;
    }

    public static byte[] stringToBytes(String s, int offset, int length) {
        byte[] byteBuffer = new byte[length];
        s.getBytes(offset, offset + length, byteBuffer, 0);
        return byteBuffer;
    }

    public static String readNullTerminatedString(BinaryCodec binaryCodec) {
        StringBuilder ret = new StringBuilder();
        byte b = binaryCodec.readByte();
        while (b != 0) {
            ret.append((char)(b & 0xFF));
            b = binaryCodec.readByte();
        }
        return ret.toString();
    }

    public static void charsToBytes(char[] chars, int charOffset, int length, byte[] bytes, int byteOffset) {
        int i = 0;
        while (i < length) {
            bytes[byteOffset + i] = (byte)chars[charOffset + i];
            ++i;
        }
    }

    public static byte charToByte(char c) {
        return (byte)c;
    }

    public static char byteToChar(byte b) {
        return (char)(b & 0xFF);
    }

    public static String bytesToHexString(byte[] data) {
        char[] chars = new char[2 * data.length];
        int i = 0;
        while (i < data.length) {
            byte b = data[i];
            chars[2 * i] = StringUtil.toHexDigit(b >> 4 & 0xF);
            chars[2 * i + 1] = StringUtil.toHexDigit(b & 0xF);
            ++i;
        }
        return new String(chars);
    }

    public static byte[] hexStringToBytes(String s) throws NumberFormatException {
        if (s.length() % 2 != 0) {
            throw new NumberFormatException("Hex representation of byte string does not have even number of hex chars: " + s);
        }
        byte[] ret = new byte[s.length() / 2];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (byte)(StringUtil.fromHexDigit(s.charAt(i * 2)) << 4 | StringUtil.fromHexDigit(s.charAt(i * 2 + 1)));
            ++i;
        }
        return ret;
    }

    public static char toHexDigit(int value) {
        return (char)(value < 10 ? 48 + value : 65 + value - 10);
    }

    public static int fromHexDigit(char c) throws NumberFormatException {
        int ret = Character.digit(c, 16);
        if (ret == -1) {
            throw new NumberFormatException("Not a valid hex digit: " + c);
        }
        return ret;
    }

    public static String reverseString(String s) {
        StringBuilder sb = new StringBuilder(s);
        sb.reverse();
        return sb.toString();
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String repeatCharNTimes(char c, int repeatNumber) {
        char[] output = new char[repeatNumber];
        Arrays.fill(output, c);
        return String.valueOf(output);
    }
}

