/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.io.util.IOUtils;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.LightweightProfile;
import org.biojava3.core.sequence.template.Sequence;

public class MultipleSequenceAlignment<S extends Sequence<C>, C extends Compound>
implements LightweightProfile<S, C> {
    private List<S> sequences = new ArrayList<S>();
    private Integer length = null;

    public void addAlignedSequence(S sequence) {
        if (this.length == null) {
            this.length = sequence.getLength();
        }
        if (sequence.getLength() != this.length.intValue()) {
            throw new IllegalArgumentException(sequence.getAccession() + " length = " + sequence.getLength() + " not equal to MSA length = " + this.length);
        }
        this.sequences.add(sequence);
    }

    public boolean removeAlignedSequence(S sequence) {
        return this.sequences.remove(sequence);
    }

    @Override
    public S getAlignedSequence(int listIndex) {
        return (S)((Sequence)this.sequences.get(listIndex - 1));
    }

    @Override
    public List<S> getAlignedSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    @Override
    public List<C> getCompoundsAt(int alignmentIndex) {
        ArrayList column = new ArrayList();
        for (Sequence s : this.sequences) {
            column.add(s.getCompoundAt(alignmentIndex));
        }
        return Collections.unmodifiableList(column);
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return ((Sequence)this.sequences.get(0)).getCompoundSet();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getSize() {
        return this.sequences.size();
    }

    @Override
    public String toString(int width) {
        return this.toString(width, null, IOUtils.getIDFormat(this.sequences), true, true, true, false);
    }

    @Override
    public String toString(LightweightProfile.StringFormat format) {
        switch (format) {
            default: {
                return this.toString(60, String.format("CLUSTAL W MSA from BioJava%n%n", new Object[0]), String.valueOf(IOUtils.getIDFormat(this.sequences)) + "   ", true, false, true, false);
            }
            case FASTA: {
                return this.toString(60, null, ">%s%n", false, false, false, false);
            }
            case GCG: 
            case MSF: {
                return this.toString(50, IOUtils.getGCGHeader(this.sequences), IOUtils.getIDFormat(this.sequences), true, false, false, false);
            }
            case PDBWEB: 
        }
        return this.toString(60, null, "%s", true, false, true, true);
    }

    @Override
    public String toString() {
        return this.toString(this.getLength(), null, null, false, false, false, false);
    }

    private String toString(int width, String header, String idFormat, boolean interlaced, boolean aligIndices, boolean aligConservation, boolean webDisplay) {
        StringBuilder s;
        StringBuilder stringBuilder = s = header == null ? new StringBuilder() : new StringBuilder(header);
        if (webDisplay && this.sequences.size() == 2) {
            s.append("<div><pre>");
        }
        width = Math.max(1, width);
        if (interlaced) {
            String aligIndFormat = "%-" + Math.max(1, width / 2) + "d %" + Math.max(1, width - width / 2 - 1) + "d%n";
            int i = 0;
            while (i < this.getLength()) {
                int start = i + 1;
                int end = Math.min(this.getLength(), i + width);
                if (i > 0) {
                    s.append(String.format("%n", new Object[0]));
                }
                if (aligIndices) {
                    if (end < i + width) {
                        int line = end - start + 1;
                        aligIndFormat = "%-" + Math.max(1, line / 2) + "d %" + Math.max(1, line - line / 2 - 1) + "d%n";
                    }
                    if (idFormat != null) {
                        s.append(String.format(idFormat, ""));
                    }
                    s.append(String.format(aligIndFormat, start, end));
                }
                int counter = 0;
                for (Sequence as : this.sequences) {
                    ++counter;
                    if (webDisplay && this.sequences.size() == 2) {
                        this.printSequenceAlignmentWeb(s, counter, idFormat, start, end);
                    } else {
                        if (idFormat != null) {
                            s.append(String.format(idFormat, as.getAccession()));
                        }
                        s.append(as.getSubSequence(start, end).getSequenceAsString());
                        s.append(String.format("%n", new Object[0]));
                    }
                    if (!aligConservation || this.sequences.size() != 2 || counter != 1) continue;
                    this.printConservation(s, idFormat, start, end, webDisplay);
                }
                i += width;
            }
        } else {
            for (Sequence as : this.sequences) {
                if (idFormat != null) {
                    s.append(String.format(idFormat, as.getAccession()));
                }
                int i = 0;
                while (i < this.getLength()) {
                    int start = i + 1;
                    int end = Math.min(this.getLength(), i + width);
                    s.append(as.getSubSequence(start, end).getSequenceAsString());
                    s.append(String.format("%n", new Object[0]));
                    i += width;
                }
            }
        }
        if (webDisplay && aligConservation && this.sequences.size() == 2) {
            s.append(IOUtils.getPDBLegend());
        }
        return s.toString();
    }

    private void printSequenceAlignmentWeb(StringBuilder s, int counter, String idFormat, int start, int end) {
        Sequence as = (Sequence)this.sequences.get(counter - 1);
        Sequence seq1 = (Sequence)this.sequences.get(0);
        Sequence seq2 = (Sequence)this.sequences.get(1);
        if (idFormat != null) {
            s.append(String.format(idFormat, as.getAccession()));
        }
        String mySeq = as.getSubSequence(start, end).getSequenceAsString();
        String s1 = seq1.getSubSequence(start, end).getSequenceAsString();
        String s2 = seq2.getSubSequence(start, end).getSequenceAsString();
        CompoundSet cs = this.getCompoundSet();
        int i = 0;
        while (i < s1.length()) {
            if (i >= s2.length() || i >= mySeq.length()) break;
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            char c = mySeq.charAt(i);
            s.append(IOUtils.getPDBCharacter(true, c1, c2, cs.compoundsEquivalent(seq1.getCompoundAt(i), seq2.getCompoundAt(i)), c));
            ++i;
        }
        s.append(String.format("%n", new Object[0]));
    }

    private void printConservation(StringBuilder s, String idFormat, int start, int end, boolean webDisplay) {
        Sequence seq1 = (Sequence)this.sequences.get(0);
        Sequence seq2 = (Sequence)this.sequences.get(1);
        if (idFormat != null) {
            AccessionID ac1 = ((Sequence)this.sequences.get(0)).getAccession();
            String id1 = ac1 == null ? "null" : ac1.getID();
            id1 = id1.replaceAll(".", " ");
            s.append(String.format(idFormat, id1));
        }
        String s1 = seq1.getSubSequence(start, end).getSequenceAsString();
        String s2 = seq2.getSubSequence(start, end).getSequenceAsString();
        CompoundSet cs = this.getCompoundSet();
        int i = 0;
        while (i < s1.length()) {
            if (i >= s2.length()) break;
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            s.append(IOUtils.getPDBConservation(webDisplay, c1, c2, cs.compoundsEquivalent(seq1.getCompoundAt(i), seq2.getCompoundAt(i))));
            ++i;
        }
        s.append(String.format("%n", new Object[0]));
    }
}

