/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.storage;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceView;
import org.biojava3.core.util.Equals;
import org.biojava3.core.util.Hashcoder;

public class BitSequenceReader<C extends Compound>
implements ProxySequenceReader<C> {
    private final AccessionID accession;
    private final BitArrayWorker<C> worker;

    public BitSequenceReader(BitArrayWorker<C> worker, AccessionID accession) {
        this.accession = accession;
        this.worker = worker;
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        throw new UnsupportedOperationException("Cannot reset the CompoundSet; object is immutable");
    }

    @Override
    public void setContents(String sequence) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " is an immutable data structure; cannot reset contents");
    }

    @Override
    public int countCompounds(C ... compounds) {
        return SequenceMixin.countCompounds((Sequence)this, compounds);
    }

    @Override
    public AccessionID getAccession() {
        return this.accession;
    }

    @Override
    public List<C> getAsList() {
        return SequenceMixin.toList(this);
    }

    @Override
    public C getCompoundAt(int position) {
        return this.worker.getCompoundAt(position);
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.worker.getCompoundSet();
    }

    @Override
    public int getIndexOf(C compound) {
        return SequenceMixin.indexOf(this, compound);
    }

    @Override
    public int getLastIndexOf(C compound) {
        return SequenceMixin.lastIndexOf(this, compound);
    }

    @Override
    public int getLength() {
        return this.worker.getLength();
    }

    @Override
    public String getSequenceAsString() {
        return SequenceMixin.toStringBuilder(this).toString();
    }

    public SequenceView<C> getSubSequence(int start, int end) {
        return SequenceMixin.createSubSequence(this, start, end);
    }

    @Override
    public Iterator<C> iterator() {
        return SequenceMixin.createIterator(this);
    }

    @Override
    public SequenceView<C> getSubSequence(Integer start, Integer end) {
        return this.getSubSequence((int)start, (int)end);
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }

    public int hashCode() {
        int s = 9;
        s = Hashcoder.hash(s, this.accession);
        s = Hashcoder.hash(s, this.worker);
        return s;
    }

    public boolean equals(Object o) {
        if (Equals.classEqual(this, o)) {
            BitSequenceReader that = (BitSequenceReader)o;
            return Equals.equal(this.accession, that.accession) && Equals.equal(this.worker, that.worker);
        }
        return false;
    }

    public static abstract class BitArrayWorker<C extends Compound> {
        private final CompoundSet<C> compoundSet;
        private final int length;
        private final int[] sequence;
        private transient List<C> indexToCompoundsLookup = null;
        private transient Map<C, Integer> compoundsToIndexLookup = null;
        public static final int BYTES_PER_INT = 32;
        private volatile Integer hashcode = null;

        public BitArrayWorker(Sequence<C> sequence) {
            this(sequence.getCompoundSet(), sequence.getLength());
            this.populate(sequence);
        }

        public BitArrayWorker(String sequence, CompoundSet<C> compoundSet) {
            this(compoundSet, sequence.length());
            this.populate(sequence);
        }

        public BitArrayWorker(CompoundSet<C> compoundSet, int length) {
            this.compoundSet = compoundSet;
            this.length = length;
            this.sequence = new int[this.seqArraySize(length)];
        }

        public BitArrayWorker(CompoundSet<C> compoundSet, int[] sequence) {
            this.compoundSet = compoundSet;
            this.sequence = sequence;
            this.length = sequence.length;
        }

        protected abstract byte bitMask();

        protected abstract int compoundsPerDatatype();

        protected abstract List<C> generateIndexToCompounds();

        protected abstract Map<C, Integer> generateCompoundsToIndex();

        protected int bitsPerCompound() {
            return 32 / this.compoundsPerDatatype();
        }

        public int seqArraySize(int length) {
            return (int)Math.ceil((double)length / (double)this.compoundsPerDatatype());
        }

        public void populate(Sequence<C> sequence) {
            int position = 1;
            for (Compound c : sequence) {
                this.setCompoundAt(c, position++);
            }
        }

        public void populate(String sequence) {
            int index = 0;
            while (index < this.getLength()) {
                this.setCompoundAt(sequence.charAt(index), index + 1);
                ++index;
            }
        }

        public void setCompoundAt(char base, int position) {
            C compound = this.getCompoundSet().getCompoundForString(Character.toString(base));
            this.setCompoundAt(compound, position);
        }

        public void setCompoundAt(C compound, int position) {
            this.hashcode = null;
            int arrayIndex = this.biologicalIndexToArrayIndex(position);
            int currentInt = this.sequence[arrayIndex];
            byte shiftBy = this.shiftBy(position);
            Integer integerValue = this.getCompoundsToIndexLookup().get(compound);
            if (integerValue == null) {
                this.processUnknownCompound(compound, position);
            }
            int shiftedValue = integerValue << shiftBy;
            this.sequence[arrayIndex] = currentInt | shiftedValue;
        }

        public C getCompoundAt(int position) {
            byte shiftBy;
            if (position > this.getLength()) {
                throw new IllegalArgumentException(String.valueOf(position) + " is greater than length. Cannot access this position");
            }
            if (position < 1) {
                throw new IllegalArgumentException(String.valueOf(position) + " is less than 1; you must use biological indexing (indexing from 1)");
            }
            int arrayIndex = this.biologicalIndexToArrayIndex(position);
            int currentByte = this.sequence[arrayIndex];
            int shifted = currentByte >>> (shiftBy = this.shiftBy(position));
            int masked = shifted & this.bitMask();
            if (masked > this.compoundsPerDatatype() - 1) {
                throw new IllegalStateException("Got a masked value of " + masked + "; do not understand values greater than " + (this.compoundsPerDatatype() - 1));
            }
            return (C)((Compound)this.getIndexToCompoundsLookup().get(masked));
        }

        protected byte processUnknownCompound(C compound, int position) throws IllegalStateException {
            throw new IllegalStateException("Do not know how to translate the compound " + compound + " to a " + this.bitsPerCompound() + "bit representation");
        }

        protected List<C> getIndexToCompoundsLookup() {
            if (this.indexToCompoundsLookup == null) {
                this.indexToCompoundsLookup = this.generateIndexToCompounds();
            }
            return this.indexToCompoundsLookup;
        }

        protected Map<C, Integer> getCompoundsToIndexLookup() {
            if (this.compoundsToIndexLookup == null) {
                this.compoundsToIndexLookup = this.generateCompoundsToIndex();
            }
            return this.compoundsToIndexLookup;
        }

        private int biologicalIndexToArrayIndex(int index) {
            return (index - 1) / this.compoundsPerDatatype();
        }

        private byte shiftBy(int index) {
            return (byte)((index - 1) % this.compoundsPerDatatype() * this.bitsPerCompound());
        }

        public CompoundSet<C> getCompoundSet() {
            return this.compoundSet;
        }

        public int getLength() {
            return this.length;
        }

        public int hashCode() {
            if (this.hashcode == null) {
                int s = 9;
                s = Hashcoder.hash(s, this.sequence);
                s = Hashcoder.hash(s, this.indexToCompoundsLookup);
                s = Hashcoder.hash(s, this.compoundSet);
                this.hashcode = s;
            }
            return this.hashcode;
        }

        public boolean equals(Object o) {
            if (Equals.classEqual(this, o)) {
                BitArrayWorker that = (BitArrayWorker)o;
                return Equals.equal(this.compoundSet, that.compoundSet) && Equals.equal(this.indexToCompoundsLookup, that.indexToCompoundsLookup) && Equals.equal(this.sequence, that.sequence);
            }
            return false;
        }
    }
}

