/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.transcription;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava3.core.sequence.template.AbstractCompoundTranslator;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceView;
import org.biojava3.core.sequence.transcription.Table;
import org.biojava3.core.sequence.views.WindowedSequence;

public class RNAToAminoAcidTranslator
extends AbstractCompoundTranslator<NucleotideCompound, AminoAcidCompound> {
    private final boolean trimStops;
    private final boolean initMetOnly;
    private final Map<Table.CaseInsensitiveTriplet, Table.Codon> quickLookup;
    private final Map<AminoAcidCompound, List<Table.Codon>> aminoAcidToCodon;
    private final Table.Codon[] codonArray = new Table.Codon[64000];
    private final AminoAcidCompound unknownAminoAcidCompound;
    private final AminoAcidCompound methionineAminoAcidCompound;
    private final boolean translateNCodons;

    public RNAToAminoAcidTranslator(SequenceCreatorInterface<AminoAcidCompound> creator, CompoundSet<NucleotideCompound> nucleotides, CompoundSet<Table.Codon> codons, CompoundSet<AminoAcidCompound> aminoAcids, Table table, boolean trimStops, boolean initMetOnly, boolean translateNCodons) {
        super(creator, nucleotides, aminoAcids);
        this.trimStops = trimStops;
        this.initMetOnly = initMetOnly;
        this.translateNCodons = translateNCodons;
        this.quickLookup = new HashMap<Table.CaseInsensitiveTriplet, Table.Codon>(codons.getAllCompounds().size());
        this.aminoAcidToCodon = new HashMap<AminoAcidCompound, List<Table.Codon>>();
        List<Table.Codon> codonList = table.getCodons(nucleotides, aminoAcids);
        for (Table.Codon codon : codonList) {
            this.quickLookup.put(codon.getTriplet(), codon);
            this.codonArray[codon.getTriplet().intValue()] = codon;
            List<Table.Codon> codonL = this.aminoAcidToCodon.get(codon.getAminoAcid());
            if (codonL == null) {
                codonL = new ArrayList<Table.Codon>();
                this.aminoAcidToCodon.put(codon.getAminoAcid(), codonL);
            }
            codonL.add(codon);
        }
        this.unknownAminoAcidCompound = aminoAcids.getCompoundForString("X");
        this.methionineAminoAcidCompound = aminoAcids.getCompoundForString("M");
    }

    @Override
    public List<Sequence<AminoAcidCompound>> createSequences(Sequence<NucleotideCompound> originalSequence) {
        ArrayList workingList = new ArrayList();
        WindowedSequence<NucleotideCompound> iter = new WindowedSequence<NucleotideCompound>(originalSequence, 3);
        boolean first = true;
        for (SequenceView sequenceView : iter) {
            AminoAcidCompound aminoAcid = null;
            int i = 1;
            Table.CaseInsensitiveTriplet triplet = new Table.CaseInsensitiveTriplet((NucleotideCompound)sequenceView.getCompoundAt(i++), (NucleotideCompound)sequenceView.getCompoundAt(i++), (NucleotideCompound)sequenceView.getCompoundAt(i++));
            Table.Codon target = null;
            int arrayIndex = triplet.intValue();
            if (arrayIndex > -1 && arrayIndex < this.codonArray.length) {
                target = this.codonArray[arrayIndex];
                if (target != null) {
                    aminoAcid = target.getAminoAcid();
                }
            } else {
                target = this.quickLookup.get(triplet);
                aminoAcid = target.getAminoAcid();
            }
            if (aminoAcid == null && this.translateNCodons()) {
                aminoAcid = this.unknownAminoAcidCompound;
            } else if (first && this.initMetOnly && target.isStart()) {
                aminoAcid = this.methionineAminoAcidCompound;
            }
            this.addCompoundsToList(Arrays.asList(aminoAcid), workingList);
            first = false;
        }
        this.postProcessCompoundLists(workingList);
        return this.workingListToSequences(workingList);
    }

    @Override
    protected void postProcessCompoundLists(List<List<AminoAcidCompound>> compoundLists) {
        for (List<AminoAcidCompound> compounds : compoundLists) {
            if (!this.trimStops) continue;
            this.trimStop(compounds);
        }
    }

    protected void trimStop(List<AminoAcidCompound> sequence) {
        AminoAcidCompound stop = sequence.get(sequence.size() - 1);
        boolean isStop = false;
        if (this.aminoAcidToCodon.containsKey(stop)) {
            for (Table.Codon c : this.aminoAcidToCodon.get(stop)) {
                if (!c.isStop()) continue;
                isStop = true;
                break;
            }
        }
        if (isStop) {
            sequence.remove(sequence.size() - 1);
        }
    }

    public boolean translateNCodons() {
        return this.translateNCodons;
    }
}

