#!/bin/bash



echo "config_FuGePrior.txt...." >&2


source ./FuGePrior_config.txt


echo "Process Pegasus output...." >&2


#Modify sample_separation.pyc run on the basis of your analysis. If you have 7 samples, for example, add ${path_FuGePrior_out}/${sample7} according to config_FuGePrior.txt 
python ${path_to_scripts}/samples_separation.pyc ${pegasus_out} ${path_FuGePrior_out}/${sample1} ${path_FuGePrior_out}/${sample2} ${path_FuGePrior_out}/${sample3} ${path_FuGePrior_out}/${sample4} ${path_FuGePrior_out}/${sample5} ${path_FuGePrior_out}/${sample6} 

cd ${path_FuGePrior_out}

for f in $( ls ) 
    do
        echo ${f}
        echo "Dividing fusions according to the tool...." >&2
        python ${path_to_scripts}/tool_separation.pyc -i ${f} -c ${f}_chimerascan -d  ${f}_defuse -g ${f}_generic 
        echo "Identifying ChimeraScan duplicated fusions...." >&2
        python ${path_to_scripts}/tool_duplicate_removal.pyc -i ${f}_chimerascan -o ${f}_chimerascan_collapsed
        echo "Identifying deFuse duplicated fusions...." >&2
        python ${path_to_scripts}/tool_duplicate_removal.pyc -i ${f}_defuse -o ${f}_defuse_collapsed
        echo "Identifying third tool duplicated fusions...." >&2
        python ${path_to_scripts}/tool_duplicate_removal.pyc -i ${f}_generic -o ${f}_generic_collapsed
        echo "Identifying fusions shared by tools...." >&2
        python ${path_to_scripts}/common_tools.pyc -i ${f}_defuse_collapsed -l ${f}_chimerascan_collapsed -g ${f}_generic_collapsed -o ${f}_global
        echo "Removing fusions involving unannotated genes...." >&2
        python ${path_to_scripts}/remove_unannotated_genes.pyc -i ${f}_global -l ${unann_string} -o ${f}_global_unannotated
        echo "Removing fusions shared by reactive samples...." >&2
        python ${path_to_scripts}/reactives_removal.pyc ${f}_global_unannotated ${f}_global_unannotated_noReactives ${reactive1}
        echo "Removing 0-split fusions...." >&2
        python ${path_to_scripts}/remove_zeros.pyc -i ${f}_global_unannotated_noReactives -l ${f}_final_NoSplit -o ${f}_final_YesSplit
        echo "Oncofuse input formatting...." >&2
        python ${path_to_scripts}/oncofuse_input_formatting.pyc -i ${f}_final_YesSplit -l ${oncofuse_pathology} -o ${f}_onco 
        echo "Oncofuse running...." >&2
        java -Xmx1G -jar ${path_to_oncofuse}/Oncofuse.jar ${f}_onco coord ${oncofuse_pathology} ${f}_onco_out
        python ${path_to_scripts}/oncofuse_pegasus_processing.pyc -i ${f}_final_YesSplit -l ${f}_onco_out -o ${f}_pegasus_onco 
        echo "Extracting supporting reads or consensus sequences...." >&2
echo "${chimerascan_out}/chimeras_${f}.txt"
python ${path_to_scripts}/extract_reads.pyc -i ${f}_pegasus_onco -l ${chimerascan_out}/chimeras_${f}.txt -d ${defuse_out}/defuse_${f}.txt -g ${generic_out}/generic_${f}.txt -o ${f}_consensus_reads 
        echo "Building virtual references...." >&2
        python ${path_to_scripts}/build_virtual_references.pyc -i ${f}_consensus_reads -l ${path_to_reference} -n ${path_to_scripts} -s ${bp_extension} -o ${f}_consensus_sequences
        echo "Matching virtual references...." >&2
        python ${path_to_scripts}/match_virtual_reference.pyc -i ${f}_consensus_sequences -l ${min_split_overlapping} -o ${f}_output1
        echo "Extracting priority fusions...." >&2
        python ${path_to_scripts}/onco_pegasus_interesting.pyc -i ${f}_output1 -t ${threshold} -o ${f}_OUT
        echo "Done." >&2
    done








