
import optparse
import re

import sys


parser = optparse.OptionParser()
parser.add_option("-i", "--interesting_in", action = "store", type = "string", dest = "interesting_in", help = 'interesting fusions')
parser.add_option("-o", "--out", action = "store", type = "string", dest = "out", help = 'out')
(options, args) = parser.parse_args()



PATH_TO_IN = options.interesting_in
PATH_TO_OUT = options.out




try:
    f_input = open(PATH_TO_IN, 'r')
except IOError, (errno, strerror):
    print "I/O error(%d): %s" % (errno, strerror)
    sys.exit(0)
try:
    f_out = open(PATH_TO_OUT, 'w')
except IOError, (errno, strerror):
    print "I/O error(%d): %s" % (errno, strerror)
    sys.exit(0)

f_out.write("#5p_symbol\t5p_ensembl\t5p_strand\t5p_chr\t3p_symbol\t3p_ensembl\t3p_strand\t3p_chr\t5p_start\t5p_end\t3p_start\t3p_end\tsplit_reads\ttot_read\n")
for line in f_input:
    line_split = line.split("\t")
    chrom = line_split[0]
    chrom1 = chrom.split('~')[0]
    chrom2 = chrom.split('~')[1]
    gene1 = line_split[60]
    gene2 = line_split[61].rstrip("\n")
    splitreads = line_split[19]
    gene1_end = line_split[1]
    gene2_start = line_split[2]
    gene1_start = line_split[28]
    gene2_end = line_split[29]
    sequence = line_split[54] + line_split[55]
    strands = line_split[59] 
    spanning = line_split[27] 
    strand1 = strands.split(",")[0][0]
    strand2 = strands.split(",")[1][0]
    f_out.write(gene1 + "\t" + "NULL" + "\t" + strand1 + "\t" + chrom1 + "\t" + gene2 + "\t" + "NULL" + "\t" + strand2 + "\t" + chrom2 + "\t" + gene1_start + "\t" + gene1_end + "\t" + gene2_start + "\t" + gene2_end + "\t" + splitreads + "\t" + spanning +  "\n")
  
f_input.close()
f_out.close()


    
