/*
 * Decompiled with CFR 0.152.
 */
package it.polito.NGS;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.util.SequenceUtil;

public class GenomeProvider {
    IndexedFastaSequenceFile indexedfasta;

    public GenomeProvider(String genomeReferenceFastaFile, String genomeReferenceIndexFile) throws FileNotFoundException {
        FastaSequenceIndex fastaseqindex = new FastaSequenceIndex(new File(genomeReferenceIndexFile));
        this.indexedfasta = new IndexedFastaSequenceFile(new File(genomeReferenceFastaFile), fastaseqindex);
    }

    public ReferenceSequence getSequence(String ref, int start, int end) {
        return this.indexedfasta.getSubsequenceAt(ref, start, end);
    }

    public String getBases(String ref, int start, int end, boolean isPositive) {
        ReferenceSequence rs = null;
        try {
            rs = this.indexedfasta.getSubsequenceAt(ref, start, end);
        }
        catch (Exception e) {
            return "";
        }
        byte[] bases = rs.getBases();
        if (!isPositive) {
            SequenceUtil.reverseComplement(bases);
        }
        StringBuilder sb = new StringBuilder(bases.length);
        int i = 0;
        byte[] byArray = bases;
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append((char)b);
            ++i;
            ++n2;
        }
        return sb.toString();
    }

    public String getBases(String ref, int start, int end) {
        return this.getBases(ref, start, end, true);
    }
}

