/*
 * Decompiled with CFR 0.152.
 */
package it.polito.bellerophontes.util;

import it.polito.bellerophontes.util.BinaryFileBuffer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class ExternalSort {
    static int DEFAULTMAXTEMPFILES = 1024;

    public static long estimateBestSizeOfBlocks(File filetobesorted, int maxtmpfiles) {
        long freemem;
        long sizeoffile = filetobesorted.length() * 2L;
        long blocksize = sizeoffile / (long)maxtmpfiles + (long)(sizeoffile % (long)maxtmpfiles == 0L ? 0 : 1);
        if (blocksize < (freemem = Runtime.getRuntime().freeMemory()) / 2L) {
            blocksize = freemem / 2L;
        }
        return blocksize;
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp) throws IOException {
        return ExternalSort.sortInBatch(file, cmp, DEFAULTMAXTEMPFILES, Charset.defaultCharset());
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp, int maxtmpfiles, Charset cs) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        BufferedReader fbr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));
        long blocksize = ExternalSort.estimateBestSizeOfBlocks(file, maxtmpfiles);
        try {
            ArrayList<String> tmplist = new ArrayList<String>();
            String line = "";
            try {
                while (line != null) {
                    long currentblocksize = 0L;
                    while (currentblocksize < blocksize && (line = fbr.readLine()) != null) {
                        tmplist.add(line);
                        currentblocksize += (long)(line.length() * 2);
                    }
                    files.add(ExternalSort.sortAndSave(tmplist, cmp, cs));
                    tmplist.clear();
                }
            }
            catch (EOFException oef) {
                if (tmplist.size() > 0) {
                    files.add(ExternalSort.sortAndSave(tmplist, cmp, cs));
                    tmplist.clear();
                }
            }
        }
        finally {
            fbr.close();
        }
        return files;
    }

    public static File sortAndSave(List<String> tmplist, Comparator<String> cmp, Charset cs) throws IOException {
        Collections.sort(tmplist, cmp);
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile", new File(System.getProperty("user.dir")));
        newtmpfile.deleteOnExit();
        BufferedWriter fbw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newtmpfile), cs));
        try {
            for (String r : tmplist) {
                fbw.write(r);
                fbw.newLine();
            }
        }
        finally {
            fbw.close();
        }
        return newtmpfile;
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, Charset.defaultCharset());
    }

    /*
     * Unable to fully structure code
     */
    public static int mergeSortedFiles(List<File> files, File outputfile, final Comparator<String> cmp, Charset cs) throws IOException {
        block12: {
            block11: {
                pq = new PriorityQueue<BinaryFileBuffer>(11, new Comparator<BinaryFileBuffer>(){

                    @Override
                    public int compare(BinaryFileBuffer i, BinaryFileBuffer j) {
                        return cmp.compare(i.peek(), j.peek());
                    }
                });
                for (File f : files) {
                    bfb = new BinaryFileBuffer(f, cs);
                    pq.add(bfb);
                }
                fbw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputfile), cs));
                rowcounter = 0;
                r = null;
                try {
                    try {
                        while (pq.size() > 0) {
                            bfb = pq.poll();
                            r = bfb.pop();
                            if (r != null) {
                                fbw.write(r);
                                fbw.newLine();
                                ++rowcounter;
                            }
                            if (bfb.empty()) {
                                bfb.fbr.close();
                                bfb.originalfile.delete();
                                continue;
                            }
                            pq.add(bfb);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("line:" + r);
                        fbw.close();
                        ** for (bfb : pq)
                    }
                }
                catch (Throwable var9_17) {
                    fbw.close();
                    ** for (bfb : pq)
                }
lbl-1000:
                // 1 sources

                {
                    bfb.close();
                    continue;
lbl35:
                    // 1 sources

                    break block12;
                }
lbl-1000:
                // 1 sources

                {
                    bfb.close();
                    continue;
                }
lbl41:
                // 1 sources

                throw var9_17;
            }
            fbw.close();
            for (BinaryFileBuffer bfb : pq) {
                bfb.close();
            }
        }
        return rowcounter;
    }

    public static void main(String[] args) throws IOException {
        boolean verbose = false;
        int maxtmpfiles = DEFAULTMAXTEMPFILES;
        Charset cs = Charset.defaultCharset();
        String inputfile = null;
        String outputfile = null;
        int param = 0;
        while (param < args.length) {
            if (args[param].equals("-v") || args[param].equals("--verbose")) {
                verbose = true;
            } else if ((args[param].equals("-t") || args[param].equals("--maxtmpfiles")) && args.length > param + 1) {
                maxtmpfiles = Integer.parseInt(args[++param]);
            } else if ((args[param].equals("-c") || args[param].equals("--charset")) && args.length > param + 1) {
                cs = Charset.forName(args[++param]);
            } else if (inputfile == null) {
                inputfile = args[param];
            } else if (outputfile == null) {
                outputfile = args[param];
            } else {
                System.out.println("Unparsed: " + args[param]);
            }
            ++param;
        }
        if (outputfile == null) {
            System.out.println("please provide input and output file names");
            return;
        }
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String r1, String r2) {
                return r1.compareTo(r2);
            }
        };
        List<File> l = ExternalSort.sortInBatch(new File(inputfile), comparator, maxtmpfiles, cs);
        if (verbose) {
            System.out.println("created " + l.size() + " tmp files");
        }
        ExternalSort.mergeSortedFiles(l, new File(outputfile), comparator, cs);
    }
}

