/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.RnaSeqMetrics;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.annotation.Gene;
import net.sf.picard.annotation.GeneAnnotationReader;
import net.sf.picard.annotation.LocusFunction;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.Log;
import net.sf.picard.util.MathUtil;
import net.sf.picard.util.OverlapDetector;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.SequenceUtil;

public class CollectRnaSeqMetrics
extends SinglePassSamProgram {
    private static final Log LOG = Log.getInstance(CollectRnaSeqMetrics.class);
    @Usage
    public final String USAGE = String.valueOf(this.getStandardUsagePreamble()) + "Program to collect metrics about the alignment of RNA to various functional classes of loci in the genome:" + " coding, intronic, UTR, intergenic, ribosomal.\n" + "Also determines strand-specificity for strand-specific libraries.";
    @Option(doc="Gene annotations in refFlat form.  Format described here: http://genome.ucsc.edu/goldenPath/gbdDescriptionsOld.html#RefFlat")
    public File REF_FLAT;
    @Option(doc="Location of rRNA sequences in genome, in interval_list format.  If not specified no bases will be identified as being ribosomal.  Format described here: http://picard.sourceforge.net/javadoc/net/sf/picard/util/IntervalList.html", optional=true)
    public File RIBOSOMAL_INTERVALS;
    @Option(shortName="STRAND", doc="For strand-specific library prep. For unpaired reads, use FIRST_READ_TRANSCRIPTION_STRAND if the reads are expected to be on the transcription strand.")
    public StrandSpecificity STRAND_SPECIFICITY;
    @Option(doc="When calculating coverage based values (e.g. CV of coverage) only use transcripts of this length or greater.")
    public int MINIMUM_LENGTH = 500;
    @Option(doc="The PDF file to write out a plot of normalized position vs. coverage.", shortName="CHART", optional=true)
    public File CHART_OUTPUT;
    @Option(doc="If a read maps to a sequence specified with this option, all the bases in the read are counted as ignored bases.  These reads are not counted as ")
    public Set<String> IGNORE_SEQUENCE = new HashSet<String>();
    @Option(doc="This percentage of the length of a fragment must overlap one of the ribosomal intervals for a read or read pair by this must in order to be considered rRNA.")
    public double RRNA_FRAGMENT_PERCENTAGE = 0.8;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    private boolean calculateAll = false;
    private boolean calculateSample = false;
    private boolean calculateLibrary = false;
    private boolean calculateReadGroup = false;
    final RnaSeqMetricsCollector allReadsCollector = new RnaSeqMetricsCollector(null, null, null, null);
    final Map<String, RnaSeqMetricsCollector> sampleCollectors = new HashMap<String, RnaSeqMetricsCollector>();
    final Map<String, RnaSeqMetricsCollector> libraryCollectors = new HashMap<String, RnaSeqMetricsCollector>();
    final Map<String, RnaSeqMetricsCollector> readGroupCollectors = new HashMap<String, RnaSeqMetricsCollector>();
    private final Set<Integer> ignoredSequenceIndices = new HashSet<Integer>();
    private OverlapDetector<Gene> geneOverlapDetector;
    private final OverlapDetector<Interval> ribosomalSequenceOverlapDetector = new OverlapDetector(0, 0);

    public static void main(String[] argv) {
        new CollectRnaSeqMetrics().instanceMainWithExit(argv);
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        Long ribosomalBasesInitialValue;
        if (this.CHART_OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
        }
        this.calculateAll = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.ALL_READS);
        this.calculateSample = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.SAMPLE);
        this.calculateLibrary = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.LIBRARY);
        this.calculateReadGroup = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.READ_GROUP);
        this.allReadsCollector.metrics.RIBOSOMAL_BASES = ribosomalBasesInitialValue = this.RIBOSOMAL_INTERVALS != null ? Long.valueOf(0L) : null;
        for (SAMReadGroupRecord rg : header.getReadGroups()) {
            if (this.calculateSample && !this.sampleCollectors.containsKey(rg.getSample())) {
                this.sampleCollectors.put(rg.getSample(), new RnaSeqMetricsCollector(rg.getSample(), null, null, ribosomalBasesInitialValue));
            }
            if (this.calculateLibrary && !this.libraryCollectors.containsKey(rg.getLibrary())) {
                this.libraryCollectors.put(rg.getLibrary(), new RnaSeqMetricsCollector(rg.getSample(), rg.getLibrary(), null, ribosomalBasesInitialValue));
            }
            if (!this.calculateReadGroup || this.readGroupCollectors.containsKey(rg.getPlatformUnit())) continue;
            this.readGroupCollectors.put(rg.getPlatformUnit(), new RnaSeqMetricsCollector(rg.getSample(), rg.getLibrary(), rg.getPlatformUnit(), ribosomalBasesInitialValue));
        }
        this.geneOverlapDetector = GeneAnnotationReader.loadRefFlat(this.REF_FLAT, header.getSequenceDictionary());
        LOG.info("Loaded " + this.geneOverlapDetector.getAll().size() + " genes.");
        if (this.RIBOSOMAL_INTERVALS != null) {
            IntervalList ribosomalIntervals = IntervalList.fromFile(this.RIBOSOMAL_INTERVALS);
            try {
                SequenceUtil.assertSequenceDictionariesEqual(header.getSequenceDictionary(), ribosomalIntervals.getHeader().getSequenceDictionary());
            }
            catch (SequenceUtil.SequenceListsDifferException e) {
                throw new PicardException("Sequence dictionaries differ in " + this.INPUT.getAbsolutePath() + " and " + this.RIBOSOMAL_INTERVALS.getAbsolutePath(), e);
            }
            ribosomalIntervals.unique();
            List<Interval> intervals = ribosomalIntervals.getIntervals();
            this.ribosomalSequenceOverlapDetector.addAll(intervals, intervals);
        }
        for (String sequenceName : this.IGNORE_SEQUENCE) {
            SAMSequenceRecord sequenceRecord = header.getSequence(sequenceName);
            if (sequenceRecord == null) {
                throw new PicardException("Unrecognized sequence " + sequenceName + " passed as argument to IGNORE_SEQUENCE");
            }
            this.ignoredSequenceIndices.add(sequenceRecord.getSequenceIndex());
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        SAMReadGroupRecord rg = rec.getReadGroup();
        if (this.calculateAll) {
            this.allReadsCollector.acceptRead(rec);
        }
        if (this.calculateSample) {
            this.sampleCollectors.get(rg.getSample()).acceptRead(rec);
        }
        if (this.calculateLibrary) {
            this.libraryCollectors.get(rg.getLibrary()).acceptRead(rec);
        }
        if (this.calculateReadGroup) {
            this.readGroupCollectors.get(rg.getPlatformUnit()).acceptRead(rec);
        }
    }

    @Override
    protected void finish() {
        int rResult;
        MetricsFile<RnaSeqMetrics, Integer> file = this.getMetricsFile();
        if (this.calculateAll) {
            this.allReadsCollector.addMetricsToFile(file);
        }
        if (this.calculateSample) {
            for (RnaSeqMetricsCollector coll : this.sampleCollectors.values()) {
                coll.addMetricsToFile(file);
            }
        }
        if (this.calculateLibrary) {
            for (RnaSeqMetricsCollector coll : this.libraryCollectors.values()) {
                coll.addMetricsToFile(file);
            }
        }
        if (this.calculateReadGroup) {
            for (RnaSeqMetricsCollector coll : this.readGroupCollectors.values()) {
                coll.addMetricsToFile(file);
            }
        }
        file.write(this.OUTPUT);
        boolean atLeastOneHistogram = false;
        for (Histogram<Integer> histo : file.getAllHistograms()) {
            boolean bl = atLeastOneHistogram = atLeastOneHistogram || !histo.isEmpty();
        }
        if (this.CHART_OUTPUT != null && atLeastOneHistogram && (rResult = RExecutor.executeFromClasspath("net/sf/picard/analysis/rnaSeqCoverage.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName())) != 0) {
            throw new PicardException("Problem invoking R to generate plot.");
        }
    }

    private class RnaSeqMetricsCollector {
        final RnaSeqMetrics metrics = new RnaSeqMetrics();
        private final Map<Gene.Transcript, int[]> coverageByTranscript = new HashMap<Gene.Transcript, int[]>();
        private static /* synthetic */ int[] $SWITCH_TABLE$net$sf$picard$annotation$LocusFunction;

        public RnaSeqMetricsCollector(String sample, String library, String readGroup, Long ribosomalBasesInitialValue) {
            this.metrics.SAMPLE = sample;
            this.metrics.LIBRARY = library;
            this.metrics.READ_GROUP = readGroup;
            this.metrics.RIBOSOMAL_BASES = ribosomalBasesInitialValue;
        }

        public void acceptRead(SAMRecord rec) {
            Interval fragmentInterval;
            if (rec.getReadFailsVendorQualityCheckFlag() || rec.getNotPrimaryAlignmentFlag()) {
                return;
            }
            this.metrics.PF_BASES += (long)rec.getReadLength();
            if (rec.getReadUnmappedFlag()) {
                return;
            }
            if (CollectRnaSeqMetrics.this.ignoredSequenceIndices.contains(rec.getReferenceIndex())) {
                ++this.metrics.IGNORED_READS;
                return;
            }
            Interval readInterval = new Interval(rec.getReferenceName(), rec.getAlignmentStart(), rec.getAlignmentEnd());
            if (!rec.getReadPairedFlag()) {
                fragmentInterval = readInterval;
            } else if (rec.getMateUnmappedFlag() || rec.getReferenceIndex() != rec.getMateReferenceIndex()) {
                fragmentInterval = null;
            } else {
                int fragmentStart = Math.min(rec.getAlignmentStart(), rec.getMateAlignmentStart());
                int fragmentEnd = CoordMath.getEnd(fragmentStart, Math.abs(rec.getInferredInsertSize()));
                fragmentInterval = new Interval(rec.getReferenceName(), fragmentStart, fragmentEnd);
            }
            if (fragmentInterval != null) {
                Collection overlappingRibosomalIntervals = CollectRnaSeqMetrics.this.ribosomalSequenceOverlapDetector.getOverlaps(fragmentInterval);
                int intersectionLength = 0;
                for (Interval overlappingInterval : overlappingRibosomalIntervals) {
                    int thisIntersectionLength = overlappingInterval.getIntersectionLength(fragmentInterval);
                    intersectionLength = Math.max(intersectionLength, thisIntersectionLength);
                }
                if ((double)intersectionLength / (double)fragmentInterval.length() >= CollectRnaSeqMetrics.this.RRNA_FRAGMENT_PERCENTAGE) {
                    this.metrics.RIBOSOMAL_BASES = this.metrics.RIBOSOMAL_BASES + (long)rec.getReadLength();
                    int numAlignedBases = 0;
                    for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
                        numAlignedBases += alignmentBlock.getLength();
                    }
                    this.metrics.PF_ALIGNED_BASES += (long)numAlignedBases;
                    return;
                }
            }
            Collection overlappingGenes = CollectRnaSeqMetrics.this.geneOverlapDetector.getOverlaps(readInterval);
            List<AlignmentBlock> alignmentBlocks = rec.getAlignmentBlocks();
            boolean overlapsExon = false;
            for (AlignmentBlock alignmentBlock : alignmentBlocks) {
                LocusFunction[] locusFunctions = new LocusFunction[alignmentBlock.getLength()];
                Arrays.fill((Object[])locusFunctions, 0, locusFunctions.length, (Object)LocusFunction.INTERGENIC);
                for (Gene gene : overlappingGenes) {
                    for (Gene.Transcript transcript : gene) {
                        transcript.assignLocusFunctionForRange(alignmentBlock.getReferenceStart(), locusFunctions);
                        int[] coverage = this.coverageByTranscript.get(transcript);
                        if (coverage == null) {
                            coverage = new int[transcript.length()];
                            this.coverageByTranscript.put(transcript, coverage);
                        }
                        transcript.addCoverageCounts(alignmentBlock.getReferenceStart(), CoordMath.getEnd(alignmentBlock.getReferenceStart(), alignmentBlock.getLength()), coverage);
                    }
                }
                LocusFunction[] locusFunctionArray = locusFunctions;
                int transcript = locusFunctions.length;
                int n = 0;
                while (n < transcript) {
                    Object locusFunction = locusFunctionArray[n];
                    ++this.metrics.PF_ALIGNED_BASES;
                    switch (RnaSeqMetricsCollector.$SWITCH_TABLE$net$sf$picard$annotation$LocusFunction()[((Enum)locusFunction).ordinal()]) {
                        case 1: {
                            ++this.metrics.INTERGENIC_BASES;
                            break;
                        }
                        case 2: {
                            ++this.metrics.INTRONIC_BASES;
                            break;
                        }
                        case 3: {
                            ++this.metrics.UTR_BASES;
                            overlapsExon = true;
                            break;
                        }
                        case 4: {
                            ++this.metrics.CODING_BASES;
                            overlapsExon = true;
                            break;
                        }
                        case 5: {
                            this.metrics.RIBOSOMAL_BASES = this.metrics.RIBOSOMAL_BASES + 1L;
                        }
                    }
                    ++n;
                }
            }
            if (overlapsExon && CollectRnaSeqMetrics.this.STRAND_SPECIFICITY != StrandSpecificity.NONE && overlappingGenes.size() == 1) {
                boolean thisReadExpectedToAgree;
                boolean negativeTranscriptionStrand = ((Gene)overlappingGenes.iterator().next()).isNegativeStrand();
                boolean negativeReadStrand = rec.getReadNegativeStrandFlag();
                boolean readAndTranscriptStrandsAgree = negativeReadStrand == negativeTranscriptionStrand;
                boolean readOneOrUnpaired = !rec.getReadPairedFlag() || rec.getFirstOfPairFlag();
                boolean firstReadExpectedToAgree = CollectRnaSeqMetrics.this.STRAND_SPECIFICITY == StrandSpecificity.FIRST_READ_TRANSCRIPTION_STRAND;
                boolean bl = thisReadExpectedToAgree = readOneOrUnpaired == firstReadExpectedToAgree;
                if (readAndTranscriptStrandsAgree == thisReadExpectedToAgree) {
                    ++this.metrics.CORRECT_STRAND_READS;
                } else {
                    ++this.metrics.INCORRECT_STRAND_READS;
                }
            }
        }

        public void addMetricsToFile(MetricsFile<RnaSeqMetrics, Integer> file) {
            if (this.metrics.PF_ALIGNED_BASES > 0L) {
                if (this.metrics.RIBOSOMAL_BASES != null) {
                    this.metrics.PCT_RIBOSOMAL_BASES = (double)this.metrics.RIBOSOMAL_BASES.longValue() / (double)this.metrics.PF_ALIGNED_BASES;
                }
                this.metrics.PCT_CODING_BASES = (double)this.metrics.CODING_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_UTR_BASES = (double)this.metrics.UTR_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_INTRONIC_BASES = (double)this.metrics.INTRONIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_INTERGENIC_BASES = (double)this.metrics.INTERGENIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_MRNA_BASES = this.metrics.PCT_CODING_BASES + this.metrics.PCT_UTR_BASES;
                this.metrics.PCT_USABLE_BASES = (double)(this.metrics.CODING_BASES + this.metrics.UTR_BASES) / (double)this.metrics.PF_BASES;
            }
            if (this.metrics.CORRECT_STRAND_READS > 0L || this.metrics.INCORRECT_STRAND_READS > 0L) {
                this.metrics.PCT_CORRECT_STRAND_READS = (double)this.metrics.CORRECT_STRAND_READS / (double)(this.metrics.CORRECT_STRAND_READS + this.metrics.INCORRECT_STRAND_READS);
            }
            Histogram<Integer> normalizedCovByPos = this.computeCoverageMetrics();
            file.addMetric(this.metrics);
            file.addHistogram(normalizedCovByPos);
        }

        private Histogram<Integer> computeCoverageMetrics() {
            Histogram<Double> cvs = new Histogram<Double>();
            Histogram<Double> fivePrimeSkews = new Histogram<Double>();
            Histogram<Double> threePrimeSkews = new Histogram<Double>();
            Histogram gapBasesPerKb = new Histogram();
            Histogram<Double> fiveToThreeSkews = new Histogram<Double>();
            String prefix = null;
            prefix = this.metrics.READ_GROUP != null ? String.valueOf(this.metrics.READ_GROUP) + "." : (this.metrics.LIBRARY != null ? String.valueOf(this.metrics.LIBRARY) + "." : (this.metrics.SAMPLE != null ? String.valueOf(this.metrics.SAMPLE) + "." : "All_Reads."));
            Histogram<Integer> normalizedCoverageByNormalizedPosition = new Histogram<Integer>("normalized_position", String.valueOf(prefix) + "normalized_coverage");
            Map<Gene.Transcript, int[]> transcripts = this.pickTranscripts(this.coverageByTranscript);
            double transcriptCount = transcripts.size();
            for (Map.Entry<Gene.Transcript, int[]> entry : transcripts.entrySet()) {
                Gene.Transcript tx = entry.getKey();
                double[] tmp = MathUtil.promote(entry.getValue());
                double[] coverage = tx.getGene().isPositiveStrand() ? tmp : this.copyAndReverse(tmp);
                double mean = MathUtil.mean(coverage, 0, coverage.length);
                double stdev = MathUtil.stddev(coverage, 0, coverage.length, mean);
                double cv = stdev / mean;
                cvs.increment(cv);
                int PRIME_BASES = 100;
                double fivePrimeCoverage = MathUtil.mean(coverage, 0, 100);
                double threePrimeCoverage = MathUtil.mean(coverage, coverage.length - 100, coverage.length);
                fivePrimeSkews.increment(fivePrimeCoverage / mean);
                threePrimeSkews.increment(threePrimeCoverage / mean);
                fiveToThreeSkews.increment(fivePrimeCoverage / threePrimeCoverage);
                int lastIndex = coverage.length - 1;
                int percent = 0;
                while (percent <= 100) {
                    double p = (double)percent / 100.0;
                    int start = (int)Math.max(0.0, (double)lastIndex * (p - 0.005));
                    int end = (int)Math.min((double)lastIndex, (double)lastIndex * (p + 0.005));
                    int length = end - start + 1;
                    double sum = 0.0;
                    int i = start;
                    while (i <= end) {
                        sum += coverage[i];
                        ++i;
                    }
                    double normalized = sum / (double)length / mean;
                    normalizedCoverageByNormalizedPosition.increment(percent, normalized / transcriptCount);
                    ++percent;
                }
            }
            this.metrics.MEDIAN_CV_COVERAGE = cvs.getMedian();
            this.metrics.MEDIAN_5PRIME_BIAS = fivePrimeSkews.getMedian();
            this.metrics.MEDIAN_3PRIME_BIAS = threePrimeSkews.getMedian();
            this.metrics.MEDIAN_5PRIME_TO_3PRIME_BIAS = fiveToThreeSkews.getMedian();
            return normalizedCoverageByNormalizedPosition;
        }

        private double[] copyAndReverse(double[] in) {
            double[] out = new double[in.length];
            int i = 0;
            int j = in.length - 1;
            while (i < in.length) {
                out[j] = in[i];
                ++i;
                --j;
            }
            return out;
        }

        public Map<Gene.Transcript, int[]> pickTranscripts(Map<Gene.Transcript, int[]> transcriptCoverage) {
            HashMap<Gene.Transcript, Double> bestPerGene = new HashMap<Gene.Transcript, Double>();
            for (Gene gene : CollectRnaSeqMetrics.this.geneOverlapDetector.getAll()) {
                Gene.Transcript best = null;
                double bestMean = 0.0;
                for (Gene.Transcript transcript : gene) {
                    double mean;
                    int[] cov = transcriptCoverage.get(transcript);
                    if (transcript.length() < Math.max(CollectRnaSeqMetrics.this.MINIMUM_LENGTH, 100) || cov == null || (mean = MathUtil.mean(MathUtil.promote(cov), 0, cov.length)) < 1.0 || best != null && !(mean > bestMean)) continue;
                    best = transcript;
                    bestMean = mean;
                }
                if (best == null) continue;
                bestPerGene.put(best, bestMean);
            }
            double[] coverages = new double[bestPerGene.size()];
            int i = 0;
            Iterator iterator = bestPerGene.values().iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                coverages[i++] = d;
            }
            Arrays.sort(coverages);
            double min = coverages.length == 0 ? 0.0 : coverages[Math.max(0, coverages.length - 1001)];
            HashMap<Gene.Transcript, int[]> retval = new HashMap<Gene.Transcript, int[]>();
            for (Map.Entry entry : bestPerGene.entrySet()) {
                Gene.Transcript tx = (Gene.Transcript)entry.getKey();
                double coverage = (Double)entry.getValue();
                if (!(coverage >= min)) continue;
                retval.put(tx, transcriptCoverage.get(tx));
            }
            return retval;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$net$sf$picard$annotation$LocusFunction() {
            if ($SWITCH_TABLE$net$sf$picard$annotation$LocusFunction != null) {
                return $SWITCH_TABLE$net$sf$picard$annotation$LocusFunction;
            }
            int[] nArray = new int[LocusFunction.values().length];
            try {
                nArray[LocusFunction.CODING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LocusFunction.INTERGENIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LocusFunction.INTRONIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LocusFunction.RIBOSOMAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LocusFunction.UTR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$net$sf$picard$annotation$LocusFunction = nArray;
            return nArray;
        }
    }

    public static enum StrandSpecificity {
        NONE,
        FIRST_READ_TRANSCRIPTION_STRAND,
        SECOND_READ_TRANSCRIPTION_STRAND;

    }
}

