/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.illumina.parser.BclData;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.PerTilePerCycleParser;
import net.sf.picard.illumina.parser.readers.BclReader;
import net.sf.picard.util.CollectionUtil;

class BclParser
extends PerTilePerCycleParser<BclData> {
    private static final int EAMSS_M2_GE_THRESHOLD = 30;
    private static final int EAMSS_S1_LT_THRESHOLD = 15;
    public static final byte MASKING_QUALITY = 2;
    private static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores));

    public BclParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, OutputMapping outputMapping) {
        super(directory, lane, tilesToCycleFiles, outputMapping);
    }

    @Override
    protected BclData makeData(int[] outputLengths) {
        return new BclData(outputLengths);
    }

    @Override
    protected PerTilePerCycleParser.CycleFileParser<BclData> makeCycleFileParser(File file, int cycle) {
        return new PerTilePerCycleParser.CycleFileParser<BclData>(cycle, file){
            final OutputMapping.TwoDIndex cycleOutputIndex;
            BclReader reader;
            {
                this.cycleOutputIndex = BclParser.this.outputMapping.getOutputIndexForCycle(n);
                this.reader = new BclReader(file);
            }

            @Override
            public void close() {
                this.reader = null;
            }

            @Override
            public void next(BclData ild) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BclReader.BclValue value = this.reader.next();
                ild.getBases()[this.cycleOutputIndex.majorIndex][this.cycleOutputIndex.minorIndex] = value.base;
                ild.getQualities()[this.cycleOutputIndex.majorIndex][this.cycleOutputIndex.minorIndex] = value.quality;
            }

            @Override
            public boolean hasNext() {
                return this.reader != null && this.reader.hasNext();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public BclData next() {
        BclData bclData = (BclData)super.next();
        byte[][] bases = bclData.bases;
        byte[][] qualities = bclData.qualities;
        int i = 0;
        while (i < bases.length) {
            BclParser.runEamssForReadInPlace(bases[i], qualities[i]);
            ++i;
        }
        return bclData;
    }

    protected static void runEamssForReadInPlace(byte[] bases, byte[] qualities) {
        int eamssTally = 0;
        int maxTally = Integer.MIN_VALUE;
        int indexOfMax = -1;
        int i = bases.length - 1;
        while (i >= 0) {
            int quality = 0xFF & qualities[i];
            if (quality >= 30) {
                eamssTally -= 2;
            } else if (quality < 15) {
                ++eamssTally;
            }
            if (eamssTally >= maxTally) {
                indexOfMax = i;
                maxTally = eamssTally;
            }
            --i;
        }
        if (maxTally >= 1) {
            int numGs = 0;
            int exceptions = 0;
            int i2 = indexOfMax;
            while (i2 >= 0) {
                if (bases[i2] == 71) {
                    ++numGs;
                } else {
                    Integer skip = BclParser.skipBy(i2, numGs, exceptions, bases);
                    if (skip == null) break;
                    exceptions += skip.intValue();
                    numGs += skip.intValue();
                    i2 -= skip - 1;
                }
                --i2;
            }
            if (numGs >= 10) {
                indexOfMax = indexOfMax + 1 - numGs;
            }
            i2 = indexOfMax;
            while (i2 < qualities.length) {
                qualities[i2] = 2;
                ++i2;
            }
        }
    }

    private static Integer skipBy(int index, int numGs, int prevExceptions, byte[] bases) {
        Integer skip = null;
        int backup = 1;
        while (backup <= index) {
            int exceptionLimit = Math.max((numGs + backup) / 10, 1);
            if (prevExceptions + backup > exceptionLimit) break;
            if (bases[index - backup] == 71) {
                skip = backup;
                break;
            }
            ++backup;
        }
        return skip;
    }
}

