/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.samtools.util.StringUtil;

class CycleIlluminaFileMap
extends TreeMap<Integer, CycleFilesIterator> {
    CycleIlluminaFileMap() {
    }

    public CycleIlluminaFileMap keep(List<Integer> tilesToKeep, int[] cycles) {
        if (tilesToKeep == null) {
            tilesToKeep = new ArrayList(this.keySet());
        }
        CycleIlluminaFileMap ciMap = new CycleIlluminaFileMap();
        for (Integer tile : tilesToKeep) {
            CycleFilesIterator template = (CycleFilesIterator)this.get(tile);
            if (template == null) continue;
            ciMap.put(tile, new CycleFilesIterator((CycleFilesIterator)this.get(tile), cycles));
        }
        return ciMap;
    }

    public void assertValid(List<Integer> expectedTiles, int[] expectedCycles) {
        if (this.size() != expectedTiles.size()) {
            throw new PicardException("Expected CycledIlluminaFileMap to contain " + expectedTiles + " tiles but only " + this.size() + " were found!");
        }
        File curFile = null;
        for (int tile : expectedTiles) {
            CycleFilesIterator cycleFiles = new CycleFilesIterator((CycleFilesIterator)this.get(tile), null);
            int total = 0;
            while (cycleFiles.hasNext()) {
                if (cycleFiles.getNextCycle() != expectedCycles[total]) {
                    if (curFile == null) {
                        curFile = cycleFiles.next();
                    }
                    cycleFiles.reset();
                    throw new PicardException("Cycles in iterator(" + CycleIlluminaFileMap.remainingCyclesToString(cycleFiles) + ") do not match those expected (" + StringUtil.intValuesToString(expectedCycles) + ") Last file checked (" + curFile.getAbsolutePath() + ")");
                }
                curFile = cycleFiles.next();
                if (!curFile.exists()) {
                    throw new PicardException("Missing cycle file " + curFile.getName() + " in CycledIlluminaFileMap");
                }
                ++total;
            }
            if (total == expectedCycles.length) continue;
            String message = "Expected tile " + tile + " of CycledIlluminaFileMap to contain " + expectedCycles + " cycles but " + total + " were found!";
            if (curFile != null) {
                message = String.valueOf(message) + "Check to see if the following bcl exists: " + CycleIlluminaFileMap.incrementCycleCount(curFile).getAbsolutePath();
            }
            throw new PicardException(message);
        }
    }

    public static File incrementCycleCount(File cycleFile) {
        File cycleDir = cycleFile.getParentFile();
        int cycle = Integer.parseInt(cycleDir.getName().substring(1, cycleDir.getName().lastIndexOf(".")));
        return new File(cycleDir.getParentFile(), "C" + cycle + ".1" + File.separator + cycleFile.getName());
    }

    public static String remainingCyclesToString(CycleFilesIterator cfi) {
        String cycles = "";
        if (cfi.hasNext()) {
            cycles = String.valueOf(cycles) + cfi.getNextCycle();
            cfi.next();
        }
        while (cfi.hasNext()) {
            cycles = String.valueOf(cycles) + ", " + cfi.getNextCycle();
            cfi.next();
        }
        return cycles;
    }
}

