/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.illumina.parser.Range;
import net.sf.picard.illumina.parser.ReadDescriptor;
import net.sf.picard.illumina.parser.ReadType;
import net.sf.samtools.util.CoordMath;

public class ReadStructure {
    public final List<ReadDescriptor> descriptors;
    public final int totalCycles;
    public final int[] readLengths;
    public final Substructure barcodes;
    public final Substructure templates;
    public final Substructure skips;
    public final Substructure nonSkips;
    private static final String ValidTypeChars;
    private static final String ValidTypeCharsWSep;
    private static final String ReadStructureMsg;
    private static final Pattern FullPattern;
    private static final Pattern SubPattern;

    static {
        String validTypes = "";
        String vtWSep = "";
        boolean written = false;
        ReadType[] readTypeArray = ReadType.values();
        int n = readTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReadType rt = readTypeArray[n2];
            if (written) {
                vtWSep = String.valueOf(vtWSep) + ",";
            }
            validTypes = String.valueOf(validTypes) + rt.name();
            vtWSep = String.valueOf(vtWSep) + rt.name();
            ++n2;
        }
        ValidTypeChars = validTypes;
        ValidTypeCharsWSep = vtWSep;
        ReadStructureMsg = "Read structure must be formatted as follows: <number of bases><type><number of bases><type>...<number of bases> where number of bases is a positive (NON-ZERO) integer and type is one of the following characters " + ValidTypeCharsWSep + " (e.g. 76T8B68T would denote a paired-end run with a 76 base first end an 8 base barcode followed by a 68 base second end).";
        FullPattern = Pattern.compile("^((\\d+[" + ValidTypeChars + "]{1}))+$");
        SubPattern = Pattern.compile("(\\d+)([" + ValidTypeChars + "]{1})");
    }

    public ReadStructure(List<ReadDescriptor> collection) {
        if (collection.size() == 0) {
            throw new IllegalArgumentException("ReadStructure does not support 0 length clusters!");
        }
        ArrayList<Range> allRanges = new ArrayList<Range>(collection.size());
        this.descriptors = Collections.unmodifiableList(collection);
        int cycles = 0;
        ArrayList<Integer> nonSkipIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> barcodeIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> templateIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> skipIndicesList = new ArrayList<Integer>();
        this.readLengths = new int[collection.size()];
        int currentCycleIndex = 0;
        int descIndex = 0;
        for (ReadDescriptor desc : this.descriptors) {
            if (desc.length == 0 || desc.length < 0) {
                throw new IllegalArgumentException("ReadStructure only supports ReadDescriptor lengths > 0, found(" + desc.length + ")");
            }
            int endIndexOfRange = CoordMath.getEnd(currentCycleIndex, desc.length);
            allRanges.add(new Range(currentCycleIndex, endIndexOfRange));
            currentCycleIndex = endIndexOfRange + 1;
            this.readLengths[descIndex] = desc.length;
            cycles += desc.length;
            switch (desc.type) {
                case B: {
                    nonSkipIndicesList.add(descIndex);
                    barcodeIndicesList.add(descIndex);
                    break;
                }
                case T: {
                    nonSkipIndicesList.add(descIndex);
                    templateIndicesList.add(descIndex);
                    break;
                }
                case S: {
                    skipIndicesList.add(descIndex);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported ReadType (" + (Object)((Object)desc.type) + ") encountered by IlluminaRunConfiugration!");
                }
            }
            ++descIndex;
        }
        this.totalCycles = cycles;
        this.barcodes = new Substructure(barcodeIndicesList, allRanges);
        this.templates = new Substructure(templateIndicesList, allRanges);
        this.skips = new Substructure(skipIndicesList, allRanges);
        this.nonSkips = new Substructure(nonSkipIndicesList, allRanges);
    }

    public ReadStructure(String readStructureString) {
        this(ReadStructure.readStructureStringToDescriptors(readStructureString));
    }

    public int getNumDescriptors() {
        return this.descriptors.size();
    }

    public String toString() {
        String out = "";
        for (ReadDescriptor rd : this.descriptors) {
            out = String.valueOf(out) + rd.toString();
        }
        return out;
    }

    private static final List<ReadDescriptor> readStructureStringToDescriptors(String readStructure) {
        Matcher fullMatcher = FullPattern.matcher(readStructure);
        if (!fullMatcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(readStructure) + " cannot be parsed as a ReadStructure! " + ReadStructureMsg);
        }
        Matcher subMatcher = SubPattern.matcher(readStructure);
        ArrayList<ReadDescriptor> descriptors = new ArrayList<ReadDescriptor>();
        while (subMatcher.find()) {
            ReadDescriptor rd = new ReadDescriptor(Integer.parseInt(subMatcher.group(1)), ReadType.valueOf(subMatcher.group(2)));
            descriptors.add(rd);
        }
        return descriptors;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.getClass() != thatObj.getClass()) {
            return false;
        }
        ReadStructure that = (ReadStructure)thatObj;
        if (this.descriptors.size() != that.descriptors.size()) {
            return false;
        }
        int i = 0;
        while (i < this.descriptors.size()) {
            if (!this.descriptors.get(i).equals(that.descriptors.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int res = this.descriptors.get(0).hashCode();
        int i = 1;
        while (i < this.descriptors.size()) {
            res *= this.descriptors.get(i).hashCode();
            ++i;
        }
        return res;
    }

    private class IndexedIterator
    implements Iterator<ReadDescriptor> {
        private int index;
        private int[] indices;

        public IndexedIterator(int[] indices) {
            this.indices = indices;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.indices.length;
        }

        @Override
        public ReadDescriptor next() {
            return ReadStructure.this.descriptors.get(this.indices[this.index++]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Substructure
    implements Iterable<ReadDescriptor> {
        private final int numDescriptors;
        private final int[] descriptorIndices;
        private final int[] descriptorLengths;
        private final Range[] cycleIndexRanges;
        private final int totalCycles;

        public Substructure(List<Integer> descriptorIndices, List<Range> allRanges) {
            this.numDescriptors = descriptorIndices.size();
            this.descriptorIndices = new int[this.numDescriptors];
            this.descriptorLengths = new int[this.numDescriptors];
            int i = 0;
            while (i < descriptorIndices.size()) {
                this.descriptorIndices[i] = descriptorIndices.get(i);
                this.descriptorLengths[i] = ReadStructure.this.descriptors.get((int)this.descriptorIndices[i]).length;
                ++i;
            }
            this.cycleIndexRanges = new Range[this.numDescriptors];
            i = 0;
            while (i < this.numDescriptors) {
                this.cycleIndexRanges[i] = allRanges.get(this.descriptorIndices[i]);
                ++i;
            }
            int totalLength = 0;
            int[] nArray = this.descriptorLengths;
            int n = this.descriptorLengths.length;
            int n2 = 0;
            while (n2 < n) {
                int length = nArray[n2];
                totalLength += length;
                ++n2;
            }
            this.totalCycles = totalLength;
        }

        public ReadDescriptor get(int index) {
            return ReadStructure.this.descriptors.get(this.descriptorIndices[index]);
        }

        public boolean isEmpty() {
            return this.numDescriptors == 0;
        }

        public int length() {
            return this.numDescriptors;
        }

        public int getTotalCycles() {
            return this.totalCycles;
        }

        public int[] getIndices() {
            return this.descriptorIndices;
        }

        public int[] getDescriptorLengths() {
            return this.descriptorLengths;
        }

        public Range[] getCycleIndexRanges() {
            return this.cycleIndexRanges;
        }

        @Override
        public Iterator<ReadDescriptor> iterator() {
            return new IndexedIterator(this.descriptorIndices);
        }

        public int[] getCycles() {
            int[] cycles = new int[this.totalCycles];
            int cycleIndex = 0;
            Range[] rangeArray = this.cycleIndexRanges;
            int n = this.cycleIndexRanges.length;
            int n2 = 0;
            while (n2 < n) {
                Range range = rangeArray[n2];
                int i = range.start;
                while (i <= range.end) {
                    cycles[cycleIndex++] = i + 1;
                    ++i;
                }
                ++n2;
            }
            return cycles;
        }

        public ReadStructure toReadStructure() {
            ArrayList<ReadDescriptor> descriptors = new ArrayList<ReadDescriptor>(this.numDescriptors);
            for (ReadDescriptor rd : this) {
                descriptors.add(rd);
            }
            return new ReadStructure(descriptors);
        }
    }
}

