/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.illumina.parser.readers.MMapBackedIteratorFactory;
import net.sf.picard.util.UnsignedTypeUtil;

public class ClocsFileReader
extends AbstractIlluminaPositionFileReader {
    private static final int HEADER_SIZE = 5;
    private static final int IMAGE_WIDTH = 2048;
    private static final int BLOCK_SIZE = 25;
    private static final int NUM_BINS_IN_ROW = (int)Math.ceil(81.92);
    private final long numBins;
    private final BinaryFileIterator<Byte> byteIterator;
    private float xOffset;
    private float yOffset;
    private long currentBin;
    private int numClustersInBin;
    private long currentClusterInBin;

    public ClocsFileReader(File clocsFile) {
        super(clocsFile);
        this.byteIterator = MMapBackedIteratorFactory.getByteIterator(5, clocsFile);
        ByteBuffer hbs = this.byteIterator.getHeaderBytes();
        hbs.get();
        this.numBins = UnsignedTypeUtil.uIntToLong(hbs.getInt());
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        this.currentBin = 0L;
        this.startBlock();
        this.checkAndAdvanceBin();
    }

    @Override
    protected AbstractIlluminaPositionFileReader.PositionInfo unsafeNextInfo() {
        byte xByte = this.byteIterator.next();
        byte yByte = this.byteIterator.next();
        float xPos = (float)UnsignedTypeUtil.uByteToInt(xByte) / 10.0f + this.xOffset;
        float yPos = (float)UnsignedTypeUtil.uByteToInt(yByte) / 10.0f + this.yOffset;
        ++this.currentClusterInBin;
        this.checkAndAdvanceBin();
        return new AbstractIlluminaPositionFileReader.PositionInfo(xPos, yPos, this.getLane(), this.getTile());
    }

    private void checkAndAdvanceBin() {
        while (this.currentClusterInBin >= (long)this.numClustersInBin && this.currentBin < this.numBins) {
            if ((this.currentBin + 1L) % (long)NUM_BINS_IN_ROW == 0L) {
                this.xOffset = 0.0f;
                this.yOffset += 25.0f;
            } else {
                this.xOffset += 25.0f;
            }
            ++this.currentBin;
            if (this.currentBin >= this.numBins) continue;
            this.startBlock();
        }
    }

    private void startBlock() {
        this.numClustersInBin = UnsignedTypeUtil.uByteToInt(this.byteIterator.next());
        this.currentClusterInBin = 0L;
    }

    @Override
    protected String makeExceptionMsg() {
        return "ClocsFileReader(file=" + this.getFile().getName() + ", lane=" + this.getLane() + ", tile=" + this.getTile() + ", currentBin=" + this.currentBin + ", numBins=" + this.numBins + ", xOffset=" + this.xOffset + ", yOffset" + this.yOffset + ", currentBlock=" + this.currentClusterInBin + ", numBlocks=" + this.numClustersInBin;
    }

    @Override
    public boolean hasNext() {
        boolean valuesRemain;
        boolean bl = valuesRemain = this.currentClusterInBin < (long)this.numClustersInBin || this.currentBin < this.numBins - 1L;
        if (!valuesRemain && this.byteIterator.hasNext()) {
            throw new PicardException("Read the number of expected bins( " + this.numBins + ") but still had more elements in file( " + this.byteIterator.getFile().getAbsolutePath() + ") ");
        }
        return valuesRemain;
    }

    @Override
    public void close() {
    }
}

