/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.sf.picard.PicardException;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMTag;
import net.sf.samtools.util.CloseableIterator;

class MultiHitAlignedReadIterator
implements CloseableIterator<HitsForInsert> {
    private static final Log log = Log.getInstance(MultiHitAlignedReadIterator.class);
    private final PeekableIterator<SAMRecord> peekIterator;
    private final HitIndexComparator comparator = new HitIndexComparator();
    private final SAMRecordQueryNameComparator queryNameComparator = new SAMRecordQueryNameComparator();
    private final Random random = new Random(1L);

    MultiHitAlignedReadIterator(CloseableIterator<SAMRecord> querynameOrderIterator) {
        this.peekIterator = new PeekableIterator<SAMRecord>(new FilteringIterator(querynameOrderIterator, new SamRecordFilter(){

            @Override
            public boolean filterOut(SAMRecord record) {
                return record.getReadUnmappedFlag();
            }

            @Override
            public boolean filterOut(SAMRecord first, SAMRecord second) {
                return first.getReadUnmappedFlag() && second.getReadUnmappedFlag();
            }
        }));
    }

    @Override
    public void close() {
        this.peekIterator.close();
    }

    @Override
    public boolean hasNext() {
        return this.peekIterator.hasNext();
    }

    @Override
    public HitsForInsert next() {
        String readName = this.peekIterator.peek().getReadName();
        HitsForInsert hits = new HitsForInsert();
        Boolean isPaired = null;
        while (this.peekIterator.hasNext() && this.peekIterator.peek().getReadName().equals(readName)) {
            SAMRecord rec = this.peekIterator.next();
            if (this.peekIterator.hasNext() && this.queryNameComparator.fileOrderCompare(rec, this.peekIterator.peek()) > 0) {
                throw new IllegalStateException("Underlying iterator is not queryname sorted: " + rec + " > " + this.peekIterator.peek());
            }
            if (isPaired == null) {
                isPaired = rec.getReadPairedFlag();
            } else if (isPaired.booleanValue() != rec.getReadPairedFlag()) {
                throw new PicardException("Got a mix of paired and unpaired alignments for read " + readName);
            }
            if (!rec.getReadPairedFlag() || rec.getFirstOfPairFlag()) {
                hits.firstOfPairOrFragment.add(rec);
                continue;
            }
            if (rec.getSecondOfPairFlag()) {
                hits.secondOfPair.add(rec);
                continue;
            }
            throw new PicardException("Read is marked as pair but neither first or second: " + readName);
        }
        if (!hits.firstOfPairOrFragment.isEmpty() && !hits.secondOfPair.isEmpty()) {
            if (hits.firstOfPairOrFragment.size() != hits.secondOfPair.size()) {
                throw new PicardException("Unequal number of first and second of pair hits for read: " + readName);
            }
            if (hits.firstOfPairOrFragment.size() > 1) {
                Collections.sort(hits.firstOfPairOrFragment, this.comparator);
                Collections.sort(hits.secondOfPair, this.comparator);
                int i = 0;
                while (i < hits.firstOfPairOrFragment.size()) {
                    if (((SAMRecord)hits.firstOfPairOrFragment.get(i)).getIntegerAttribute(SAMTag.HI.name()) == null) {
                        throw new PicardException("Missing HI tag on multi-hit alignment for read: " + readName);
                    }
                    if (!((SAMRecord)hits.firstOfPairOrFragment.get(i)).getIntegerAttribute(SAMTag.HI.name()).equals(((SAMRecord)hits.secondOfPair.get(i)).getIntegerAttribute(SAMTag.HI.name()))) {
                        throw new PicardException("Hit index mismatch for multi-hit alignment for read: " + readName);
                    }
                    ++i;
                }
            }
        }
        int firstEndPrimaryAlignmentIndex = hits.findPrimaryAlignment(hits.firstOfPairOrFragment);
        int secondEndPrimaryAlignmentIndex = hits.findPrimaryAlignment(hits.secondOfPair);
        if (firstEndPrimaryAlignmentIndex == -1 && secondEndPrimaryAlignmentIndex == -1) {
            hits.pickPrimaryAlignment();
        } else if (firstEndPrimaryAlignmentIndex != -1 && secondEndPrimaryAlignmentIndex != -1 && firstEndPrimaryAlignmentIndex != secondEndPrimaryAlignmentIndex) {
            throw new PicardException("Mismatched primary alignments for paired read " + hits.getReadName());
        }
        return hits;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class HitIndexComparator
    implements Comparator<SAMRecord> {
        private HitIndexComparator() {
        }

        @Override
        public int compare(SAMRecord rec1, SAMRecord rec2) {
            Integer hi1 = rec1.getIntegerAttribute(SAMTag.HI.name());
            Integer hi2 = rec2.getIntegerAttribute(SAMTag.HI.name());
            if (hi1 == null || hi2 == null) {
                throw new PicardException("HI tag missing for multi-hit paired alignments for read: " + rec1.getReadName());
            }
            return hi1.compareTo(hi2);
        }
    }

    public class HitsForInsert {
        private final List<SAMRecord> firstOfPairOrFragment = new ArrayList<SAMRecord>();
        private final List<SAMRecord> secondOfPair = new ArrayList<SAMRecord>();

        public String getReadName() {
            return this.getRepresentativeRead().getReadName();
        }

        public boolean isPaired() {
            return this.getRepresentativeRead().getReadPairedFlag();
        }

        private SAMRecord getRepresentativeRead() {
            for (SAMRecord rec : this.firstOfPairOrFragment) {
                if (rec == null) continue;
                return rec;
            }
            for (SAMRecord rec : this.secondOfPair) {
                if (rec == null) continue;
                return rec;
            }
            throw new IllegalStateException("Should not be called if numHits == 0");
        }

        public int numHits() {
            return Math.max(this.firstOfPairOrFragment.size(), this.secondOfPair.size());
        }

        public SAMRecord getFirstOfPair(int i) {
            if (this.firstOfPairOrFragment.isEmpty()) {
                return null;
            }
            return this.firstOfPairOrFragment.get(i);
        }

        public SAMRecord getFragment(int i) {
            SAMRecord samRecord = this.firstOfPairOrFragment.get(i);
            if (samRecord.getReadPairedFlag()) {
                throw new UnsupportedOperationException("getFragment called for paired read");
            }
            return samRecord;
        }

        public SAMRecord getSecondOfPair(int i) {
            if (this.secondOfPair.isEmpty()) {
                return null;
            }
            return this.secondOfPair.get(i);
        }

        public void filterReads(SamRecordFilter filter) {
            int i;
            this.filterReads(filter, this.firstOfPairOrFragment);
            this.filterReads(filter, this.secondOfPair);
            if (!this.firstOfPairOrFragment.isEmpty() && !this.secondOfPair.isEmpty()) {
                if (this.firstOfPairOrFragment.size() != this.secondOfPair.size()) {
                    throw new IllegalStateException("Both ends of pair have hits, but not the same number of hits for each end");
                }
                i = this.firstOfPairOrFragment.size() - 1;
                while (i >= 0) {
                    if (this.firstOfPairOrFragment.get(i) == null) {
                        if (this.secondOfPair.get(i) == null) {
                            this.firstOfPairOrFragment.remove(i);
                            this.secondOfPair.remove(i);
                        } else {
                            this.secondOfPair.get(i).setAttribute(SAMTag.HI.name(), null);
                        }
                    } else if (this.secondOfPair.get(i) == null) {
                        this.firstOfPairOrFragment.get(i).setAttribute(SAMTag.HI.name(), null);
                    }
                    --i;
                }
                if (this.areAllElementsNull(this.firstOfPairOrFragment)) {
                    this.firstOfPairOrFragment.clear();
                }
                if (this.areAllElementsNull(this.secondOfPair)) {
                    this.secondOfPair.clear();
                }
            } else {
                this.squeezeList(this.firstOfPairOrFragment);
                this.squeezeList(this.secondOfPair);
            }
            if (this.numHits() == 0) {
                return;
            }
            if (this.numHits() == 1) {
                if (this.getFirstOfPair(0) != null) {
                    this.getFirstOfPair(0).setAttribute(SAMTag.HI.name(), null);
                }
                if (this.getSecondOfPair(0) != null) {
                    this.getSecondOfPair(0).setAttribute(SAMTag.HI.name(), null);
                }
            } else {
                i = 0;
                while (i < this.numHits()) {
                    if (this.getFirstOfPair(i) != null) {
                        this.getFirstOfPair(i).setAttribute(SAMTag.HI.name(), (Object)i);
                    }
                    if (this.getSecondOfPair(i) != null) {
                        this.getSecondOfPair(i).setAttribute(SAMTag.HI.name(), (Object)i);
                    }
                    ++i;
                }
            }
            int firstEndPrimaryAlignmentIndex = this.findPrimaryAlignment(this.firstOfPairOrFragment);
            int secondEndPrimaryAlignmentIndex = this.findPrimaryAlignment(this.secondOfPair);
            if (firstEndPrimaryAlignmentIndex != -1 ? (secondEndPrimaryAlignmentIndex == -1 ? this.getSecondOfPair(firstEndPrimaryAlignmentIndex) != null : firstEndPrimaryAlignmentIndex != secondEndPrimaryAlignmentIndex) : secondEndPrimaryAlignmentIndex != -1 && this.getFirstOfPair(secondEndPrimaryAlignmentIndex) != null) {
                throw new IllegalStateException("Mismatched primary alignments for read " + this.getReadName());
            }
            if (firstEndPrimaryAlignmentIndex == -1 && secondEndPrimaryAlignmentIndex == -1) {
                this.pickPrimaryAlignment();
            }
        }

        private void pickPrimaryAlignment() {
            int primaryAlignmentIndex;
            log.info("Primary alignment was filtered out.  Selecting new primary alignment for read ", this.getReadName());
            ArrayList<Integer> primaryAlignmentIndices = new ArrayList<Integer>(this.numHits());
            int bestMapQ = -1;
            int i = 0;
            while (i < this.numHits()) {
                int thisMapQ = 0;
                if (this.getFirstOfPair(i) != null) {
                    thisMapQ += this.getFirstOfPair(i).getMappingQuality();
                }
                if (this.getSecondOfPair(i) != null) {
                    thisMapQ += this.getSecondOfPair(i).getMappingQuality();
                }
                if (thisMapQ > bestMapQ) {
                    bestMapQ = thisMapQ;
                    primaryAlignmentIndices.clear();
                }
                if (thisMapQ == bestMapQ) {
                    primaryAlignmentIndices.add(i);
                }
                ++i;
            }
            if (primaryAlignmentIndices.size() == 1) {
                primaryAlignmentIndex = (Integer)primaryAlignmentIndices.get(0);
            } else if (primaryAlignmentIndices.size() > 1) {
                primaryAlignmentIndex = MultiHitAlignedReadIterator.this.random.nextInt(primaryAlignmentIndices.size());
            } else {
                throw new IllegalStateException("Never found a best MAPQ -- should never happen");
            }
            if (this.getFirstOfPair(primaryAlignmentIndex) != null) {
                this.getFirstOfPair(primaryAlignmentIndex).setNotPrimaryAlignmentFlag(false);
            }
            if (this.getSecondOfPair(primaryAlignmentIndex) != null) {
                this.getSecondOfPair(primaryAlignmentIndex).setNotPrimaryAlignmentFlag(false);
            }
        }

        private void filterReads(SamRecordFilter filter, List<SAMRecord> records) {
            int i = 0;
            while (i < records.size()) {
                if (filter.filterOut(records.get(i))) {
                    records.set(i, null);
                }
                ++i;
            }
        }

        private void squeezeList(List<SAMRecord> records) {
            int i = records.size() - 1;
            while (i >= 0) {
                if (records.get(i) == null) {
                    records.remove(i);
                }
                --i;
            }
        }

        private boolean areAllElementsNull(List<SAMRecord> records) {
            for (SAMRecord rec : records) {
                if (rec == null) continue;
                return false;
            }
            return true;
        }

        private int findPrimaryAlignment(List<SAMRecord> records) {
            int indexOfPrimaryAlignment = -1;
            int i = 0;
            while (i < records.size()) {
                if (records.get(i) != null && !records.get(i).getNotPrimaryAlignmentFlag()) {
                    if (indexOfPrimaryAlignment != -1) {
                        throw new IllegalStateException("Multiple primary alignments found for read " + this.getReadName());
                    }
                    indexOfPrimaryAlignment = i;
                }
                ++i;
            }
            return indexOfPrimaryAlignment;
        }
    }
}

