/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.AbstractInputParser;
import net.sf.samtools.util.BufferedLineReader;
import net.sf.samtools.util.RuntimeIOException;

public class BasicInputParser
extends AbstractInputParser {
    private BufferedLineReader reader;
    private final ArrayList<InputStream> inputs = new ArrayList();
    private final ArrayList<String> fileNames = new ArrayList();
    String currentFileName = null;
    private String currentLine = null;
    private String nextLine = null;
    private int currentLineNumber = 0;
    private int nextLineNumber = 0;

    public BasicInputParser(boolean treatGroupedDelimitersAsOne, InputStream ... inputStreams) {
        if (inputStreams.length == 0) {
            throw new IllegalArgumentException("At least one input must be specified.");
        }
        this.inputs.addAll(Arrays.asList(inputStreams));
        this.reader = new BufferedLineReader(this.inputs.remove(0));
        this.setTreatGroupedDelimitersAsOne(treatGroupedDelimitersAsOne);
    }

    public BasicInputParser(boolean treatGroupedDelimitersAsOne, int wordCount, InputStream ... inputStreams) {
        this(treatGroupedDelimitersAsOne, inputStreams);
        this.setWordCount(wordCount);
    }

    public BasicInputParser(boolean treatGroupedDelimitersAsOne, File ... files) {
        this(treatGroupedDelimitersAsOne, BasicInputParser.filesToInputStreams(files));
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.fileNames.add(f.getAbsolutePath());
            ++n2;
        }
        this.currentFileName = this.fileNames.remove(0);
    }

    public BasicInputParser(boolean treatGroupedDelimitersAsOne, int wordCount, File ... files) {
        this(treatGroupedDelimitersAsOne, files);
        this.setWordCount(wordCount);
    }

    @Override
    protected byte[] readNextLine() {
        try {
            String line = this.reader.readLine();
            if (this.nextLine != null && !this.isComment(this.nextLine.getBytes())) {
                this.currentLineNumber = this.nextLineNumber;
                this.currentLine = this.nextLine;
            }
            if (line != null) {
                ++this.nextLineNumber;
                this.nextLine = line;
                return line.getBytes();
            }
            if (this.inputs.size() > 0) {
                this.advanceFile();
                return this.readNextLine();
            }
            return null;
        }
        catch (RuntimeIOException ioe) {
            throw new PicardException("Error reading from file " + this.currentFileName, ioe);
        }
    }

    protected void advanceFile() {
        this.currentFileName = this.fileNames.size() > 0 ? this.fileNames.remove(0) : null;
        this.nextLineNumber = 0;
        this.nextLine = null;
        this.reader = new BufferedLineReader(this.inputs.remove(0));
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public String getFileName() {
        return this.currentFileName != null ? this.currentFileName : "(file name unavailable)";
    }

    public String getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    private static InputStream[] filesToInputStreams(File[] files) {
        InputStream[] result = new InputStream[files.length];
        int i = 0;
        while (i < files.length) {
            result[i] = IoUtil.openFileForReading(files[i]);
            ++i;
        }
        return result;
    }
}

