/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileSpan;

class BAMFileSpan
implements SAMFileSpan,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Chunk> chunks;

    protected BAMFileSpan() {
        this.chunks = new ArrayList<Chunk>();
    }

    protected BAMFileSpan(Chunk chunk) {
        this.chunks = new ArrayList<Chunk>();
        this.chunks.add(chunk);
    }

    protected BAMFileSpan(List<Chunk> chunks) {
        this.chunks = new ArrayList<Chunk>(chunks);
    }

    @Override
    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public BAMFileSpan clone() {
        BAMFileSpan clone = new BAMFileSpan();
        for (Chunk chunk : this.chunks) {
            clone.chunks.add(chunk.clone());
        }
        return clone;
    }

    @Override
    public SAMFileSpan removeContentsBefore(SAMFileSpan fileSpan) {
        if (fileSpan == null) {
            return this.clone();
        }
        if (!(fileSpan instanceof BAMFileSpan)) {
            throw new SAMException("Unable to compare ");
        }
        BAMFileSpan bamFileSpan = (BAMFileSpan)fileSpan;
        if (bamFileSpan.isEmpty()) {
            return this.clone();
        }
        this.validateSorted();
        BAMFileSpan trimmedChunkList = new BAMFileSpan();
        for (Chunk chunkToTrim : this.chunks) {
            if (chunkToTrim.getChunkEnd() <= chunkToTrim.getChunkStart()) continue;
            if (chunkToTrim.getChunkStart() >= bamFileSpan.chunks.get(0).getChunkStart()) {
                trimmedChunkList.add(chunkToTrim.clone());
                continue;
            }
            trimmedChunkList.add(new Chunk(bamFileSpan.chunks.get(0).getChunkStart(), chunkToTrim.getChunkEnd()));
        }
        return trimmedChunkList;
    }

    @Override
    public SAMFileSpan getContentsFollowing() {
        if (this.chunks.isEmpty()) {
            throw new SAMException("Unable to get the file pointer following this one: no data present.");
        }
        this.validateSorted();
        return new BAMFileSpan(new Chunk(this.chunks.get(this.chunks.size() - 1).getChunkEnd(), Long.MAX_VALUE));
    }

    public void add(BAMFileSpan span) {
        for (Chunk c : span.chunks) {
            this.chunks.add(c);
        }
    }

    protected void add(Chunk chunk) {
        this.chunks.add(chunk);
    }

    protected long[] toCoordinateArray() {
        int count = this.chunks.size() * 2;
        if (count == 0) {
            return null;
        }
        int index = 0;
        long[] result = new long[count];
        for (Chunk chunk : this.chunks) {
            result[index++] = chunk.getChunkStart();
            result[index++] = chunk.getChunkEnd();
        }
        return result;
    }

    protected long getFirstOffset() {
        long result = 0L;
        if (this.chunks == null) {
            return result;
        }
        Iterator<Chunk> iterator = this.chunks.iterator();
        if (iterator.hasNext()) {
            Chunk chunk = iterator.next();
            return chunk.getChunkStart();
        }
        return result;
    }

    protected List<Chunk> getChunks() {
        return Collections.unmodifiableList(this.chunks);
    }

    protected Chunk getSingleChunk() {
        if (this.chunks.size() != 1) {
            throw new SAMException("Expecting a single chunk for span. Found " + this.chunks.size());
        }
        return this.chunks.get(0);
    }

    protected static SAMFileSpan toChunkList(long[] coordinateArray) {
        if (coordinateArray.length % 2 != 0) {
            throw new SAMException("Data supplied does not appear to be in coordinate array format.");
        }
        BAMFileSpan chunkList = new BAMFileSpan();
        int i = 0;
        while (i < coordinateArray.length) {
            chunkList.add(new Chunk(coordinateArray[i], coordinateArray[i + 1]));
            i += 2;
        }
        chunkList.validateSorted();
        return chunkList;
    }

    private void validateSorted() {
        int i = 1;
        while (i < this.chunks.size()) {
            if (this.chunks.get(i).getChunkStart() < this.chunks.get(i - 1).getChunkEnd()) {
                throw new SAMException(String.format("Chunk list is unsorted; chunk %s is before chunk %s", this.chunks.get(i - 1), this.chunks.get(i)));
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Chunk chunk : this.chunks) {
            if (!first) {
                builder.append(';');
                first = false;
            }
            builder.append(chunk);
        }
        return builder.toString();
    }
}

