/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.CachingBAMFileIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SAMFileReader reader) {
        if (reader.hasBrowseableIndex()) {
            CachingBAMFileIndex existingIndex = (CachingBAMFileIndex)reader.getBrowseableIndex();
            int n_ref = existingIndex.getNumberOfReferences();
            int chunkCount = 0;
            int indexCount = 0;
            int i = 0;
            while (i < n_ref) {
                BAMIndexContent content = existingIndex.getQueryResults(i);
                for (Chunk c : content.getAllChunks()) {
                    SAMRecordIterator iter = reader.iterator(new BAMFileSpan(c));
                    ++chunkCount;
                    BAMRecord b = null;
                    try {
                        b = (BAMRecord)iter.next();
                        iter.close();
                    }
                    catch (Exception e) {
                        throw new SAMException("Exception in BamIndexValidator. Last good record " + b + " in chunk " + c + " chunkCount=" + chunkCount, e);
                    }
                }
                LinearIndex linearIndex = content.getLinearIndex();
                long[] lArray = linearIndex.getIndexEntries();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long l = lArray[n2];
                    try {
                        if (l != 0L) {
                            SAMRecordIterator iter = reader.iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                            BAMRecord b = (BAMRecord)iter.next();
                            ++indexCount;
                            iter.close();
                        }
                    }
                    catch (Exception e) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + indexCount, e);
                    }
                    ++n2;
                }
                ++i;
            }
            return chunkCount;
        }
        return 0;
    }
}

