/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.nio.ByteBuffer;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;

class BinaryCigarCodec {
    private static final BinaryCigarCodec singleton = new BinaryCigarCodec();

    BinaryCigarCodec() {
    }

    static BinaryCigarCodec getSingleton() {
        return singleton;
    }

    int[] encode(Cigar cigar) {
        if (cigar.numCigarElements() == 0) {
            return new int[0];
        }
        int[] binaryCigar = new int[cigar.numCigarElements()];
        int binaryCigarLength = 0;
        int i = 0;
        while (i < cigar.numCigarElements()) {
            CigarElement cigarElement = cigar.getCigarElement(i);
            int op = CigarOperator.enumToBinary(cigarElement.getOperator());
            binaryCigar[binaryCigarLength++] = cigarElement.getLength() << 4 | op;
            ++i;
        }
        return binaryCigar;
    }

    Cigar decode(ByteBuffer binaryCigar) {
        Cigar ret = new Cigar();
        while (binaryCigar.hasRemaining()) {
            int cigarette = binaryCigar.getInt();
            ret.add(BinaryCigarCodec.binaryCigarToCigarElement(cigarette));
        }
        return ret;
    }

    Cigar decode(int[] binaryCigar) {
        Cigar ret = new Cigar();
        int[] nArray = binaryCigar;
        int n = binaryCigar.length;
        int n2 = 0;
        while (n2 < n) {
            int cigarette = nArray[n2];
            ret.add(BinaryCigarCodec.binaryCigarToCigarElement(cigarette));
            ++n2;
        }
        return ret;
    }

    private static CigarElement binaryCigarToCigarElement(int cigarette) {
        int binaryOp = cigarette & 0xF;
        int length = cigarette >> 4;
        return new CigarElement(length, CigarOperator.binaryToEnum(binaryOp));
    }
}

