/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.util.ArrayList;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.DataSource;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.io.template.FastaHeaderParserInterface;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;

public class GenericFastaHeaderParser<S extends AbstractSequence<C>, C extends Compound>
implements FastaHeaderParserInterface<S, C> {
    private String[] getHeaderValues(String header) {
        String[] data = new String[]{};
        ArrayList<String> values = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        if (!header.startsWith("PDB:")) {
            int i = 0;
            while (i < header.length()) {
                if (header.charAt(i) == '|') {
                    values.add(sb.toString());
                    sb = new StringBuffer();
                } else if (i == header.length() - 1) {
                    sb.append(header.charAt(i));
                    values.add(sb.toString());
                } else {
                    sb.append(header.charAt(i));
                }
                data = new String[values.size()];
                values.toArray(data);
                ++i;
            }
        } else {
            data = header.split(" ");
        }
        return data;
    }

    @Override
    public void parseHeader(String header, S sequence) {
        ((AbstractSequence)sequence).setOriginalHeader(header);
        String[] data = this.getHeaderValues(header);
        if (data.length == 1) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0]));
        } else if (data[0].equalsIgnoreCase("sp") || data[0].equalsIgnoreCase("tr")) {
            if (data[0].equalsIgnoreCase("sp")) {
                ((AbstractSequence)sequence).setAnnotationType(AbstractSequence.AnnotationType.CURATED);
            } else {
                ((AbstractSequence)sequence).setAnnotationType(AbstractSequence.AnnotationType.PREDICTED);
            }
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.UNIPROT));
            if (data.length > 1) {
                ((AbstractSequence)sequence).setDescription(data[2]);
            }
        } else if (data[0].equalsIgnoreCase("gi")) {
            DataSource giSource = DataSource.UNKNOWN;
            if (data.length >= 3) {
                if (data[2].equalsIgnoreCase("gb")) {
                    giSource = DataSource.GENBANK;
                } else if (data[2].equalsIgnoreCase("emb")) {
                    giSource = DataSource.ENA;
                } else if (data[2].equalsIgnoreCase("dbj")) {
                    giSource = DataSource.DDBJ;
                }
                ((AbstractSequence)sequence).setAccession(new AccessionID(data[3], giSource));
            } else {
                ((AbstractSequence)sequence).setAccession(new AccessionID(header, giSource));
            }
        } else if (data[0].equalsIgnoreCase("pir")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.NBRF));
        } else if (data[0].equalsIgnoreCase("prf")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.PRF));
        } else if (data[0].equalsIgnoreCase("pdb")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(String.valueOf(data[1]) + ":" + data[2], DataSource.PDB1));
        } else if (data[0].startsWith("PDB")) {
            String[] pdbe = data[0].split(" ");
            String[] pdbaccession = pdbe[0].split(":");
            ((AbstractSequence)sequence).setAccession(new AccessionID(pdbaccession[1], DataSource.PDBe));
        } else if (data[0].indexOf(":") != -1 && data.length > 1 && data[1].equals("PDBID")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0], DataSource.PDB2));
        } else if (data[0].equalsIgnoreCase("pat")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.PATENTS));
        } else if (data[0].equalsIgnoreCase("bbs")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.GENINFO));
        } else if (data[0].equalsIgnoreCase("gnl")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.GENERAL));
        } else if (data[0].equalsIgnoreCase("ref")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.NCBI));
        } else if (data[0].equalsIgnoreCase("lcl")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.LOCAL));
        } else {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0]));
        }
    }

    public static void main(String[] args) {
        System.out.println("parseHeader");
        String header = "";
        ProteinSequence sequence = new ProteinSequence("");
        GenericFastaHeaderParser instance = new GenericFastaHeaderParser();
        header = "gi|gi-number|gb|accession|locus";
        instance.parseHeader(header, (S)sequence);
        System.out.println("accession=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.GENBANK));
        header = "gi|gi-number|emb|accession|locus";
        instance.parseHeader(header, (S)sequence);
        System.out.println("accession=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.ENA));
        header = "gi|gi-number|dbj|accession|locus";
        instance.parseHeader(header, (S)sequence);
        System.out.println("accession=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.DDBJ));
        header = "pir||entry";
        instance.parseHeader(header, (S)sequence);
        System.out.println("entry=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.NBRF));
        header = "prf||name";
        instance.parseHeader(header, (S)sequence);
        System.out.println("name=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PRF));
        header = "sp|accession|name";
        instance.parseHeader(header, (S)sequence);
        System.out.println("accession=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.UNIPROT));
        header = "pdb|entry|chain";
        instance.parseHeader(header, (S)sequence);
        System.out.println("entry:chain=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PDB1));
        header = "entry:chain|PDBID|CHAIN|SEQUENCE";
        instance.parseHeader(header, (S)sequence);
        System.out.println("entry:chain=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PDB2));
        header = "PDB:1ECY_A mol:protein length:142  ECOTIN";
        instance.parseHeader(header, (S)sequence);
        System.out.println("1ECY_A=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PDBe));
        header = "pat|country|number";
        instance.parseHeader(header, (S)sequence);
        System.out.println("number=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.PATENTS));
        header = "bbs|number";
        instance.parseHeader(header, (S)sequence);
        System.out.println("number=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.GENINFO));
        header = "gnl|database|identifier";
        instance.parseHeader(header, (S)sequence);
        System.out.println("identifier=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.GENERAL));
        header = "ref|accession|locus";
        instance.parseHeader(header, (S)sequence);
        System.out.println("accession=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.NCBI));
        header = "lcl|identifier";
        instance.parseHeader(header, (S)sequence);
        System.out.println("identifier=" + sequence.getAccession());
        System.out.println((Object)((Object)sequence.getAccession().getDataSource()) + "=" + (Object)((Object)DataSource.LOCAL));
    }
}

