/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.location;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava3.core.exceptions.ParserException;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.DataSource;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.location.LocationHelper;
import org.biojava3.core.sequence.location.SimpleLocation;
import org.biojava3.core.sequence.location.SimplePoint;
import org.biojava3.core.sequence.location.template.Location;
import org.biojava3.core.sequence.location.template.Point;

public class InsdcParser {
    private final DataSource dataSource;
    private static final Pattern SINGLE_LOCATION = Pattern.compile("\\A ([A-Za-z.0-9]*?) :? ([<>]?) (\\d+) \\Z", 4);
    private static final Pattern RANGE_LOCATION = Pattern.compile("\\A ([A-Za-z.0-9]*?) :? ([<>]?) (\\d+) ([.^]+) ([<>]?) (\\d+) \\Z", 4);

    public InsdcParser() {
        this(DataSource.ENA);
    }

    public InsdcParser(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Location parse(String locationString) throws ParserException {
        try {
            return this.parse(new StringReader(locationString));
        }
        catch (IOException e) {
            throw new ParserException("Cannot parse the given location '" + locationString + "'", e);
        }
    }

    public Location parse(Reader reader) throws IOException, ParserException {
        List<Location> out = this.parse(reader, Strand.POSITIVE);
        if (out.size() > 1) {
            throw new ParserException("Too many locations parsed " + out);
        }
        if (out.isEmpty()) {
            throw new ParserException("No locations parsed");
        }
        return out.get(0);
    }

    protected List<Location> parse(Reader reader, Strand strand) throws IOException, ParserException {
        StringBuilder sb = new StringBuilder();
        String typeOfJoin = null;
        ArrayList<Location> locationList = new ArrayList<Location>();
        int i = -1;
        block4: while ((i = reader.read()) != -1) {
            char c = (char)i;
            switch (c) {
                case '(': {
                    if (this.isComplement(sb)) {
                        locationList.addAll(this.parse(reader, strand.getReverse()));
                    } else {
                        typeOfJoin = sb.toString();
                        List<Location> subs = this.parse(reader, strand);
                        locationList.add(LocationHelper.location(subs, typeOfJoin));
                    }
                    this.clearStringBuilder(sb);
                    break;
                }
                case ')': 
                case ',': {
                    if (sb.length() > 0) {
                        locationList.add(this.parseLocation(sb.toString(), strand));
                    }
                    if (c == ')') {
                        return locationList;
                    }
                    this.clearStringBuilder(sb);
                    break;
                }
                default: {
                    if (Character.isWhitespace(c)) continue block4;
                    sb.append(c);
                }
            }
        }
        if (sb.length() != 0) {
            locationList.add(this.parseLocation(sb.toString(), strand));
            this.clearStringBuilder(sb);
        }
        return locationList;
    }

    private boolean isComplement(StringBuilder sb) {
        return sb.toString().equals("complement");
    }

    private void clearStringBuilder(StringBuilder sb) {
        sb.delete(0, sb.length());
    }

    protected Location parseLocation(String location, Strand strand) {
        Matcher singleLoc = SINGLE_LOCATION.matcher(location);
        Matcher rangeLoc = RANGE_LOCATION.matcher(location);
        if (rangeLoc.matches()) {
            return this.parseRange(rangeLoc, strand);
        }
        if (singleLoc.matches()) {
            return this.parseSingle(singleLoc, strand);
        }
        throw new ParserException("Location string does not match a single or range location");
    }

    protected Location parseSingle(Matcher matcher, Strand strand) {
        String accession = matcher.group(1);
        String uncertain = matcher.group(2);
        String location = matcher.group(3);
        Point p = this.generatePoint(location, uncertain);
        if (accession == null || "".equals(accession)) {
            return new SimpleLocation(p, p, strand);
        }
        return new SimpleLocation(p, p, strand, this.getAccession(accession));
    }

    protected Location parseRange(Matcher matcher, Strand strand) {
        String accession = matcher.group(1);
        String type = matcher.group(4);
        Point start = this.generatePoint(matcher.group(3), matcher.group(2));
        Point end = this.generatePoint(matcher.group(6), matcher.group(5));
        boolean betweenBases = "^".equals(type);
        if (accession == null || "".equals(accession)) {
            return new SimpleLocation(start, end, strand, false, betweenBases);
        }
        return new SimpleLocation(start, end, strand, betweenBases, this.getAccession(accession));
    }

    protected Point generatePoint(String locationString, String uncertainString) {
        int location = Integer.valueOf(locationString);
        boolean unknown = false;
        boolean uncertain = !"".equals(uncertainString);
        return new SimplePoint(location, unknown, uncertain);
    }

    protected AccessionID getAccession(String accession) {
        return new AccessionID(accession, this.getDataSource());
    }
}

