/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.transcription;

import java.util.ArrayList;
import java.util.List;
import org.biojava3.core.sequence.RNASequence;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava3.core.sequence.template.AbstractCompoundTranslator;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.transcription.Frame;
import org.biojava3.core.sequence.views.RnaSequenceView;

public class DNAToRNATranslator
extends AbstractCompoundTranslator<NucleotideCompound, NucleotideCompound> {
    private final boolean shortCutTranslation;

    public DNAToRNATranslator(SequenceCreatorInterface<NucleotideCompound> rnaCreator, CompoundSet<NucleotideCompound> dna, CompoundSet<NucleotideCompound> rna, boolean shortCutTranslation) {
        super(rnaCreator, dna, rna);
        this.shortCutTranslation = shortCutTranslation;
        this.defaultMappings();
        this.thyamineToUracil();
    }

    @Override
    public List<Sequence<NucleotideCompound>> createSequences(Sequence<NucleotideCompound> originalSequence) {
        if (this.shortCutTranslation) {
            ArrayList<Sequence<NucleotideCompound>> result = new ArrayList<Sequence<NucleotideCompound>>(1);
            result.add(this.wrapToRna(originalSequence));
            return result;
        }
        return super.createSequences(originalSequence);
    }

    protected RNASequence wrapToRna(Sequence<NucleotideCompound> dna) {
        RnaSequenceView rnaView = new RnaSequenceView(dna);
        return new RNASequence(rnaView);
    }

    private void defaultMappings() {
        NucleotideCompound thymine = (NucleotideCompound)this.getFromCompoundSet().getCompoundForString("T");
        for (NucleotideCompound dnaBase : this.getFromCompoundSet().getAllCompounds()) {
            if (dnaBase.equalsIgnoreCase(thymine)) continue;
            NucleotideCompound rnaBase = (NucleotideCompound)this.getToCompoundSet().getCompoundForString(dnaBase.toString());
            this.addCompounds(dnaBase, new NucleotideCompound[]{rnaBase});
        }
    }

    private void thyamineToUracil() {
        this.addCompounds((NucleotideCompound)this.getFromCompoundSet().getCompoundForString("T"), new NucleotideCompound[]{(NucleotideCompound)this.getToCompoundSet().getCompoundForString("U")});
        this.addCompounds((NucleotideCompound)this.getFromCompoundSet().getCompoundForString("t"), new NucleotideCompound[]{(NucleotideCompound)this.getToCompoundSet().getCompoundForString("u")});
    }

    public Sequence<NucleotideCompound> createSequence(Sequence<NucleotideCompound> originalSequence, Frame frame) {
        Sequence<NucleotideCompound> wrapped = frame.wrap(originalSequence);
        return super.createSequence(wrapped);
    }

    @Override
    public Sequence<NucleotideCompound> createSequence(Sequence<NucleotideCompound> originalSequence) {
        return this.createSequence(originalSequence, Frame.getDefaultFrame());
    }

    @Override
    protected void postProcessCompoundLists(List<List<NucleotideCompound>> compoundLists) {
    }
}

