/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.genome.parsers.gff;

import java.util.Collection;
import org.biojava3.core.sequence.DNASequence;

public class GCStats {
    public static double getGCStats(Collection<DNASequence> sequences) {
        double gcCount = 0.0;
        double total = 0.0;
        for (DNASequence sequence : sequences) {
            char[] dna;
            char[] cArray = dna = sequence.toString().toCharArray();
            int n = dna.length;
            int n2 = 0;
            while (n2 < n) {
                char d = cArray[n2];
                if (d == 'G' || d == 'C' || d == 'g' || d == 'c') {
                    gcCount += 1.0;
                }
                total += 1.0;
                ++n2;
            }
        }
        return gcCount / total * 100.0;
    }

    public static double getGCStatsString(Collection<String> sequences) {
        double gcCount = 0.0;
        double total = 0.0;
        for (String sequence : sequences) {
            char[] dna;
            char[] cArray = dna = sequence.toCharArray();
            int n = dna.length;
            int n2 = 0;
            while (n2 < n) {
                char d = cArray[n2];
                if (d == 'G' || d == 'C' || d == 'g' || d == 'c') {
                    gcCount += 1.0;
                }
                total += 1.0;
                ++n2;
            }
        }
        return gcCount / total * 100.0;
    }
}

