/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.genome.parsers.gff;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.biojava3.genome.parsers.gff.Feature;
import org.biojava3.genome.parsers.gff.FeatureList;
import org.biojava3.genome.parsers.gff.Location;

public class GFF3Reader {
    private static final Pattern p = Pattern.compile("\t");
    private static final Logger log = Logger.getLogger(GFF3Reader.class.getName());

    public static FeatureList read(String filename, List<String> indexes) throws IOException {
        log.info("Gff.read(): Reading " + filename);
        FeatureList features = new FeatureList();
        features.addIndexes(indexes);
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String s = br.readLine();
        while (s != null) {
            if ((s = s.trim()).length() > 0) {
                if (s.charAt(0) == '#') {
                    if (s.startsWith("##fasta")) {
                        break;
                    }
                } else {
                    Feature f = GFF3Reader.parseLine(s);
                    if (f != null) {
                        features.add(f);
                    }
                }
            }
            s = br.readLine();
        }
        br.close();
        return features;
    }

    public static FeatureList read(String filename) throws IOException {
        return GFF3Reader.read(filename, new ArrayList<String>(0));
    }

    private static Feature parseLine(String s) {
        int frame;
        Double score;
        String[] line = p.split(s);
        boolean start = false;
        boolean end = false;
        String seqname = line[0].trim();
        String source = line[1].trim();
        String type = line[2].trim();
        String locStart = line[3].trim();
        String locEnd = line[4].trim();
        try {
            score = Double.parseDouble(line[5].trim());
        }
        catch (Exception e) {
            score = 0.0;
        }
        char strand = line[6].trim().charAt(0);
        int locationStart = Integer.parseInt(locStart);
        int locationEnd = Integer.parseInt(locEnd);
        if (locationStart > locationEnd) {
            int temp = locationStart;
            locationStart = locationEnd;
            locationEnd = temp;
        }
        Location location = Location.fromBio(locationStart, locationEnd, strand);
        assert (strand == '-' == location.isNegative());
        try {
            frame = Integer.parseInt(line[7].trim());
        }
        catch (Exception e) {
            frame = -1;
        }
        String attributes = line[8];
        return new Feature(seqname, source, type, location, score, frame, attributes.split("#")[0]);
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        FeatureList listGenes = GFF3Reader.read("/home/melo/workspace/release/stdout.combined.checked2.gtf");
        long stop = System.currentTimeMillis();
        System.out.println("Loading = " + (stop - start));
    }
}

