/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.genome.parsers.gff;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Logger;
import org.biojava3.genome.parsers.gff.Feature;
import org.biojava3.genome.parsers.gff.FeatureList_old;
import org.biojava3.genome.parsers.gff.GFF3Reader;
import org.biojava3.genome.parsers.gff.Location;

public class GFF3Reader_old {
    private static final Logger log = Logger.getLogger(GFF3Reader.class.getName());

    public static FeatureList_old read(String filename) throws IOException {
        log.info("Gff.read(): Reading " + filename);
        FeatureList_old features = new FeatureList_old();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String s = br.readLine();
        while (s != null) {
            if ((s = s.trim()).length() > 0) {
                if (s.charAt(0) == '#') {
                    if (s.startsWith("##fasta")) {
                        break;
                    }
                } else {
                    Feature f = GFF3Reader_old.parseLine(s);
                    if (f != null) {
                        features.add(f);
                    }
                }
            }
            s = br.readLine();
        }
        br.close();
        return features;
    }

    private static Feature parseLine(String s) {
        int frame;
        Double score;
        int end;
        int start = 0;
        start = end = 0;
        end = s.indexOf(9, start);
        String seqname = s.substring(start, end).trim();
        start = end + 1;
        end = s.indexOf(9, start);
        String source = s.substring(start, end).trim();
        start = end + 1;
        end = s.indexOf(9, start);
        String type = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        String locStart = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        String locEnd = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        try {
            score = Double.parseDouble(s.substring(start, end));
        }
        catch (Exception e) {
            score = 0.0;
        }
        start = end + 1;
        end = s.indexOf(9, start);
        char strand = s.charAt(end - 1);
        int locationStart = Integer.parseInt(locStart);
        int locationEnd = Integer.parseInt(locEnd);
        if (locationStart > locationEnd) {
            int temp = locationStart;
            locationStart = locationEnd;
            locationEnd = temp;
        }
        Location location = Location.fromBio(locationStart, locationEnd, strand);
        assert (strand == '-' == location.isNegative());
        start = end + 1;
        end = s.indexOf(9, start);
        try {
            frame = Integer.parseInt(s.substring(start, end));
        }
        catch (Exception e) {
            frame = -1;
        }
        start = end + 1;
        end = s.indexOf(35, start);
        String attributes = null;
        attributes = end < 0 ? new String(s.substring(start)) : new String(s.substring(start, end));
        return new Feature(seqname, source, type, location, score, frame, attributes);
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        FeatureList_old listGenes = GFF3Reader_old.read("/home/melo/workspace/release/stdout.combined.checked2.gtf");
        long stop = System.currentTimeMillis();
        System.out.println(stop - start);
    }
}

