/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.genome.parsers.gff;

import java.util.Iterator;
import java.util.logging.Logger;
import org.biojava3.genome.parsers.gff.Location;

public class LocIterator
implements Iterator<Location> {
    private static final Logger log = Logger.getLogger(LocIterator.class.getName());
    Location mBounds;
    int mPosition;
    int mWindowSize;
    int mIncrement;

    private LocIterator() {
    }

    public LocIterator(Location bounds, int windowSize, int increment) {
        this.mWindowSize = windowSize;
        this.mIncrement = increment;
        this.mBounds = bounds;
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window size must be positive.");
        }
        if (increment == 0) {
            throw new IllegalArgumentException("Increment must be non-zero.");
        }
        this.mPosition = 0;
    }

    public boolean hasNext(int windowSize, int increment) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window size must be positive.");
        }
        try {
            if (increment > 0) {
                return windowSize == this.mBounds.suffix(this.mPosition).prefix(windowSize).length();
            }
            if (this.mPosition == 0) {
                return windowSize == this.mBounds.suffix(-windowSize).length();
            }
            return windowSize == this.mBounds.prefix(this.mPosition).suffix(-windowSize).length();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext(this.mWindowSize, this.mIncrement);
    }

    public Location remainder() {
        Location remainder = null;
        remainder = this.mPosition == 0 ? this.mBounds : (this.mIncrement > 0 ? this.mBounds.suffix(this.mPosition) : this.mBounds.prefix(this.mPosition));
        return remainder;
    }

    @Override
    public Location next() {
        return this.next(this.mWindowSize, this.mIncrement);
    }

    public Location next(int windowSize, int increment) {
        Location r;
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window size must be positive.");
        }
        if (increment == 0) {
            throw new IllegalArgumentException("Increment must be non-zero.");
        }
        try {
            r = increment > 0 ? this.mBounds.suffix(this.mPosition).prefix(windowSize) : (this.mPosition == 0 ? this.mBounds.suffix(-windowSize) : this.mBounds.prefix(this.mPosition).suffix(-windowSize));
            this.mPosition += increment;
        }
        catch (Exception e) {
            throw new IndexOutOfBoundsException(e.toString());
        }
        return r;
    }

    public String toString() {
        return "bounds=" + this.mBounds.toString() + "; pos=" + this.mPosition + "; winsize=" + this.mWindowSize + "; inc=" + this.mIncrement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        Location r = new Location(10, 21);
        log.info("10 to 21, 1 by 1");
        for (Location t : r.window(1, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by 3");
        for (Location t : r.window(3, 3)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by 1");
        for (Location t : r.window(3, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 11 by 1");
        for (Location t : r.window(11, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 12 by 1");
        for (Location t : r.window(12, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 1 by -1");
        for (Location t : r.window(1, -1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by -3");
        for (Location t : r.window(3, -3)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by -1");
        for (Location t : r.window(3, -1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 1 by 1");
        for (Location t : r.window(1, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by 3");
        for (Location t : r.window(3, 3)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by 1");
        for (Location t : r.window(3, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 11 by 1");
        for (Location t : r.window(11, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 12 by 1");
        for (Location t : r.window(12, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 1 by -1");
        for (Location t : r.window(1, -1)) {
            log.info(t.toString());
        }
        r = r.opposite();
        log.info("reverse strand");
        log.info("10 to 21, 1 by 1");
        for (Location t : r.window(1, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by 3");
        for (Location t : r.window(3, 3)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by 1");
        for (Location t : r.window(3, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 11 by 1");
        for (Location t : r.window(11, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 12 by 1");
        for (Location t : r.window(12, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 1 by -1");
        for (Location t : r.window(1, -1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by -3");
        for (Location t : r.window(3, -3)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by -1");
        for (Location t : r.window(3, -1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 1 by 1");
        for (Location t : r.window(1, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by 3");
        for (Location t : r.window(3, 3)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 3 by 1");
        for (Location t : r.window(3, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 11 by 1");
        for (Location t : r.window(11, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 12 by 1");
        for (Location t : r.window(12, 1)) {
            log.info(t.toString());
        }
        log.info("10 to 21, 1 by -1");
        for (Location t : r.window(1, -1)) {
            log.info(t.toString());
        }
        log.info("");
        log.info("10 to 21, 1 by 1 (+2)");
        LocIterator i = r.iterator();
        int chunk = 1;
        while (i.hasNext(1, chunk)) {
            Location t = i.next(1, chunk);
            log.info(t.toString());
            chunk += 2;
        }
        log.info("JavaGene.LocIterator Passed.");
    }
}

