/*
 * Decompiled with CFR 0.152.
 */
import it.polito.NGS.GenomeProvider;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class GetGenomeSequence {
    public static void main(String[] args) {
        block21: {
            Options options = new Options();
            Option gen = new Option("g", "genome-file", true, "Genome file");
            Option userHelp = new Option("h", "help", false, "Print this help message");
            Option type = new Option("t", "type", true, "Flag (F)usion or single (S)equence");
            Option seq1chr = new Option("s1chr", "sequence-1-chr", true, "Sequence 1 chr");
            Option seq1start = new Option("s1start", "sequence-1-start", true, "Sequence 1 start");
            Option seq1end = new Option("s1end", "sequence-1-end", true, "Sequence 1 end");
            Option seq1strand = new Option("s1strand", "sequence-1-strand", true, "Sequence 1 strend");
            Option seq2chr = new Option("s2chr", "sequence-2-chr", true, "Sequence 2 chr");
            Option seq2start = new Option("s2start", "sequence-2-start", true, "Sequence 2 start");
            Option seq2end = new Option("s2end", "sequence-2-end", true, "Sequence 2 end");
            Option seq2strand = new Option("s2strand", "sequence-2-strand", true, "Sequence 2 strend");
            gen.setRequired(true);
            type.setRequired(true);
            options.addOption(gen);
            options.addOption(userHelp);
            options.addOption(type);
            options.addOption(seq1chr);
            options.addOption(seq1start);
            options.addOption(seq1end);
            options.addOption(seq1strand);
            options.addOption(seq2chr);
            options.addOption(seq2start);
            options.addOption(seq2end);
            options.addOption(seq2strand);
            PosixParser parser = new PosixParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
                if (cmd.hasOption("h")) {
                    throw new ParseException("");
                }
                if (cmd.hasOption("g") && !new File(cmd.getOptionValue("g")).exists()) {
                    throw new ParseException("Reference file: \"" + cmd.getOptionValue("g") + "\" does not exist");
                }
                if (!cmd.hasOption("t")) {
                    throw new ParseException("You have to chose if sequence S or fusion F");
                }
                if (!cmd.hasOption("s1chr")) {
                    throw new ParseException("You have to write sequence 1 chromosome");
                }
                if (!cmd.hasOption("s1start")) {
                    throw new ParseException("You have to write sequence 1 start");
                }
                if (!cmd.hasOption("s1end")) {
                    throw new ParseException("You have to write sequence 1 end");
                }
                if (!cmd.hasOption("s1strand")) {
                    throw new ParseException("You have to write sequence 1 strand");
                }
                if (!(!cmd.getOptionValue("t").equals("F") || cmd.hasOption("s2chr") && cmd.hasOption("s2start") && cmd.hasOption("s2end") && cmd.hasOption("s2strand"))) {
                    throw new ParseException("Some sequence 2 data is missing");
                }
            }
            catch (Exception e) {
                if (!e.getMessage().equals("")) {
                    System.out.println(e.getMessage());
                }
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("GetGenomeSequence", options);
                System.exit(-1);
            }
            String genomePath = cmd.getOptionValue("g");
            String typeValue = cmd.getOptionValue("t");
            String s1chr = cmd.getOptionValue("s1chr");
            String s1start = cmd.getOptionValue("s1start");
            String s1end = cmd.getOptionValue("s1end");
            String s1strand = cmd.getOptionValue("s1strand");
            String s2chr = cmd.getOptionValue("s2chr");
            String s2start = cmd.getOptionValue("s2start");
            String s2end = cmd.getOptionValue("s2end");
            String s2strand = cmd.getOptionValue("s2strand");
            GenomeProvider mygenome = null;
            try {
                mygenome = new GenomeProvider(genomePath, String.valueOf(genomePath) + ".fai");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            try {
                if (typeValue.equals("S")) {
                    String chr1 = s1chr;
                    int start1 = Integer.parseInt(s1start);
                    int end1 = Integer.parseInt(s1end);
                    boolean strand1 = Boolean.parseBoolean(s1strand);
                    if (end1 < start1) {
                        throw new Exception("s1end must be greater than s1start ");
                    }
                    System.out.println(mygenome.getBases(chr1, start1, end1, strand1));
                    break block21;
                }
                if (typeValue.equals("F")) {
                    String chr1 = s1chr;
                    int start1 = Integer.parseInt(s1start);
                    int end1 = Integer.parseInt(s1end);
                    boolean strand1 = Boolean.parseBoolean(s1strand);
                    if (end1 < start1) {
                        throw new Exception("s1end must be greater than s1start ");
                    }
                    String chr2 = s2chr;
                    int start2 = Integer.parseInt(s2start);
                    int end2 = Integer.parseInt(s2end);
                    boolean strand2 = Boolean.parseBoolean(s2strand);
                    if (end2 < start2) {
                        throw new Exception("s2end must be greater than s2start ");
                    }
                    System.out.println(String.valueOf(mygenome.getBases(chr1, start1, end1, strand1)) + "|" + mygenome.getBases(chr2, start2, end2, strand2));
                    break block21;
                }
                throw new Exception("Type Argument must be 'S' (Sequence) 'F' (Fusion)");
            }
            catch (Exception e) {
                if (!e.getMessage().equals("")) {
                    System.out.println(e.getMessage());
                }
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("GetGenomeSequence", options);
                System.exit(-1);
            }
        }
    }
}

