/*
 * Decompiled with CFR 0.152.
 */
package it.polito.NGS;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javagene.io.Gff;
import javagene.seq.FeatureI;
import javagene.seq.FeatureList;
import javagene.seq.Location;
import net.sf.samtools.SAMRecord;

public class GTFInterface2
extends Thread {
    private Map<String, List<Location>> transcritti = new HashMap<String, List<Location>>();
    private FeatureList gtffeatures;

    public GTFInterface2(String gtfpath) throws Exception {
        this.gtffeatures = Gff.read((String)gtfpath);
    }

    public String getRefByTranscriptID(String transcriptID) {
        FeatureList fl = this.gtffeatures.selectByAttribute("transcript_id", transcriptID);
        Iterator fl_i = fl.iterator();
        if (fl_i.hasNext()) {
            return ((FeatureI)fl_i.next()).seqname();
        }
        return null;
    }

    public Vector<Location> getLocationListByTranscriptId(String geneid) {
        FeatureList fl = this.gtffeatures.selectByAttribute("transcript_id", geneid);
        Vector<Location> LocationList = new Vector<Location>();
        fl.sortByStart();
        Iterator fl_i = fl.iterator();
        while (fl_i.hasNext()) {
            Location temp_l = ((FeatureI)fl_i.next()).location();
            LocationList.add(temp_l);
        }
        if (((Location)LocationList.get(0)).isNegative()) {
            Vector<Location> LocationList_reversed = new Vector<Location>();
            int i = LocationList.size() - 1;
            while (i >= 0) {
                LocationList_reversed.add(LocationList.get(i));
                --i;
            }
            return LocationList_reversed;
        }
        return LocationList;
    }

    public FeatureList getGTF() {
        return this.gtffeatures;
    }

    public Location getGeneCordinatesbyId(String geneid) {
        FeatureList fl = this.gtffeatures.selectByAttribute("transcript_id", geneid);
        if (fl == null) {
            System.out.println("Fottuto");
        }
        Location gene = fl.bounds();
        Location coordinate = new Location(gene.bioStart(), gene.bioEnd());
        return coordinate;
    }

    public Location getGeneCordinatesbyName(String gene_name) {
        Location gene;
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_name", gene_name);
        if (fl == null) {
            System.out.println("Fottuto");
        }
        if ((gene = fl.bounds()) == null) {
            System.out.println("Fottuto *2");
        }
        Location coordinate = new Location(gene.bioStart(), gene.bioEnd());
        return coordinate;
    }

    public FeatureList getFeaturesByGeneName(String gname) {
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_name", gname);
        return fl;
    }

    public char getTranscriptStrand(String transcript_id) {
        FeatureList fl = this.gtffeatures.selectByAttribute("transcript_id", transcript_id);
        if (fl.size() == 0) {
            System.err.println("Wrong transcript_id: no feature returned");
        }
        boolean positive = false;
        boolean negative = false;
        for (FeatureI feature : fl) {
            Location loc = feature.location();
            String cl = feature.getAttribute("class_code");
            if (cl != null && (cl.equalsIgnoreCase("x") || cl.equalsIgnoreCase("s") || cl.equalsIgnoreCase("i"))) {
                if (loc.isNegative()) {
                    positive = true;
                    continue;
                }
                negative = true;
                continue;
            }
            if (loc.isNegative()) {
                negative = true;
                continue;
            }
            positive = true;
        }
        if (positive && !negative) {
            return '+';
        }
        if (!positive && negative) {
            return '-';
        }
        return '.';
    }

    public List<Location> getTranscriptLocations(String transcript_id) {
        FeatureList fl = this.gtffeatures.selectByAttribute("transcript_id", transcript_id);
        if (fl.size() == 0) {
            System.err.println("Wrong transcript_id: no feature returned");
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        for (FeatureI f : fl) {
            Location l = f.location();
            if (l.bioStrand() == '-') {
                l = l.opposite();
            }
            locations.add(l);
        }
        return locations;
    }

    public Vector<String> getTranscriptListByGeneName(String gname) {
        String[] names = gname.split(",");
        Vector<String> col = new Vector<String>();
        String tmp = "";
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            FeatureList fl = this.gtffeatures.selectByAttribute("gene_name", name);
            for (FeatureI f : fl) {
                tmp = f.getAttribute("transcript_id");
                if (col.contains(tmp)) continue;
                col.add(tmp);
            }
            ++n2;
        }
        return col;
    }

    public Vector<String> getGeneIdByLocation(String ref, Location l) {
        Vector<String> geneIds = new Vector<String>();
        Collection col = new Vector();
        try {
            col = this.gtffeatures.selectOverlapping(ref, l, true).attributeValues("gene_id");
        }
        catch (ConcurrentModificationException c) {
            System.out.println("beccata1");
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("nada");
            System.exit(1);
        }
        try {
            geneIds = new Vector(col);
        }
        catch (ConcurrentModificationException c) {
            System.out.println("beccata2");
            System.exit(1);
        }
        return geneIds;
    }

    public Vector<String> getGeneNameByGeneId(String geneid) {
        Vector<String> geneNames = new Vector<String>();
        Collection col = new Vector();
        col = this.gtffeatures.selectByAttribute("gene_id", geneid).attributeValues("gene_name");
        geneNames = new Vector(col);
        return geneNames;
    }

    @Deprecated
    public Vector<String> getGeneNameAndCoordinatesByGeneId(String geneid) {
        Vector geneNames = new Vector();
        Vector<String> geneInfos = new Vector<String>();
        Collection col = new Vector();
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", geneid);
        for (FeatureI f : fl) {
            col = fl.attributeValues("gene_name");
            geneNames = new Vector(col);
            for (String genename : geneNames) {
                Location l = f.location();
                String geneinfo = String.valueOf(genename) + ":" + l.start() + ":" + l.end();
                geneInfos.add(geneinfo);
            }
        }
        return geneInfos;
    }

    public Vector<String> getReferenceNameByGeneId(String geneid) {
        Vector<String> geneReferences = new Vector<String>();
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", geneid);
        for (FeatureI f : fl) {
            if (geneReferences.isEmpty()) {
                geneReferences.add(f.seqname());
                continue;
            }
            Iterator<String> g_i = geneReferences.iterator();
            boolean found = false;
            while (g_i.hasNext() && !found) {
                String g = g_i.next();
                if (g.compareTo(f.seqname()) != 0) continue;
                found = true;
            }
            if (found) continue;
            geneReferences.add(f.seqname());
        }
        return geneReferences;
    }

    public Location getLocationByGeneId(String geneid) {
        Location temp_l;
        int start = 0;
        int end = 0;
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", geneid);
        Iterator fl_i = fl.iterator();
        if (fl_i.hasNext()) {
            temp_l = ((FeatureI)fl_i.next()).location();
            if (temp_l.isNegative()) {
                temp_l = temp_l.opposite();
            }
            start = temp_l.start();
            end = temp_l.end();
        }
        while (fl_i.hasNext()) {
            temp_l = ((FeatureI)fl_i.next()).location();
            if (temp_l.isNegative()) {
                temp_l = temp_l.opposite();
            }
            if (start > temp_l.start()) {
                start = temp_l.start();
            }
            if (end >= temp_l.end()) continue;
            end = temp_l.end();
        }
        return new Location(start, end);
    }

    public String getStrandbyName(String[] gene_names) {
        FeatureList fl = new FeatureList();
        String[] stringArray = gene_names;
        int n = gene_names.length;
        int n2 = 0;
        while (n2 < n) {
            String gene_name = stringArray[n2];
            fl.addAll((Collection)this.gtffeatures.selectByAttribute("gene_name", gene_name));
            ++n2;
        }
        int negative = 0;
        int positive = 0;
        for (FeatureI feature : fl) {
            Location loc = feature.location();
            String cl = feature.getAttribute("class_code");
            if (loc.length() == 0) continue;
            if (cl != null && (cl.equalsIgnoreCase("x") || cl.equalsIgnoreCase("s") || cl.equalsIgnoreCase("i"))) {
                if (loc.isNegative()) {
                    positive += loc.length();
                    continue;
                }
                negative += loc.length();
                continue;
            }
            if (loc.isNegative()) {
                negative += loc.length();
                continue;
            }
            positive += loc.length();
        }
        if (positive > negative) {
            return "+";
        }
        if (negative > positive) {
            return "-";
        }
        return ".";
    }

    public char CheckGeneIDLocationStrand(String geneid) {
        FeatureList fl = this.gtffeatures.selectByAttribute("gene_id", geneid);
        boolean positive = false;
        boolean negative = false;
        Iterator fl_i = fl.iterator();
        while (fl_i.hasNext()) {
            Location temp_l = ((FeatureI)fl_i.next()).location();
            if (temp_l.length() == 0) continue;
            if (temp_l.bioStrand() == '-') {
                negative = true;
            }
            if (temp_l.bioStrand() != '+') continue;
            positive = true;
        }
        if (positive && !negative) {
            return '+';
        }
        if (!positive && negative) {
            return '-';
        }
        if (!positive && !negative) {
            return '.';
        }
        if (positive && negative) {
            return '.';
        }
        return '.';
    }

    public List<Location> getTrascriptLocations(String transcript_id) {
        List<Location> locs = this.transcritti.get(transcript_id);
        if (locs == null) {
            locs = this.getTranscriptLocations(transcript_id);
            this.transcritti.put(transcript_id, locs);
        }
        return locs;
    }

    public boolean samRecordisinTranscript(SAMRecord record, String transcript_id) {
        List<Location> locs = this.getTranscriptLocations(transcript_id);
        int start = record.getAlignmentStart();
        int end = record.getAlignmentEnd();
        for (Location loc : locs) {
            if (start > loc.end() || end < loc.start()) continue;
            return true;
        }
        return false;
    }
}

