/*
 * Decompiled with CFR 0.152.
 */
package it.polito.bellerophontes.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.picard.fastq.FastqReader;
import net.sf.picard.fastq.FastqRecord;

public class FastqConverter {
    public static void FastqToFasta(String FastqFileName, String fastaFileName) throws IOException {
        BufferedWriter fastaWriter = new BufferedWriter(new FileWriter(new File(fastaFileName)));
        FastqConverter.FastqToFasta(FastqFileName, fastaWriter);
        fastaWriter.flush();
        fastaWriter.close();
    }

    public static void FastqToFasta(String FastqFileName, BufferedWriter FastaWriter2) throws IOException {
        File input = new File(FastqFileName);
        if (!input.exists()) {
            throw new IOException("File " + FastqFileName + " does not exist");
        }
        FastqReader fr = new FastqReader(input);
        while (fr.hasNext()) {
            FastqRecord record = fr.next();
            FastaWriter2.write(">" + record.getReadHeader() + "\n" + record.getReadString() + "\n");
        }
    }

    public static Collection<File> FastqtoFastas(String fastqfilename, int maxdim) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        File input = new File(fastqfilename);
        if (!input.exists()) {
            throw new IOException("File " + fastqfilename + " does not exist");
        }
        FastqReader fr = new FastqReader(input);
        File tmpFile = File.createTempFile("unmapped_", ".fasta", new File(System.getProperty("user.dir")));
        tmpFile.deleteOnExit();
        BufferedWriter filewriter = new BufferedWriter(new FileWriter(tmpFile));
        result.add(tmpFile);
        int current = 0;
        while (fr.hasNext()) {
            if (current >= maxdim) {
                filewriter.flush();
                filewriter.close();
                tmpFile = File.createTempFile("unmapped_", ".fasta", new File(System.getProperty("user.dir")));
                tmpFile.deleteOnExit();
                result.add(tmpFile);
                filewriter = new BufferedWriter(new FileWriter(tmpFile));
                current = 0;
            }
            FastqRecord record = fr.next();
            filewriter.write(">" + record.getReadHeader() + "\n" + record.getReadString() + "\n");
            ++current;
        }
        filewriter.flush();
        filewriter.close();
        return result;
    }

    public static void main(String[] argv) throws IOException {
        FastqConverter.FastqToFasta(argv[0], argv[1]);
    }
}

