/*
 * Decompiled with CFR 0.152.
 */
package it.polito.bellerophontes.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

class GenericBinaryFileBuffer<T> {
    public static int BUFFERSIZE = 2048;
    public File originalfile;
    ObjectInputStream ois;
    private T cache;
    private boolean empty;

    public GenericBinaryFileBuffer(File f) throws IOException {
        this.originalfile = f;
        this.ois = new ObjectInputStream(new FileInputStream(f));
        this.reload();
    }

    public boolean empty() {
        return this.empty;
    }

    private void reload() throws IOException {
        try {
            this.cache = this.ois.readObject();
            if (this.cache == null) {
                this.empty = true;
                this.cache = null;
            } else {
                this.empty = false;
            }
        }
        catch (EOFException oef) {
            this.empty = true;
            this.cache = null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        this.ois.close();
    }

    public T peek() {
        if (this.empty()) {
            return null;
        }
        return this.cache;
    }

    public T pop() throws IOException {
        T answer = this.peek();
        this.reload();
        return answer;
    }
}

