/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.InsertSizeMetrics;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Log;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;

public class CollectInsertSizeMetrics
extends SinglePassSamProgram {
    private static final Log log = Log.getInstance(CollectInsertSizeMetrics.class);
    private static final String HISTOGRAM_R_SCRIPT = "net/sf/picard/analysis/insertSizeHistogram.R";
    @Usage
    public String USAGE = "Reads a SAM or BAM file and writes a file containing metrics about the statistical distribution of insert size (excluding duplicates) and generates a histogram plot.\n";
    @Option(shortName="H", doc="File to write insert size histogram chart to")
    public File HISTOGRAM_FILE;
    @Option(doc="Generate mean, sd and plots by trimming the data down to MEDIAN + DEVIATIONS*MEDIAN_ABSOLUTE_DEVIATION. This is done because insert size data typically includes enough anomolous values from chimeras and other artifacts to make the mean and sd grossly misleading regarding the real distribution.")
    public double DEVIATIONS = 10.0;
    @Option(shortName="W", doc="Explicitly sets the histogram width, overriding automatic truncation of histogram tail. Also, when calculating mean and stdev, only bins <= HISTOGRAM_WIDTH will be included.", optional=true)
    public Integer HISTOGRAM_WIDTH = null;
    @Option(shortName="M", doc="When generating the histogram, discard any data categories (out of FR, TANDEM, RF) that have fewer than this percentage of overall reads. (Range: 0 to 1)")
    public float MINIMUM_PCT = 0.05f;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    private boolean calculateAll = false;
    private boolean calculateSample = false;
    private boolean calculateLibrary = false;
    private boolean calculateReadGroup = false;
    final InsertSizeMetricsCollector allReadsCollector = new InsertSizeMetricsCollector(null, null, null);
    final Map<String, InsertSizeMetricsCollector> sampleCollectors = new HashMap<String, InsertSizeMetricsCollector>();
    final Map<String, InsertSizeMetricsCollector> libraryCollectors = new HashMap<String, InsertSizeMetricsCollector>();
    final Map<String, InsertSizeMetricsCollector> readGroupCollectors = new HashMap<String, InsertSizeMetricsCollector>();

    public static void main(String[] argv) {
        new CollectInsertSizeMetrics().instanceMainWithExit(argv);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.MINIMUM_PCT < 0.0f || (double)this.MINIMUM_PCT > 0.5) {
            return new String[]{"MINIMUM_PCT was set to " + this.MINIMUM_PCT + ". It must be between 0 and 0.5 so all data categories don't get discarded."};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected boolean usesNoRefReads() {
        return false;
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.HISTOGRAM_FILE);
        this.calculateAll = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.ALL_READS);
        this.calculateSample = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.SAMPLE);
        this.calculateLibrary = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.LIBRARY);
        this.calculateReadGroup = this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.READ_GROUP);
        for (SAMReadGroupRecord rg : header.getReadGroups()) {
            if (this.calculateSample && !this.sampleCollectors.containsKey(rg.getSample())) {
                this.sampleCollectors.put(rg.getSample(), new InsertSizeMetricsCollector(rg.getSample(), null, null));
            }
            if (this.calculateLibrary && !this.libraryCollectors.containsKey(rg.getLibrary())) {
                this.libraryCollectors.put(rg.getLibrary(), new InsertSizeMetricsCollector(rg.getSample(), rg.getLibrary(), null));
            }
            if (!this.calculateReadGroup || this.readGroupCollectors.containsKey(rg.getPlatformUnit())) continue;
            this.readGroupCollectors.put(rg.getPlatformUnit(), new InsertSizeMetricsCollector(rg.getSample(), rg.getLibrary(), rg.getPlatformUnit()));
        }
    }

    @Override
    protected void acceptRead(SAMRecord record, ReferenceSequence ref) {
        if (!record.getReadPairedFlag() || record.getReadUnmappedFlag() || record.getMateUnmappedFlag() || record.getFirstOfPairFlag() || record.getNotPrimaryAlignmentFlag() || record.getDuplicateReadFlag() || record.getInferredInsertSize() == 0) {
            return;
        }
        int insertSize = Math.abs(record.getInferredInsertSize());
        SamPairUtil.PairOrientation orientation = SamPairUtil.getPairOrientation(record);
        SAMReadGroupRecord rg = record.getReadGroup();
        if (this.calculateAll) {
            this.allReadsCollector.updateHistogram(orientation, insertSize);
        }
        if (this.calculateSample) {
            this.sampleCollectors.get(rg.getSample()).updateHistogram(orientation, insertSize);
        }
        if (this.calculateLibrary) {
            this.libraryCollectors.get(rg.getLibrary()).updateHistogram(orientation, insertSize);
        }
        if (this.calculateReadGroup) {
            this.readGroupCollectors.get(rg.getPlatformUnit()).updateHistogram(orientation, insertSize);
        }
    }

    @Override
    protected void finish() {
        MetricsFile<InsertSizeMetrics, Integer> file = this.getMetricsFile();
        if (this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.ALL_READS)) {
            this.allReadsCollector.addMetricsToFile(file);
        }
        if (this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.SAMPLE)) {
            for (InsertSizeMetricsCollector collector : this.sampleCollectors.values()) {
                collector.addMetricsToFile(file);
            }
        }
        if (this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.LIBRARY)) {
            for (InsertSizeMetricsCollector collector : this.libraryCollectors.values()) {
                collector.addMetricsToFile(file);
            }
        }
        if (this.METRIC_ACCUMULATION_LEVEL.contains((Object)MetricAccumulationLevel.READ_GROUP)) {
            for (InsertSizeMetricsCollector collector : this.readGroupCollectors.values()) {
                collector.addMetricsToFile(file);
            }
        }
        if (file.getNumHistograms() == 0) {
            log.warn("All data categories were discarded because they contained < " + this.MINIMUM_PCT + " of the total aligned paired data.");
            log.warn("Total mapped pairs in all categories: " + this.allReadsCollector.totalInserts);
        } else {
            file.write(this.OUTPUT);
            int rResult = this.HISTOGRAM_WIDTH == null ? RExecutor.executeFromClasspath(HISTOGRAM_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.HISTOGRAM_FILE.getAbsolutePath(), this.INPUT.getName()) : RExecutor.executeFromClasspath(HISTOGRAM_R_SCRIPT, this.OUTPUT.getAbsolutePath(), this.HISTOGRAM_FILE.getAbsolutePath(), this.INPUT.getName(), String.valueOf(this.HISTOGRAM_WIDTH));
            if (rResult != 0) {
                throw new PicardException("R script net/sf/picard/analysis/insertSizeHistogram.R failed with return code " + rResult);
            }
        }
    }

    private class InsertSizeMetricsCollector {
        final EnumMap<SamPairUtil.PairOrientation, Histogram<Integer>> histograms = new EnumMap(SamPairUtil.PairOrientation.class);
        final String sample;
        final String library;
        final String readGroup;
        double totalInserts = 0.0;

        public InsertSizeMetricsCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
            String prefix = null;
            prefix = this.readGroup != null ? String.valueOf(this.readGroup) + "." : (this.library != null ? String.valueOf(this.library) + "." : (this.sample != null ? String.valueOf(this.sample) + "." : "All_Reads."));
            this.histograms.put(SamPairUtil.PairOrientation.FR, new Histogram("insert_size", String.valueOf(prefix) + "fr_count"));
            this.histograms.put(SamPairUtil.PairOrientation.TANDEM, new Histogram("insert_size", String.valueOf(prefix) + "tandem_count"));
            this.histograms.put(SamPairUtil.PairOrientation.RF, new Histogram("insert_size", String.valueOf(prefix) + "rf_count"));
        }

        public void updateHistogram(SamPairUtil.PairOrientation orientation, int insertSize) {
            this.histograms.get((Object)orientation).increment(insertSize);
        }

        public void addMetricsToFile(MetricsFile<InsertSizeMetrics, Integer> file) {
            for (Histogram<Integer> histogram : this.histograms.values()) {
                this.totalInserts += histogram.getCount();
            }
            for (Map.Entry entry : this.histograms.entrySet()) {
                SamPairUtil.PairOrientation pairOrientation = (SamPairUtil.PairOrientation)((Object)entry.getKey());
                Histogram histogram = (Histogram)entry.getValue();
                double total = histogram.getCount();
                if (!(total > this.totalInserts * (double)CollectInsertSizeMetrics.this.MINIMUM_PCT)) continue;
                InsertSizeMetrics metrics = new InsertSizeMetrics();
                metrics.SAMPLE = this.sample;
                metrics.LIBRARY = this.library;
                metrics.READ_GROUP = this.readGroup;
                metrics.PAIR_ORIENTATION = pairOrientation;
                metrics.READ_PAIRS = (long)total;
                metrics.MAX_INSERT_SIZE = (int)histogram.getMax();
                metrics.MIN_INSERT_SIZE = (int)histogram.getMin();
                metrics.MEDIAN_INSERT_SIZE = histogram.getMedian();
                metrics.MEDIAN_ABSOLUTE_DEVIATION = histogram.getMedianAbsoluteDeviation();
                double median = histogram.getMedian();
                double covered = 0.0;
                double low = median;
                double high = median;
                while (low >= histogram.getMin() || high <= histogram.getMax()) {
                    Histogram.Bin highBin;
                    Histogram.Bin lowBin = (Histogram.Bin)histogram.get((int)low);
                    if (lowBin != null) {
                        covered += lowBin.getValue();
                    }
                    if (low != high && (highBin = (Histogram.Bin)histogram.get((int)high)) != null) {
                        covered += highBin.getValue();
                    }
                    double percentCovered = covered / total;
                    int distance = (int)(high - low) + 1;
                    if (percentCovered >= 0.1 && metrics.WIDTH_OF_10_PERCENT == 0) {
                        metrics.WIDTH_OF_10_PERCENT = distance;
                    }
                    if (percentCovered >= 0.2 && metrics.WIDTH_OF_20_PERCENT == 0) {
                        metrics.WIDTH_OF_20_PERCENT = distance;
                    }
                    if (percentCovered >= 0.3 && metrics.WIDTH_OF_30_PERCENT == 0) {
                        metrics.WIDTH_OF_30_PERCENT = distance;
                    }
                    if (percentCovered >= 0.4 && metrics.WIDTH_OF_40_PERCENT == 0) {
                        metrics.WIDTH_OF_40_PERCENT = distance;
                    }
                    if (percentCovered >= 0.5 && metrics.WIDTH_OF_50_PERCENT == 0) {
                        metrics.WIDTH_OF_50_PERCENT = distance;
                    }
                    if (percentCovered >= 0.6 && metrics.WIDTH_OF_60_PERCENT == 0) {
                        metrics.WIDTH_OF_60_PERCENT = distance;
                    }
                    if (percentCovered >= 0.7 && metrics.WIDTH_OF_70_PERCENT == 0) {
                        metrics.WIDTH_OF_70_PERCENT = distance;
                    }
                    if (percentCovered >= 0.8 && metrics.WIDTH_OF_80_PERCENT == 0) {
                        metrics.WIDTH_OF_80_PERCENT = distance;
                    }
                    if (percentCovered >= 0.9 && metrics.WIDTH_OF_90_PERCENT == 0) {
                        metrics.WIDTH_OF_90_PERCENT = distance;
                    }
                    if (percentCovered >= 0.99 && metrics.WIDTH_OF_99_PERCENT == 0) {
                        metrics.WIDTH_OF_99_PERCENT = distance;
                    }
                    low -= 1.0;
                    high += 1.0;
                }
                Histogram trimmedHisto = histogram;
                if (CollectInsertSizeMetrics.this.HISTOGRAM_WIDTH == null) {
                    CollectInsertSizeMetrics.this.HISTOGRAM_WIDTH = (int)(metrics.MEDIAN_INSERT_SIZE + CollectInsertSizeMetrics.this.DEVIATIONS * metrics.MEDIAN_ABSOLUTE_DEVIATION);
                }
                trimmedHisto.trimByWidth(CollectInsertSizeMetrics.this.HISTOGRAM_WIDTH);
                metrics.MEAN_INSERT_SIZE = trimmedHisto.getMean();
                metrics.STANDARD_DEVIATION = trimmedHisto.getStandardDeviation();
                file.addHistogram(trimmedHisto);
                file.addMetric(metrics);
            }
        }
    }
}

