/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaData;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.samtools.util.CloserUtil;

abstract class PerTilePerCycleParser<ILLUMINA_DATA extends IlluminaData>
implements IlluminaParser<ILLUMINA_DATA> {
    private final File laneDirectory;
    private final int lane;
    private final List<CycleFileParser<ILLUMINA_DATA>> cycleFileParsers;
    protected final OutputMapping outputMapping;
    private int tileNumber;
    protected final CycleIlluminaFileMap tilesToCycleFiles;

    public PerTilePerCycleParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, OutputMapping outputMapping) {
        this.lane = lane;
        this.laneDirectory = new File(directory, "L00" + this.lane);
        this.tilesToCycleFiles = tilesToCycleFiles;
        this.tileNumber = (Integer)tilesToCycleFiles.firstKey();
        this.outputMapping = outputMapping;
        this.cycleFileParsers = new ArrayList<CycleFileParser<ILLUMINA_DATA>>(outputMapping.getTotalOutputCycles());
        this.seekToTile((Integer)tilesToCycleFiles.firstKey());
    }

    protected abstract ILLUMINA_DATA makeData(int[] var1);

    protected abstract CycleFileParser<ILLUMINA_DATA> makeCycleFileParser(File var1, int var2);

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        this.tileNumber = oneBasedTileNumber;
        CycleFilesIterator filesIterator = (CycleFilesIterator)this.tilesToCycleFiles.get(this.tileNumber);
        filesIterator.reset();
        CloserUtil.close(this.cycleFileParsers);
        this.cycleFileParsers.clear();
        int totalCycles = 0;
        while (filesIterator.hasNext()) {
            int nextCycle = filesIterator.getNextCycle();
            this.cycleFileParsers.add(this.makeCycleFileParser(filesIterator.next(), nextCycle));
            ++totalCycles;
        }
        if (totalCycles != this.outputMapping.getTotalOutputCycles()) {
            throw new PicardException("Number of cycle OUTPUT files found (" + totalCycles + ") does not equal the number expected (" + this.outputMapping.getTotalOutputCycles() + ")");
        }
    }

    @Override
    public ILLUMINA_DATA next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("IlluminaData is missing in lane " + this.lane + " at directory location " + this.laneDirectory.getAbsolutePath());
        }
        if (!this.cycleFileParsers.get(0).hasNext()) {
            this.seekToTile(this.tilesToCycleFiles.higherKey(this.tileNumber));
        }
        ILLUMINA_DATA data = this.makeData(this.outputMapping.getOutputReadLengths());
        int i = 0;
        while (i < this.outputMapping.getTotalOutputCycles()) {
            this.cycleFileParsers.get(i).next(data);
            ++i;
        }
        return data;
    }

    @Override
    public boolean hasNext() {
        if (this.cycleFileParsers.get(0).hasNext()) {
            return true;
        }
        return this.tileNumber < (Integer)this.tilesToCycleFiles.lastKey();
    }

    @Override
    public int getTileOfNextCluster() {
        if (this.cycleFileParsers.get(0).hasNext()) {
            return this.tileNumber;
        }
        if (this.tileNumber < (Integer)this.tilesToCycleFiles.lastKey()) {
            return this.tilesToCycleFiles.higherKey(this.tileNumber);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void verifyData(List<Integer> tiles, int[] cycles) {
        if (tiles == null) {
            tiles = new ArrayList(this.tilesToCycleFiles.keySet());
        }
        this.tilesToCycleFiles.assertValid(tiles, cycles);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + this.getClass().getName());
    }

    protected static interface CycleFileParser<ILLUMINA_DATA> {
        public void close();

        public void next(ILLUMINA_DATA var1);

        public boolean hasNext();
    }
}

