/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.BaseData;
import net.sf.picard.illumina.parser.PfData;
import net.sf.picard.illumina.parser.PositionalData;
import net.sf.picard.illumina.parser.QualityData;

class QseqReadData
implements PositionalData,
BaseData,
QualityData,
PfData {
    private final byte[][] bases;
    private final byte[][] qualities;
    private Boolean pf;
    private Integer xCoord;
    private Integer yCoord;
    private Integer lane;
    private Integer tile;

    public QseqReadData(int[] bufferSizes) {
        this.bases = new byte[bufferSizes.length][];
        this.qualities = new byte[bufferSizes.length][];
        int i = 0;
        while (i < bufferSizes.length) {
            this.bases[i] = new byte[bufferSizes[i]];
            this.qualities[i] = new byte[bufferSizes[i]];
            ++i;
        }
        this.pf = null;
        this.xCoord = null;
        this.yCoord = null;
        this.lane = null;
        this.tile = null;
    }

    @Override
    public byte[][] getBases() {
        return this.bases;
    }

    @Override
    public byte[][] getQualities() {
        return this.qualities;
    }

    public void setOrCheckPf(boolean pf) {
        if (this.pf == null) {
            this.pf = pf;
        } else {
            this.assertEquals(this.pf, pf, "pf");
        }
    }

    @Override
    public boolean isPf() {
        return this.pf;
    }

    @Override
    public int getXCoordinate() {
        return this.xCoord;
    }

    public void setOrCheckXCoordinate(int xCoord) {
        if (this.xCoord == null) {
            this.xCoord = xCoord;
        } else {
            this.assertEquals(this.xCoord, xCoord, "xCoord");
        }
    }

    @Override
    public int getYCoordinate() {
        return this.yCoord;
    }

    public void setOrCheckYCoordinate(int yCoord) {
        if (this.yCoord == null) {
            this.yCoord = yCoord;
        } else {
            this.assertEquals(this.yCoord, yCoord, "yCoord");
        }
    }

    public int getLane() {
        return this.lane;
    }

    public void setOrCheckLane(int lane) {
        if (this.lane == null) {
            this.lane = lane;
        } else {
            this.assertEquals(this.lane, lane, "lane");
        }
    }

    public int getTile() {
        return this.tile;
    }

    public void setOrCheckTile(int tile) {
        if (this.tile == null) {
            this.tile = tile;
        } else {
            this.assertEquals(this.tile, tile, "tile");
        }
    }

    public <T> void assertEquals(T current, T newValue, String valueName) {
        if (!current.equals(newValue)) {
            throw new PicardException(String.valueOf(valueName) + " values don't match: original(" + current + ") new(" + newValue + ")");
        }
    }
}

