/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.metrics.Header;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.Histogram;
import net.sf.samtools.util.StringUtil;

public class MetricsFile<BEAN extends MetricBase, HKEY extends Comparable> {
    public static final String MAJOR_HEADER_PREFIX = "## ";
    public static final String MINOR_HEADER_PREFIX = "# ";
    public static final String SEPARATOR = "\t";
    public static final String HISTO_HEADER = "## HISTOGRAM\t";
    public static final String METRIC_HEADER = "## METRICS CLASS\t";
    private final Set<String> columnLabels = new HashSet<String>();
    private final List<Header> headers = new ArrayList<Header>();
    private final List<BEAN> metrics = new ArrayList<BEAN>();
    private final List<Histogram<HKEY>> histograms = new ArrayList<Histogram<HKEY>>();

    public void addHeader(Header h) {
        this.headers.add(h);
    }

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addMetric(BEAN bean) {
        this.metrics.add(bean);
    }

    public List<BEAN> getMetrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    public Set<String> getMetricsColumnLabels() {
        return Collections.unmodifiableSet(this.columnLabels);
    }

    public Histogram<HKEY> getHistogram() {
        if (this.histograms.size() > 0) {
            return this.histograms.get(0);
        }
        return null;
    }

    public void setHistogram(Histogram<HKEY> histogram) {
        if (this.histograms.isEmpty()) {
            if (histogram != null) {
                this.histograms.add(histogram);
            }
        } else {
            this.histograms.set(0, histogram);
        }
    }

    public void addHistogram(Histogram<HKEY> histogram) {
        this.histograms.add(histogram);
    }

    public List<Histogram<HKEY>> getAllHistograms() {
        return Collections.unmodifiableList(this.histograms);
    }

    public int getNumHistograms() {
        return this.histograms.size();
    }

    public List<Header> getHeaders(Class<? extends Header> type) {
        ArrayList<Header> tmp = new ArrayList<Header>();
        for (Header h : this.headers) {
            if (!h.getClass().equals(type)) continue;
            tmp.add(h);
        }
        return tmp;
    }

    public void write(File f) {
        FileWriter w = null;
        try {
            try {
                w = new FileWriter(f);
                this.write(w);
            }
            catch (IOException ioe) {
                throw new PicardException("Could not write metrics to file: " + f.getAbsolutePath(), ioe);
            }
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void write(Writer w) {
        try {
            FormatUtil formatter = new FormatUtil();
            BufferedWriter out = new BufferedWriter(w);
            this.printHeaders(out);
            out.newLine();
            this.printBeanMetrics(out, formatter);
            out.newLine();
            this.printHistogram(out, formatter);
            out.newLine();
            out.flush();
        }
        catch (IOException ioe) {
            throw new PicardException("Could not write metrics file.", ioe);
        }
    }

    private void printHeaders(BufferedWriter out) throws IOException {
        for (Header h : this.headers) {
            out.append(MAJOR_HEADER_PREFIX);
            out.append(h.getClass().getName());
            out.newLine();
            out.append(MINOR_HEADER_PREFIX);
            out.append(h.toString());
            out.newLine();
        }
    }

    private void printBeanMetrics(BufferedWriter out, FormatUtil formatter) throws IOException {
        if (this.metrics.isEmpty()) {
            return;
        }
        out.append(METRIC_HEADER + this.getBeanType().getName());
        out.newLine();
        Field[] fields = this.getBeanType().getFields();
        int fieldCount = fields.length;
        int i = 0;
        while (i < fieldCount) {
            out.append(fields[i].getName());
            if (i < fieldCount - 1) {
                out.append(SEPARATOR);
            } else {
                out.newLine();
            }
            ++i;
        }
        for (MetricBase bean : this.metrics) {
            int i2 = 0;
            while (i2 < fieldCount) {
                try {
                    Object value = fields[i2].get(bean);
                    out.append(StringUtil.assertCharactersNotInString(formatter.format(value), '\t', '\n'));
                    if (i2 < fieldCount - 1) {
                        out.append(SEPARATOR);
                    } else {
                        out.newLine();
                    }
                }
                catch (IllegalAccessException iae) {
                    throw new PicardException("Could not read property " + fields[i2].getName() + " from class of type " + bean.getClass());
                }
                ++i2;
            }
        }
        out.flush();
    }

    private void printHistogram(BufferedWriter out, FormatUtil formatter) throws IOException {
        ArrayList<Histogram<HKEY>> nonEmptyHistograms = new ArrayList<Histogram<HKEY>>();
        for (Histogram<HKEY> histo : this.histograms) {
            if (histo.isEmpty()) continue;
            nonEmptyHistograms.add(histo);
        }
        if (nonEmptyHistograms.isEmpty()) {
            return;
        }
        TreeSet keys = new TreeSet(((Histogram)nonEmptyHistograms.get(0)).comparator());
        for (Histogram histogram : nonEmptyHistograms) {
            if (histogram == null) continue;
            keys.addAll(histogram.keySet());
        }
        out.append(HISTO_HEADER + ((Comparable)((Histogram)nonEmptyHistograms.get(0)).keySet().iterator().next()).getClass().getName());
        out.newLine();
        out.append(StringUtil.assertCharactersNotInString(((Histogram)nonEmptyHistograms.get(0)).getBinLabel(), '\t', '\n'));
        for (Histogram histogram : nonEmptyHistograms) {
            out.append(SEPARATOR);
            out.append(StringUtil.assertCharactersNotInString(histogram.getValueLabel(), '\t', '\n'));
        }
        out.newLine();
        for (Comparable comparable : keys) {
            out.append(comparable.toString());
            for (Histogram histogram : nonEmptyHistograms) {
                Histogram.Bin bin = (Histogram.Bin)histogram.get(comparable);
                double value = bin == null ? 0.0 : bin.getValue();
                out.append(SEPARATOR);
                out.append(formatter.format(value));
            }
            out.newLine();
        }
    }

    private Class<?> getBeanType() {
        if (this.metrics == null || this.metrics.isEmpty()) {
            return null;
        }
        return ((MetricBase)this.metrics.get(0)).getClass();
    }

    public void read(Reader r) {
        block30: {
            BufferedReader in = new BufferedReader(r);
            FormatUtil formatter = new FormatUtil();
            String line = null;
            try {
                String className;
                Header header = null;
                boolean inHeader = true;
                while ((line = in.readLine()) != null && inHeader) {
                    if ("".equals(line = line.trim())) {
                        inHeader = false;
                        continue;
                    }
                    if (line.startsWith(MAJOR_HEADER_PREFIX)) {
                        if (header != null) {
                            throw new IllegalStateException("Consecutive header class lines encountered.");
                        }
                        className = line.substring(MAJOR_HEADER_PREFIX.length()).trim();
                        try {
                            header = (Header)this.loadClass(className, true).newInstance();
                            continue;
                        }
                        catch (Exception e) {
                            throw new PicardException("Error load and/or instantiating an instance of " + className, e);
                        }
                    }
                    if (line.startsWith(MINOR_HEADER_PREFIX)) {
                        if (header == null) {
                            throw new IllegalStateException("Header class must precede header value:" + line);
                        }
                        header.parse(line.substring(MINOR_HEADER_PREFIX.length()));
                        this.headers.add(header);
                        header = null;
                        continue;
                    }
                    throw new PicardException("Illegal state. Found following string in metrics file header: " + line);
                }
                while (line != null && !line.startsWith(MAJOR_HEADER_PREFIX)) {
                    line = in.readLine();
                }
                if (line != null && (line = line.trim()).startsWith(METRIC_HEADER)) {
                    className = line.split(SEPARATOR)[1];
                    Class<?> type = null;
                    try {
                        type = this.loadClass(className, true);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new PicardException("Could not locate class with name " + className, cnfe);
                    }
                    String[] fieldNames = in.readLine().split(SEPARATOR);
                    Collections.addAll(this.columnLabels, fieldNames);
                    Field[] fields = new Field[fieldNames.length];
                    int i = 0;
                    while (i < fieldNames.length) {
                        try {
                            fields[i] = type.getField(fieldNames[i]);
                        }
                        catch (Exception e) {
                            throw new PicardException("Could not get field with name " + fieldNames[i] + " from class " + type.getName());
                        }
                        ++i;
                    }
                    while ((line = in.readLine()) != null) {
                        if ("".equals(line.trim())) break;
                        String[] values = line.split(SEPARATOR, -1);
                        MetricBase bean = null;
                        try {
                            bean = (MetricBase)type.newInstance();
                        }
                        catch (Exception e) {
                            throw new PicardException("Error instantiating a " + type.getName(), e);
                        }
                        int i2 = 0;
                        while (i2 < fields.length) {
                            Object value = null;
                            if (values[i2] != null && values[i2].length() > 0) {
                                value = formatter.parseObject(values[i2], fields[i2].getType());
                            }
                            try {
                                fields[i2].set(bean, value);
                            }
                            catch (Exception e) {
                                throw new PicardException("Error setting field " + fields[i2].getName() + " on class of type " + type.getName(), e);
                            }
                            ++i2;
                        }
                        this.metrics.add(bean);
                    }
                }
                while (line != null && !line.startsWith(MAJOR_HEADER_PREFIX)) {
                    line = in.readLine();
                }
                if (line == null || !line.startsWith(HISTO_HEADER)) break block30;
                String keyClassName = line.split(SEPARATOR)[1].trim();
                Class<?> keyClass = null;
                try {
                    keyClass = this.loadClass(keyClassName, true);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new PicardException("Could not load class with name " + keyClassName);
                }
                String[] labels = in.readLine().split(SEPARATOR);
                int i = 1;
                while (i < labels.length) {
                    this.histograms.add(new Histogram(labels[0], labels[i]));
                    ++i;
                }
                while ((line = in.readLine()) != null && !"".equals(line)) {
                    String[] fields = line.trim().split(SEPARATOR);
                    Comparable key = (Comparable)formatter.parseObject(fields[0], keyClass);
                    int i3 = 1;
                    while (i3 < fields.length) {
                        double value = formatter.parseDouble(fields[i3]);
                        this.histograms.get(i3 - 1).increment(key, value);
                        ++i3;
                    }
                }
            }
            catch (IOException ioe) {
                throw new PicardException("Could not read metrics from reader.", ioe);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private Class<?> loadClass(String className, boolean tryOtherPackages) throws ClassNotFoundException {
        block8: {
            packages = new String[]{"edu.mit.broad.picard.genotype.concordance", "edu.mit.broad.picard.genotype.fingerprint", "edu.mit.broad.picard.ic", "edu.mit.broad.picard.illumina", "edu.mit.broad.picard.jumping", "edu.mit.broad.picard.quality", "edu.mit.broad.picard.samplevalidation", "net.sf.picard.analysis", "net.sf.picard.analysis.directed", "net.sf.picard.sam", "net.sf.picard.metrics"};
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                if (!tryOtherPackages) break block8;
                var8_5 = packages;
                var7_6 = packages.length;
                var6_7 = 0;
                ** while (var6_7 < var7_6)
            }
lbl-1000:
            // 1 sources

            {
                p = var8_5[var6_7];
                try {
                    return this.loadClass(String.valueOf(p) + className.substring(className.lastIndexOf(".")), false);
                }
                catch (ClassNotFoundException var9_10) {
                    if (className.indexOf("$") > -1) {
                        try {
                            return this.loadClass(String.valueOf(p) + "." + className.substring(className.lastIndexOf("$") + 1), false);
                        }
                        catch (ClassNotFoundException var9_11) {
                            // empty catch block
                        }
                    }
                    ++var6_7;
                }
                continue;
            }
        }
        throw cnfe;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        MetricsFile that = (MetricsFile)o;
        if (!this.areHeadersEqual(that)) {
            return false;
        }
        if (!this.areMetricsEqual(that)) {
            return false;
        }
        return this.areHistogramsEqual(that);
    }

    public boolean areHeadersEqual(MetricsFile that) {
        return this.headers.equals(that.headers);
    }

    public boolean areMetricsEqual(MetricsFile that) {
        return this.metrics.equals(that.metrics);
    }

    public boolean areHistogramsEqual(MetricsFile that) {
        return this.histograms.equals(that.histograms);
    }

    public int hashCode() {
        int result = this.headers.hashCode();
        result = 31 * result + this.metrics.hashCode();
        return result;
    }

    public static List<? extends MetricBase> readBeans(File file) {
        try {
            MetricsFile metricsFile = new MetricsFile();
            metricsFile.read(new FileReader(file));
            return metricsFile.getMetrics();
        }
        catch (FileNotFoundException e) {
            throw new PicardException(e.getMessage(), e);
        }
    }
}

