/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import net.sf.picard.metrics.Header;
import net.sf.samtools.util.StringUtil;

public class VersionHeader
implements Header {
    private String versionedItem;
    private String versionString;

    @Override
    public void parse(String in) {
        String[] fields = in.split("\t");
        this.versionedItem = fields[0];
        this.versionString = fields[1];
    }

    @Override
    public String toString() {
        return String.valueOf(this.versionedItem) + "\t" + this.versionString;
    }

    public String getVersionedItem() {
        return this.versionedItem;
    }

    public void setVersionedItem(String versionedItem) {
        this.versionedItem = StringUtil.assertCharactersNotInString(versionedItem, '\t', '\n');
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setVersionString(String versionString) {
        this.versionString = StringUtil.assertCharactersNotInString(versionString, '\t', '\n');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionHeader that = (VersionHeader)o;
        if (this.versionString != null ? !this.versionString.equals(that.versionString) : that.versionString != null) {
            return false;
        }
        return !(this.versionedItem != null ? !this.versionedItem.equals(that.versionedItem) : that.versionedItem != null);
    }

    public int hashCode() {
        int result = this.versionedItem != null ? this.versionedItem.hashCode() : 0;
        result = 31 * result + (this.versionString != null ? this.versionString.hashCode() : 0);
        return result;
    }
}

