/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import net.sf.picard.metrics.MetricBase;
import net.sf.picard.util.Histogram;

public class DuplicationMetrics
extends MetricBase {
    public String LIBRARY;
    public long UNPAIRED_READS_EXAMINED;
    public long READ_PAIRS_EXAMINED;
    public long UNMAPPED_READS;
    public long UNPAIRED_READ_DUPLICATES;
    public long READ_PAIR_DUPLICATES;
    public long READ_PAIR_OPTICAL_DUPLICATES;
    public Double PERCENT_DUPLICATION;
    public Long ESTIMATED_LIBRARY_SIZE;

    public void calculateDerivedMetrics() {
        this.ESTIMATED_LIBRARY_SIZE = DuplicationMetrics.estimateLibrarySize(this.READ_PAIRS_EXAMINED - this.READ_PAIR_OPTICAL_DUPLICATES, this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES);
        this.PERCENT_DUPLICATION = (double)(this.UNPAIRED_READ_DUPLICATES + this.READ_PAIR_DUPLICATES * 2L) / (double)(this.UNPAIRED_READS_EXAMINED + this.READ_PAIRS_EXAMINED * 2L);
    }

    /*
     * Unable to fully structure code
     */
    public static Long estimateLibrarySize(long readPairs, long uniqueReadPairs) {
        block5: {
            readPairDuplicates = readPairs - uniqueReadPairs;
            if (readPairs <= 0L || readPairDuplicates <= 0L) break block5;
            n = readPairs;
            c = uniqueReadPairs;
            m = 1.0;
            M = 100.0;
            if (c < n && !(DuplicationMetrics.f(m * (double)c, c, n) < 0.0)) ** GOTO lbl10
            throw new IllegalStateException("Invalid values for pairs and unique pairs: " + n + ", " + c);
lbl-1000:
            // 1 sources

            {
                M *= 10.0;
lbl10:
                // 2 sources

                ** while (DuplicationMetrics.f((double)(M * (double)c), (double)((double)c), (double)((double)n)) >= 0.0)
            }
lbl11:
            // 1 sources

            i = 0;
            while (i < 40) {
                r = (m + M) / 2.0;
                u = DuplicationMetrics.f(r * (double)c, c, n);
                if (u == 0.0) break;
                if (u > 0.0) {
                    m = r;
                } else if (u < 0.0) {
                    M = r;
                }
                ++i;
            }
            return (long)((double)c * (m + M) / 2.0);
        }
        return null;
    }

    private static double f(double x, double c, double n) {
        return c / x - 1.0 + Math.exp(-n / x);
    }

    public static double estimateRoi(long estimatedLibrarySize, double x, long pairs, long uniquePairs) {
        return (double)estimatedLibrarySize * (1.0 - Math.exp(-(x * (double)pairs) / (double)estimatedLibrarySize)) / (double)uniquePairs;
    }

    public Histogram<Double> calculateRoiHistogram() {
        if (this.ESTIMATED_LIBRARY_SIZE == null) {
            try {
                this.calculateDerivedMetrics();
                if (this.ESTIMATED_LIBRARY_SIZE == null) {
                    return null;
                }
            }
            catch (IllegalStateException ise) {
                return null;
            }
        }
        long uniquePairs = this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES;
        Histogram<Double> histo = new Histogram<Double>();
        double x = 1.0;
        while (x <= 100.0) {
            histo.increment(x, DuplicationMetrics.estimateRoi(this.ESTIMATED_LIBRARY_SIZE, x, this.READ_PAIRS_EXAMINED, uniquePairs));
            x += 1.0;
        }
        return histo;
    }

    public static void main(String[] args) {
        DuplicationMetrics m = new DuplicationMetrics();
        m.READ_PAIRS_EXAMINED = Integer.parseInt(args[0]);
        m.READ_PAIR_DUPLICATES = Integer.parseInt(args[1]);
        m.calculateDerivedMetrics();
        System.out.println("Percent Duplication: " + m.PERCENT_DUPLICATION);
        System.out.println("Est. Library Size  : " + m.ESTIMATED_LIBRARY_SIZE);
        System.out.println();
        System.out.println("X Seq\tX Unique");
        for (Histogram.Bin bin : m.calculateRoiHistogram().values()) {
            System.out.println(bin.getId() + "\t" + bin.getValue());
        }
    }
}

