/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class SortSam
extends CommandLineProgram {
    @Usage
    public String USAGE = String.valueOf(this.getStandardUsagePreamble()) + "Sorts the input SAM or BAM.\n" + "Input and output formats are determined by file extension.";
    @Option(doc="The BAM or SAM file to sort.", shortName="I")
    public File INPUT;
    @Option(doc="The sorted BAM or SAM output file. ", shortName="O")
    public File OUTPUT;
    @Option(shortName="SO", doc="Sort order of output file")
    public SAMFileHeader.SortOrder SORT_ORDER;
    private final Log log = Log.getInstance(SortSam.class);

    @Override
    protected int doWork() {
        long n = 0L;
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader reader = new SAMFileReader(IoUtil.openFileForReading(this.INPUT));
        reader.getFileHeader().setSortOrder(this.SORT_ORDER);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), false, this.OUTPUT);
        SAMRecordIterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            writer.addAlignment((SAMRecord)iterator.next());
            if (++n % 10000000L != 0L) continue;
            this.log.info("Read " + n + " records.");
        }
        this.log.info("Finished reading inputs, merging and writing to output now.");
        reader.close();
        writer.close();
        return 0;
    }

    public static void main(String[] argv) {
        new SortSam().instanceMainWithExit(argv);
    }
}

