/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.samtools.util.CloseableIterator;

public class AsyncIterator<T>
implements CloseableIterator<T> {
    private static volatile int threadsCreated = 0;
    public static final int DEFAULT_QUEUE_SIZE = 2000;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final BlockingQueue<T> queue;
    private final Thread reader;
    private final ReaderRunnable readerRunnable;
    private final AtomicReference<Throwable> ex = new AtomicReference<Object>(null);
    private T theNext = null;
    private final CloseableIterator<T> underlyingIterator;

    public AsyncIterator(CloseableIterator<T> underlyingIterator, int queueSize, String threadNamePrefix) {
        this.underlyingIterator = underlyingIterator;
        this.queue = new ArrayBlockingQueue<T>(queueSize);
        this.readerRunnable = new ReaderRunnable();
        this.reader = new Thread((Runnable)this.readerRunnable, String.valueOf(threadNamePrefix) + threadsCreated++);
        this.reader.setDaemon(true);
        this.reader.start();
        this.getNext();
    }

    private void getNext() {
        this.assertOpen();
        this.checkAndRethrow();
        try {
            this.theNext = null;
            while (!this.queue.isEmpty() || !this.readerRunnable.isDone()) {
                this.theNext = this.queue.poll(5L, TimeUnit.SECONDS);
                this.checkAndRethrow();
                if (this.theNext == null) {
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Interrupted queueing item for writing.", ie);
        }
        this.checkAndRethrow();
    }

    @Override
    public boolean hasNext() {
        this.assertOpen();
        return this.theNext != null;
    }

    @Override
    public T next() {
        this.assertOpen();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T ret = this.theNext;
        this.getNext();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.checkAndRethrow();
        this.assertOpen();
        this.isClosed.set(true);
        try {
            this.reader.join();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Interrupted waiting on reader thread.", ie);
        }
        this.underlyingIterator.close();
        this.checkAndRethrow();
        this.queue.clear();
    }

    private void assertOpen() {
        if (this.isClosed.get()) {
            throw new RuntimeException("AsyncIterator already closed.");
        }
    }

    private void checkAndRethrow() {
        Throwable t = this.ex.get();
        if (t != null) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private class ReaderRunnable
    implements Runnable {
        private final AtomicBoolean readerDone = new AtomicBoolean(false);

        private ReaderRunnable() {
        }

        public boolean isDone() {
            return this.readerDone.get();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {
                    boolean isEof = false;
                    block7: while (!AsyncIterator.this.isClosed.get()) {
                        if (isEof) {
                            return;
                        }
                        try {
                            if (!AsyncIterator.this.underlyingIterator.hasNext()) {
                                isEof = true;
                                continue;
                            }
                            Object item = AsyncIterator.this.underlyingIterator.next();
                            do {
                                if (AsyncIterator.this.isClosed.get()) continue block7;
                            } while (!AsyncIterator.this.queue.offer(item, 2L, TimeUnit.SECONDS));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (Throwable t) {
                    AsyncIterator.this.ex.compareAndSet(null, t);
                    this.readerDone.set(true);
                    return;
                }
            }
            finally {
                this.readerDone.set(true);
            }
        }
    }
}

