/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import net.sf.picard.util.AdapterPair;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;

public class ClippingUtility {
    public static final int MIN_MATCH_BASES = 12;
    public static final int MIN_MATCH_PE_BASES = 6;
    public static final double MAX_ERROR_RATE = 0.1;
    public static final double MAX_PE_ERROR_RATE = 0.1;
    public static final int NO_MATCH = -1;
    private static final Log log = Log.getInstance(ClippingUtility.class);

    public static void adapterTrimIlluminaSingleRead(SAMRecord read, AdapterPair adapter) {
        ClippingUtility.adapterTrimIlluminaSingleRead(read, 12, 0.1, adapter);
    }

    public static void adapterTrimIlluminaSingleRead(SAMRecord read, AdapterPair adapter, int minMatchBases, double maxErrorRate) {
        ClippingUtility.adapterTrimIlluminaSingleRead(read, minMatchBases, maxErrorRate, adapter);
    }

    public static AdapterPair adapterTrimIlluminaSingleRead(SAMRecord read, AdapterPair ... adapters) {
        return ClippingUtility.adapterTrimIlluminaSingleRead(read, 12, 0.1, adapters);
    }

    public static AdapterPair adapterTrimIlluminaSingleRead(SAMRecord read, int minMatchBases, double maxErrorRate, AdapterPair ... adapters) {
        AdapterPair[] adapterPairArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            AdapterPair adapter = adapterPairArray[n2];
            int indexOfAdapterSequence = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(read), adapter.get3PrimeAdapterBytes(), minMatchBases, maxErrorRate);
            if (indexOfAdapterSequence != -1) {
                read.setAttribute("XT", (Object)(indexOfAdapterSequence + 1));
                return adapter;
            }
            ++n2;
        }
        return null;
    }

    public static String adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, AdapterPair adapters) {
        ClippingUtility.adapterTrimIlluminaPairedReads(read1, read2, 6, 0.1, adapters);
        return null;
    }

    public static String adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, AdapterPair adapters, int minMatchBases, double maxErrorRate) {
        ClippingUtility.adapterTrimIlluminaPairedReads(read1, read2, minMatchBases, maxErrorRate, adapters);
        return null;
    }

    public static AdapterPair adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, AdapterPair ... adapters) {
        return ClippingUtility.adapterTrimIlluminaPairedReads(read1, read2, 6, 0.1, adapters);
    }

    public static AdapterPair adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, int minMatchBases, double maxErrorRate, AdapterPair ... adapters) {
        AdapterPair matched = null;
        AdapterPair[] adapterPairArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            int index2;
            AdapterPair adapterPair = adapterPairArray[n2];
            int index1 = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(read1), adapterPair.get3PrimeAdapterBytes(), minMatchBases, maxErrorRate);
            if (index1 == (index2 = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(read2), adapterPair.get5PrimeAdapterBytesInReadOrder(), minMatchBases, maxErrorRate))) {
                if (index1 != -1) {
                    read1.setAttribute("XT", (Object)(index1 + 1));
                    read2.setAttribute("XT", (Object)(index2 + 1));
                    return adapterPair;
                }
            } else if ((index1 == -1 || index2 == -1) && ClippingUtility.attemptOneSidedMatch(read1, read2, index1, index2, 2 * minMatchBases)) {
                matched = adapterPair;
            }
            ++n2;
        }
        return matched;
    }

    private static boolean attemptOneSidedMatch(SAMRecord read1, SAMRecord read2, int index1, int index2, int stricterMinMatchBases) {
        SAMRecord matchedRead;
        int matchedIndex = index1 == -1 ? index2 : index1;
        SAMRecord sAMRecord = matchedRead = index1 == -1 ? read2 : read1;
        if (matchedRead.getReadLength() - matchedIndex >= stricterMinMatchBases) {
            if (read1.getReadBases().length > matchedIndex) {
                read1.setAttribute("XT", (Object)(matchedIndex + 1));
            }
            if (read2.getReadBases().length > matchedIndex) {
                read2.setAttribute("XT", (Object)(matchedIndex + 1));
            }
            return true;
        }
        return false;
    }

    private static byte[] getReadBases(SAMRecord read) {
        if (!read.getReadNegativeStrandFlag()) {
            return read.getReadBases();
        }
        byte[] reverseComplementedBases = new byte[read.getReadBases().length];
        System.arraycopy(read.getReadBases(), 0, reverseComplementedBases, 0, reverseComplementedBases.length);
        SequenceUtil.reverseComplement(reverseComplementedBases);
        return reverseComplementedBases;
    }

    public static int findIndexOfClipSequence(byte[] read, byte[] adapterSequence, int minMatch, double maxErrorRate) {
        if (read == null || read.length < minMatch) {
            return -1;
        }
        boolean minClipPosition = false;
        int start = read.length - minMatch;
        while (start > -1) {
            block4: {
                int length = Math.min(read.length - start, adapterSequence.length);
                int mismatchesAllowed = (int)((double)length * maxErrorRate);
                int mismatches = 0;
                int i = 0;
                while (i < length) {
                    if (SequenceUtil.isNoCall(adapterSequence[i]) || SequenceUtil.basesEqual(adapterSequence[i], read[start + i]) || ++mismatches <= mismatchesAllowed) {
                        ++i;
                        continue;
                    }
                    break block4;
                }
                return start;
            }
            --start;
        }
        return -1;
    }
}

