/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class Histogram<K extends Comparable>
extends TreeMap<K, Bin> {
    private String binLabel = "BIN";
    private String valueLabel = "VALUE";
    private Double mean;

    public Histogram() {
    }

    public Histogram(String binLabel, String valueLabel) {
        this.binLabel = binLabel;
        this.valueLabel = valueLabel;
    }

    public Histogram(Comparator<K> comparator) {
        super(comparator);
    }

    public Histogram(String binLabel, String valueLabel, Comparator<K> comparator) {
        this(comparator);
        this.binLabel = binLabel;
        this.valueLabel = valueLabel;
    }

    public Histogram(Histogram<K> in) {
        super(in);
        this.binLabel = in.binLabel;
        this.valueLabel = in.valueLabel;
        this.mean = in.mean;
    }

    public void prefillBins(K ... ids) {
        K[] KArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            K id = KArray[n2];
            this.put(id, new Bin(this, (Comparable)id));
            ++n2;
        }
    }

    public void increment(K id) {
        this.increment(id, 1.0);
    }

    public void increment(K id, double increment) {
        Bin bin = (Bin)this.get(id);
        if (bin == null) {
            bin = new Bin(this, (Comparable)id);
            this.put(id, bin);
        }
        Bin bin2 = bin;
        bin2.value = bin2.value + increment;
        this.mean = null;
    }

    public String getBinLabel() {
        return this.binLabel;
    }

    public void setBinLabel(String binLabel) {
        this.binLabel = binLabel;
    }

    public String getValueLabel() {
        return this.valueLabel;
    }

    public void setValueLabel(String valueLabel) {
        this.valueLabel = valueLabel;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof Histogram && ((Histogram)o).binLabel.equals(this.binLabel) && ((Histogram)o).valueLabel.equals(this.valueLabel) && super.equals(o);
    }

    public double getMean() {
        if (this.mean == null) {
            this.mean = this.getSum() / this.getCount();
        }
        return this.mean;
    }

    public double getSum() {
        double total = 0.0;
        for (Bin bin : this.values()) {
            total += bin.getValue() * bin.getIdValue();
        }
        return total;
    }

    public double getSumOfValues() {
        double total = 0.0;
        for (Bin bin : this.values()) {
            total += bin.getValue();
        }
        return total;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        double count = 0.0;
        double total = 0.0;
        for (Bin bin : this.values()) {
            double localCount = bin.getValue();
            double value = bin.getIdValue();
            count += localCount;
            total += localCount * Math.pow(value - mean, 2.0);
        }
        return Math.sqrt(total / (count - 1.0));
    }

    public double getMeanBinSize() {
        return this.getSumOfValues() / (double)this.size();
    }

    public double getStandardDeviationBinSize(double mean) {
        double total = 0.0;
        for (Bin bin : this.values()) {
            total += Math.pow(bin.getValue() - mean, 2.0);
        }
        return Math.sqrt(total / (double)Math.max(1, this.values().size() - 1));
    }

    public double getPercentile(double percentile) {
        if (percentile <= 0.0) {
            throw new IllegalArgumentException("Cannot query percentiles of 0 or below");
        }
        if (percentile >= 1.0) {
            throw new IllegalArgumentException("Cannot query percentiles of 1 or above");
        }
        double total = this.getCount();
        double sofar = 0.0;
        for (Bin bin : this.values()) {
            if (!((sofar += bin.getValue()) / total >= percentile)) continue;
            return bin.getIdValue();
        }
        throw new IllegalStateException("Could not find percentile: " + percentile);
    }

    public double getCumulativeProbability(double v) {
        double count = 0.0;
        double total = 0.0;
        for (Bin bin : this.values()) {
            double binValue = bin.getIdValue();
            if (binValue <= v) {
                count += bin.getValue();
            }
            total += bin.getValue();
        }
        return count / total;
    }

    public double getMedian() {
        double midHigh;
        double midLow;
        double total = 0.0;
        double count = this.getCount();
        if (count == 0.0) {
            return 0.0;
        }
        if (count == 1.0) {
            return ((Bin)this.values().iterator().next()).getIdValue();
        }
        if (count % 2.0 == 0.0) {
            midLow = count / 2.0;
            midHigh = midLow + 1.0;
        } else {
            midHigh = midLow = Math.ceil(count / 2.0);
        }
        Double midLowValue = null;
        Double midHighValue = null;
        for (Bin bin : this.values()) {
            total += bin.getValue();
            if (midLowValue == null && total >= midLow) {
                midLowValue = bin.getIdValue();
            }
            if (midHighValue == null && total >= midHigh) {
                midHighValue = bin.getIdValue();
            }
            if (midLowValue != null && midHighValue != null) break;
        }
        return (midLowValue + midHighValue) / 2.0;
    }

    public double getMedianAbsoluteDeviation() {
        double median = this.getMedian();
        Histogram<Double> deviations = new Histogram<Double>();
        for (Bin bin : this.values()) {
            double dev = Math.abs(bin.getIdValue() - median);
            deviations.increment(dev, bin.getValue());
        }
        return deviations.getMedian();
    }

    public double estimateSdViaMad() {
        return 1.4826 * this.getMedianAbsoluteDeviation();
    }

    public double getMode() {
        return this.getModeBin().getIdValue();
    }

    private Bin getModeBin() {
        Bin modeBin = null;
        for (Bin bin : this.values()) {
            if (modeBin != null && !(modeBin.value < bin.value)) continue;
            modeBin = bin;
        }
        return modeBin;
    }

    public double getMin() {
        return ((Bin)this.firstEntry().getValue()).getIdValue();
    }

    public double getMax() {
        return ((Bin)this.lastEntry().getValue()).getIdValue();
    }

    public double getCount() {
        double count = 0.0;
        for (Bin bin : this.values()) {
            count += bin.value;
        }
        return count;
    }

    public double getGeometricMean() {
        double total = 0.0;
        double count = 0.0;
        for (Bin bin : this.values()) {
            total += bin.value * Math.log(bin.getIdValue());
            count += bin.value;
        }
        return Math.exp(total / count);
    }

    public void trimByTailLimit(int tailLimit) {
        Object[] keys;
        if (this.isEmpty()) {
            return;
        }
        Bin modeBin = this.getModeBin();
        double mode = modeBin.getIdValue();
        double sizeOfModeBin = modeBin.getValue();
        double minimumBinSize = sizeOfModeBin / (double)tailLimit;
        Bin lastBin = null;
        ArrayList binsToKeep = new ArrayList();
        for (Bin bin : this.values()) {
            double binId = ((Number)bin.getId()).doubleValue();
            if (binId <= mode) {
                binsToKeep.add(bin.getId());
            } else {
                if (lastBin != null && ((Number)lastBin.getId()).doubleValue() != binId - 1.0 || bin.getValue() < minimumBinSize) break;
                binsToKeep.add(bin.getId());
            }
            lastBin = bin;
        }
        Object[] objectArray = keys = this.keySet().toArray();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object binId = objectArray[n2];
            if (!binsToKeep.contains((Comparable)binId)) {
                this.remove(binId);
            }
            ++n2;
        }
    }

    public void trimByWidth(int width) {
        Iterator it = this.descendingKeySet().iterator();
        while (it.hasNext()) {
            if (!(((Number)it.next()).doubleValue() > (double)width)) break;
            it.remove();
        }
    }

    public Histogram<K> divideByHistogram(Histogram<K> divisorHistogram) throws IllegalArgumentException {
        Histogram<Comparable> output = new Histogram<Comparable>();
        if (!this.keySet().equals(divisorHistogram.keySet())) {
            throw new IllegalArgumentException("Attempting to divide Histograms with non-identical bins");
        }
        for (Comparable key : this.keySet()) {
            Bin dividend = (Bin)this.get(key);
            Bin divisor = (Bin)divisorHistogram.get(key);
            output.increment(key, dividend.getValue() / divisor.getValue());
        }
        return output;
    }

    public void addHistogram(Histogram<K> addHistogram) {
        for (Comparable key : addHistogram.keySet()) {
            this.increment(key, ((Bin)addHistogram.get(key)).getValue());
        }
    }

    public static class Bin {
        private final K id;
        private double value = 0.0;
        final /* synthetic */ Histogram this$0;

        private Bin(K id) {
            this.this$0 = var1_1;
            this.id = id;
        }

        public K getId() {
            return this.id;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bin bin = (Bin)o;
            if (Double.compare(bin.value, this.value) != 0) {
                return false;
            }
            return this.id.equals(bin.id);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public double getIdValue() {
            if (this.id instanceof Number) {
                return ((Number)this.id).doubleValue();
            }
            throw new UnsupportedOperationException("getIdValue only supported for Histogram<? extends Number>");
        }
    }
}

