/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.util.AdapterPair;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.SolexaQualityConverter;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class IlluminaUtil {
    public static final String BARCODE_DELIMITER = "-";

    public static String makeReadName(String runBarcode, int lane, int tile, int xCoordinate, int yCoordinate) {
        return String.valueOf(runBarcode) + ":" + lane + ":" + tile + ":" + xCoordinate + ":" + yCoordinate;
    }

    public static Integer getTileFromReadName(String readName) {
        int third;
        int second;
        int first = readName.indexOf(58);
        if (first > 0 && (second = readName.indexOf(58, first + 1)) > 0 && (third = readName.indexOf(58, second + 1)) > 0) {
            return Integer.parseInt(readName.substring(second + 1, third));
        }
        return null;
    }

    public static byte[] makePhredBinaryFromSolexaQualityAscii_1_3(String solexaQualities) {
        return IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(solexaQualities, 0, solexaQualities.length());
    }

    public static byte[] makePhredBinaryFromSolexaQualityAscii_1_3(String solexaQualities, int offset, int length) {
        byte[] quals = StringUtil.stringToBytes(solexaQualities, offset, length);
        SolexaQualityConverter.getSingleton().convertSolexa_1_3_QualityCharsToPhredBinary(quals);
        return quals;
    }

    public static void convertSolexaQualityAscii_1_1_ToPhredBinary(byte[] solexaQualities) {
        SolexaQualityConverter.getSingleton().convertSolexaQualityCharsToPhredBinary(solexaQualities);
    }

    public static byte getSolexaQualityCharFromFourQualities(String[] qualities, int cycleNumber, FormatUtil formatter) {
        int startOffset;
        int bestQuality = Integer.MIN_VALUE;
        int i = startOffset = (cycleNumber - 1) * 4;
        while (i < startOffset + 4) {
            int quality = formatter.parseInt(qualities[i]);
            if (quality > bestQuality) {
                bestQuality = quality;
            }
            ++i;
        }
        int qualityAsCharacter = bestQuality + 64;
        if (qualityAsCharacter > 255) {
            throw new PicardException("Quality too large: " + bestQuality);
        }
        return (byte)(qualityAsCharacter & 0xFF);
    }

    public static String barcodeSeqsToString(List<String> barcodes) {
        return IlluminaUtil.barcodeSeqsToString(barcodes.toArray(new String[barcodes.size()]));
    }

    public static String barcodeSeqsToString(String[] barcodes) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = barcodes;
        int n = barcodes.length;
        int n2 = 0;
        while (n2 < n) {
            String bc = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(BARCODE_DELIMITER);
            }
            sb.append(bc);
            ++n2;
        }
        return sb.toString();
    }

    public static String barcodeSeqsToString(byte[][] barcodes) {
        String[] bcs = new String[barcodes.length];
        int i = 0;
        while (i < barcodes.length) {
            bcs[i] = StringUtil.bytesToString(barcodes[i]);
            ++i;
        }
        return IlluminaUtil.barcodeSeqsToString(bcs);
    }

    public static enum IlluminaAdapterPair implements AdapterPair
    {
        PAIRED_END("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCGGTTCAGCAGGAATGCCGAGACCGATCTCGTATGCCGTCTTCTGCTTG"),
        INDEXED("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCACACGTCTGAACTCCAGTCACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        SINGLE_END("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCTCGTATGCCGTCTTCTGCTTG"),
        ALTERNATIVE_SINGLE_END("AATGATACGGCGACCACCGACAGGTTCAGAGTTCTACAGTCCGACGATC", "TCGTATGCCGTCTTCTGCTTG"),
        NEXTERA_V1("AATGATACGGCGACCACCGAGATCTACACGCCTCCCTCGCGCCATCAGAGATGTGTATAAGAGACAG", "CTGTCTCTTATACACATCTCTGAGCGGGCTGGCAAGGCAGACCGNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        NEXTERA_V2("AATGATACGGCGACCACCGAGATCTACACNNNNNNNNTCGTCGGCAGCGTCAGATGTGTATAAGAGACAG", "CTGTCTCTTATACACATCTCCGAGCCCACGAGACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        DUAL_INDEXED("AATGATACGGCGACCACCGAGATCTNNNNNNNNACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCACACGTCTGAACTCCAGTCACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG");

        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private IlluminaAdapterPair(String fivePrime, String threePrime) {
            this.threePrime = threePrime;
            this.threePrimeBytes = StringUtil.stringToBytes(threePrime);
            this.fivePrime = fivePrime;
            this.fivePrimeReadOrder = SequenceUtil.reverseComplement(fivePrime);
            this.fivePrimeBytes = StringUtil.stringToBytes(fivePrime);
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes(this.fivePrimeReadOrder);
        }

        @Override
        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        @Override
        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        @Override
        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        @Override
        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

