/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.util.SequenceUtil;

public class IntervalListTools
extends CommandLineProgram {
    @Usage
    public final String USAGE = String.valueOf(this.getStandardUsagePreamble()) + " General tool for manipulating interval lists, " + "including sorting, merging, padding, uniqueifying. Default operation if given one or more inputs is to " + "merge and sort them.  Other options are controlled by arguments.";
    @Option(shortName="I", doc="One or more interval lists. If multiple interval lists are provided the output is theresult of merging the inputs.")
    public List<File> INPUT;
    @Option(doc="The output interval list file to write", shortName="O", optional=true)
    public File OUTPUT;
    @Option(doc="The amount to pad each end of the intervals by before other operations are undertaken. Negative numbers are allowed and indicate intervals should be shrunk. Resulting intervals < 0 bases long will be removed.", optional=true)
    public int PADDING = 0;
    @Option(doc="If true, merge overlapping and adjacent intervals to create a list of unique intervals. Implies SORT=true")
    public boolean UNIQUE = false;
    @Option(doc="If true, sort the resulting interval list by coordinate.")
    public boolean SORT = true;
    @Option(doc="One or more lines of comment to add to the header of the output file.", optional=true)
    public List<String> COMMENT = null;
    private final Log log = Log.getInstance(IntervalListTools.class);

    public static void main(String[] args) {
        new IntervalListTools().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        for (File f : this.INPUT) {
            IoUtil.assertFileIsReadable(f);
        }
        if (this.OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
        }
        ArrayList<Object> lists = new ArrayList<Object>();
        for (File f : this.INPUT) {
            IntervalList list = IntervalList.fromFile(f);
            if (this.PADDING != 0) {
                IntervalList out = new IntervalList(list.getHeader());
                Iterator<Object> iterator = list.iterator();
                while (iterator.hasNext()) {
                    int end;
                    Interval i = iterator.next();
                    int start = i.getStart() - this.PADDING;
                    if (start > (end = i.getEnd() + this.PADDING)) continue;
                    Interval i2 = new Interval(i.getSequence(), start, end, i.isNegativeStrand(), i.getName());
                    out.add(i2);
                }
                lists.add(out);
                continue;
            }
            lists.add(list);
        }
        if (this.UNIQUE && !this.SORT) {
            this.log.warn("UNIQUE=true requires sorting but SORT=false was specified.  Sorting anyway!");
            this.SORT = true;
        }
        IntervalList merged = null;
        for (IntervalList intervalList : lists) {
            if (merged == null) {
                merged = intervalList;
                continue;
            }
            SequenceUtil.assertSequenceDictionariesEqual(merged.getHeader().getSequenceDictionary(), intervalList.getHeader().getSequenceDictionary());
            for (Interval i : intervalList) {
                merged.add(i);
            }
        }
        if (this.SORT) {
            merged.sort();
        }
        List<Interval> list = this.UNIQUE ? merged.getUniqueIntervals() : merged.getIntervals();
        SAMFileHeader header = merged.getHeader();
        HashSet<String> pgs = new HashSet<String>();
        for (SAMProgramRecord pg : header.getProgramRecords()) {
            pgs.add(pg.getId());
        }
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            if (!pgs.contains(String.valueOf(i))) {
                SAMProgramRecord pg = new SAMProgramRecord(String.valueOf(i));
                pg.setCommandLine(this.getCommandLine());
                pg.setProgramName(this.getClass().getSimpleName());
                header.addProgramRecord(pg);
                break;
            }
            ++i;
        }
        if (this.COMMENT != null) {
            for (String comment : this.COMMENT) {
                header.addComment(comment);
            }
        }
        IntervalList output = new IntervalList(header);
        for (Interval i2 : list) {
            output.add(i2);
        }
        if (this.OUTPUT != null) {
            output.write(this.OUTPUT);
        }
        long total = 0L;
        for (Interval i3 : output) {
            total += (long)i3.length();
        }
        this.log.info("Output " + output.size() + " intervals totalling " + total + " bases.");
        return 0;
    }
}

